/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.blocks.bundle;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import mcjty.immcraft.api.cable.ICableItemBlockHelper;
import mcjty.immcraft.api.cable.ICableSubType;
import mcjty.immcraft.api.cable.ICableType;
import mcjty.immcraft.blocks.ModBlocks;
import mcjty.immcraft.blocks.bundle.BundleBlock;
import mcjty.immcraft.blocks.bundle.BundleTE;
import mcjty.immcraft.cables.CableSection;
import mcjty.immcraft.varia.BlockTools;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CableItemBlockHelper
implements ICableItemBlockHelper {
    private final ICableType type;
    private final ICableSubType subType;

    public CableItemBlockHelper(ICableType type, ICableSubType subType) {
        this.type = type;
        this.subType = subType;
    }

    @Override
    public boolean onItemUse(EntityPlayer player, World world, BlockPos pos) {
        RayTraceResult movingObjectPosition;
        BundleTE bundleTE;
        Block block;
        if (!world.field_72995_K && (block = world.func_180495_p(pos).func_177230_c()) == ModBlocks.bundleBlock && (bundleTE = BlockTools.getTE(BundleTE.class, (IBlockAccess)world, pos).get()).countCableEndPoints(this.type, this.subType) == 0 && (movingObjectPosition = this.getMovingObjectPositionFromPlayer(world, player, false)) != null) {
            EnumFacing side = movingObjectPosition.field_178784_b;
            float hitX = (float)movingObjectPosition.field_72307_f.field_72450_a - (float)movingObjectPosition.func_178782_a().func_177958_n();
            float hitY = (float)movingObjectPosition.field_72307_f.field_72448_b - (float)movingObjectPosition.func_178782_a().func_177956_o();
            float hitZ = (float)movingObjectPosition.field_72307_f.field_72449_c - (float)movingObjectPosition.func_178782_a().func_177952_p();
            this.addCable(world, pos, side, hitX, hitY, hitZ);
            return false;
        }
        return true;
    }

    private RayTraceResult getMovingObjectPositionFromPlayer(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        double x = playerIn.field_70165_t;
        double y = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double z = playerIn.field_70161_v;
        Vec3d vec3 = new Vec3d(x, y, z);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            reach = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec31 = vec3.func_72441_c((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return worldIn.func_147447_a(vec3, vec31, useLiquids, !useLiquids, false);
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            IBlockState state;
            BundleBlock block = ModBlocks.bundleBlock;
            boolean placed = false;
            if (world.func_180495_p(pos).func_177230_c() != block) {
                placed = true;
                if (!world.func_180501_a(pos, block.func_176223_P(), 3)) {
                    return false;
                }
            }
            if ((state = world.func_180495_p(pos)).func_177230_c() == block) {
                if (placed) {
                    block.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
                }
                this.addCable(world, pos, side, hitX, hitY, hitZ);
            }
        }
        return true;
    }

    private void addCable(World world, BlockPos pos, EnumFacing directionHit, float hitX, float hitY, float hitZ) {
        Vec3d vector;
        BlockPos adjacentC = pos.func_177972_a(directionHit.func_176734_d());
        if (world.isSideSolid(adjacentC, directionHit)) {
            vector = new Vec3d((double)((float)adjacentC.func_177958_n() + hitX + (float)directionHit.func_176730_m().func_177958_n() / 10.0f), (double)((float)adjacentC.func_177956_o() + hitY + (float)directionHit.func_176730_m().func_177956_o() / 10.0f), (double)((float)adjacentC.func_177952_p() + hitZ + (float)directionHit.func_176730_m().func_177952_p() / 10.0f));
        } else {
            CableSection connectableSection;
            Set<Integer> excluded = Collections.emptySet();
            vector = new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
            Optional<BundleTE> bundleTE = BlockTools.getTE(BundleTE.class, (IBlockAccess)world, adjacentC);
            if (bundleTE.isPresent() && (connectableSection = bundleTE.get().findConnectableSection(this.type, this.subType, excluded)) != null) {
                vector = connectableSection.getVector().func_72441_c((double)directionHit.func_176730_m().func_177958_n(), (double)directionHit.func_176730_m().func_177956_o(), (double)directionHit.func_176730_m().func_177952_p());
            }
        }
        Vec3d finalVector = vector;
        BlockTools.getTE(BundleTE.class, (IBlockAccess)world, pos).ifPresent(p -> p.addCableToNetwork(this.type, this.subType, finalVector));
    }
}

