/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.api.rendering;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.immcraft.api.IImmersiveCraft;
import mcjty.immcraft.api.generic.GenericBlock;
import mcjty.immcraft.api.generic.GenericTE;
import mcjty.immcraft.api.handles.HandleSelector;
import mcjty.immcraft.api.handles.IInterfaceHandle;
import mcjty.immcraft.api.util.Plane;
import mcjty.lib.blocks.BaseBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class BlockRenderHelper {
    private static long lastUpdateTime = 0L;

    private BlockRenderHelper() {
    }

    public static void renderItemDefault(ItemStack is, int rotation, float scale) {
        if (!is.func_190926_b()) {
            GlStateManager.func_179094_E();
            RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (rotation != 0) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            renderItem.func_181564_a(is, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179121_F();
        }
    }

    public static void renderItemCustom(ItemStack is, int rotation, float scale, boolean normal) {
        if (!is.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (rotation != 0) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            BlockRenderHelper.customRenderItem(is, normal);
            GlStateManager.func_179121_F();
        }
    }

    public static void customRenderItem(ItemStack is, boolean normal) {
        RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        IBakedModel ibakedmodel = renderItem.func_184393_a(is, player.func_130014_f_(), (EntityLivingBase)player);
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        BlockRenderHelper.preTransform(renderItem, is);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        if (normal) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        GlStateManager.func_179094_E();
        ibakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)ibakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
        renderItem.func_180454_a(is, ibakedmodel);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        if (normal) {
            GlStateManager.func_179084_k();
        }
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private static void preTransform(RenderItem renderItem, ItemStack stack) {
        IBakedModel ibakedmodel = renderItem.func_175037_a().func_178089_a(stack);
        Item item = stack.func_77973_b();
        if (item != null) {
            boolean flag = ibakedmodel.func_177556_c();
            if (!flag) {
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void rotateFacing(TileEntity tileEntity, BaseBlock.RotationType rotateType) {
        EnumFacing orientation = BaseBlock.getFrontDirection((BaseBlock.RotationType)rotateType, (IBlockState)tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()));
        switch (orientation) {
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
    }

    @Nullable
    public static IInterfaceHandle getFacingInterfaceHandle(GenericTE te, GenericBlock block) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && te.func_174877_v().equals((Object)mouseOver.func_178782_a()) && mouseOver.hitInfo instanceof HandleSelector) {
            HandleSelector selector = (HandleSelector)mouseOver.hitInfo;
            for (IInterfaceHandle handle : te.getInterfaceHandles()) {
                if (!selector.getId().equals(handle.getSelectorID())) continue;
                return handle;
            }
        }
        return null;
    }

    public static void renderInterfaceHandles(IImmersiveCraft api, GenericTE te, IInterfaceHandle selectedHandle, Vec3d textOffset) {
        boolean selected;
        Map<String, HandleSelector> selectors = te.getBlock().getSelectors();
        for (IInterfaceHandle handle : te.getInterfaceHandles()) {
            selected = selectedHandle == handle;
            BlockRenderHelper.renderHandle(te, selectors, handle, selected);
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
            for (IInterfaceHandle handle : te.getInterfaceHandles()) {
                selected = selectedHandle == handle;
                BlockRenderHelper.renderHandleText(api, te, textOffset, selectors, handle, selected);
            }
        }
    }

    private static void renderHandleText(IImmersiveCraft api, GenericTE te, Vec3d textOffset, Map<String, HandleSelector> selectors, IInterfaceHandle handle, boolean selected) {
        HandleSelector selector;
        ItemStack ghosted = ItemStack.field_190927_a;
        ItemStack heldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack stackInSlot = handle.getCurrentStack((TileEntity)te);
        if (selected && !heldItem.func_190926_b() && stackInSlot.func_190926_b() && handle.acceptAsInput(heldItem)) {
            ghosted = handle.getRenderStack((TileEntity)te, heldItem);
        }
        boolean showRequirements = selected && handle.isCrafting();
        List<String> present = Collections.emptyList();
        List<String> missing = Collections.emptyList();
        if (showRequirements) {
            long time = System.currentTimeMillis();
            if (time - lastUpdateTime > 300L) {
                lastUpdateTime = time;
                api.requestIngredients(te.func_174877_v());
            }
            present = te.getIngredients();
            missing = te.getMissingIngredients();
        }
        if ((selector = selectors.get(handle.getSelectorID())) != null) {
            AxisAlignedBB box = selector.getBox().func_72317_d(-0.5, 0.0, -0.5);
            BlockRenderHelper.renderTextOverlay(box.func_189972_c().func_178787_e(handle.getRenderOffset()), present, missing, ghosted, stackInSlot, handle.getScale(), textOffset);
        }
    }

    private static void renderHandle(GenericTE te, Map<String, HandleSelector> selectors, IInterfaceHandle handle, boolean selected) {
        HandleSelector selector;
        ItemStack ghosted = ItemStack.field_190927_a;
        ItemStack heldItem = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack stackInSlot = handle.getCurrentStack((TileEntity)te);
        if (selected && !heldItem.func_190926_b() && stackInSlot.func_190926_b() && handle.acceptAsInput(heldItem)) {
            ghosted = handle.getRenderStack((TileEntity)te, heldItem);
        }
        if ((selector = selectors.get(handle.getSelectorID())) != null) {
            AxisAlignedBB box = selector.getBox().func_72317_d(-0.5, 0.0, -0.5);
            ItemStack renderStack = handle.getRenderStack((TileEntity)te, stackInSlot);
            BlockRenderHelper.renderItemStackInWorld(box.func_189972_c().func_178787_e(handle.getRenderOffset()), selected, handle.isCrafting(), ghosted, renderStack, handle.getScale());
        }
    }

    private static void renderItemStackInWorld(Vec3d offset, boolean selected, boolean crafting, ItemStack ghosted, ItemStack stack, float scale) {
        scale *= 0.6f;
        if (!ghosted.func_190926_b()) {
            stack = ghosted;
        }
        if (!stack.func_190926_b()) {
            boolean ghostly;
            RenderHelper.func_74519_b();
            GlStateManager.func_179137_b((double)offset.field_72450_a, (double)offset.field_72448_b, (double)offset.field_72449_c);
            boolean bl = ghostly = !ghosted.func_190926_b() || crafting;
            if (ghostly) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)1, (int)1);
            }
            BlockRenderHelper.renderItemCustom(stack, 0, 0.3f * scale, !ghostly);
            if (selected && ghosted.func_190926_b()) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)1, (int)1);
                GlStateManager.func_179143_c((int)514);
                BlockRenderHelper.renderItemCustom(stack, 0, 0.3f * scale, false);
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179084_k();
            }
            if (ghostly) {
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179137_b((double)(-offset.field_72450_a), (double)(-offset.field_72448_b), (double)(-offset.field_72449_c));
        }
    }

    private static void renderTextOverlay(Vec3d offset, List<String> present, List<String> missing, ItemStack ghosted, ItemStack stack, float scale, Vec3d textOffset) {
        if (!ghosted.func_190926_b()) {
            stack = ghosted;
        }
        if (!stack.func_190926_b()) {
            RenderHelper.func_74519_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(offset.field_72450_a + -0.5 + textOffset.field_72450_a), (double)(offset.field_72448_b + 0.5 + textOffset.field_72448_b), (double)(offset.field_72449_c + 0.2 + textOffset.field_72449_c));
            float f3 = 0.0075f;
            float factor = 1.5f;
            GlStateManager.func_179152_a((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
            FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            if (!missing.isEmpty() || !present.isEmpty()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                int y = 50;
                for (String s : missing) {
                    fontrenderer.func_175063_a(s, 60.0f, (float)y, -65536);
                    y -= 10;
                }
                for (String s : present) {
                    fontrenderer.func_175063_a(s, 60.0f, (float)y, -16711936);
                    y -= 10;
                }
                GlStateManager.func_179121_F();
            }
            fontrenderer.func_175063_a(String.valueOf(stack.func_190916_E()), 40.0f, 40.0f, -1);
            GlStateManager.func_179126_j();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    public static void drawSelectionBox(EntityPlayer player, AxisAlignedBB box, float partialTicks, float r, float g, float b, float a) {
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        RenderGlobal.func_189697_a((AxisAlignedBB)box.func_72321_a((double)0.002f, (double)0.002f, (double)0.002f).func_72317_d(-d0, -d1, -d2), (float)r, (float)g, (float)b, (float)a);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderHandleBoxes(String id, EntityPlayer player, float partialTicks, BlockPos pos) {
        IBlockState state = player.func_130014_f_().func_180495_p(pos);
        if (state.func_177230_c() instanceof GenericBlock) {
            GenericBlock genericBlock = (GenericBlock)state.func_177230_c();
            for (Map.Entry<String, HandleSelector> entry : genericBlock.getSelectors().entrySet()) {
                HandleSelector selector = entry.getValue();
                AxisAlignedBB box = selector.getBox();
                Vec3d vmin = new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c);
                Vec3d vmax = new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f);
                vmin = genericBlock.blockToWorldSpace(player.func_130014_f_(), pos, vmin);
                vmax = genericBlock.blockToWorldSpace(player.func_130014_f_(), pos, vmax);
                box = new AxisAlignedBB(vmin, vmax);
                if (id != null && id.equals(entry.getKey())) {
                    BlockRenderHelper.drawSelectionBox(player, box.func_186670_a(pos), partialTicks, 1.0f, 1.0f, 1.0f, 0.4f);
                    continue;
                }
                BlockRenderHelper.drawSelectionBox(player, box.func_186670_a(pos), partialTicks, 0.0f, 0.0f, 0.0f, 0.4f);
            }
        }
    }

    public static void renderPlaneOutline(Plane plane) {
        GlStateManager.func_187441_d((float)4.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        BlockRenderHelper.drawLine(vertexbuffer, plane.getS1(), plane.getS2());
        BlockRenderHelper.drawLine(vertexbuffer, plane.getS2(), plane.getS4());
        BlockRenderHelper.drawLine(vertexbuffer, plane.getS4(), plane.getS3());
        BlockRenderHelper.drawLine(vertexbuffer, plane.getS3(), plane.getS1());
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
    }

    public static void renderLine(Vec3d s1, Vec3d s2) {
        GlStateManager.func_187441_d((float)4.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179118_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        BlockRenderHelper.drawLine(vertexbuffer, s1, s2);
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
    }

    private static void drawLine(BufferBuilder buffer, Vec3d p1, Vec3d p2) {
        buffer.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_181669_b(1, 1, 0, 1).func_181675_d();
        buffer.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_181669_b(1, 1, 0, 1).func_181675_d();
    }
}

