/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client.model;

import buildcraft.lib.client.model.IModelCache;
import buildcraft.lib.client.model.ModelCacheJoiner;
import buildcraft.transport.client.model.PipeModelCacheBase;
import buildcraft.transport.client.model.PipeModelCachePluggable;
import buildcraft.transport.tile.TilePipeHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.BlockRenderLayer;

public class PipeModelCacheAll {
    static final IModelCache<PipeAllCutoutKey> cacheCutout;
    static final IModelCache<PipeAllTranslucentKey> cacheTranslucent;

    public static List<BakedQuad> getCutoutModel(TilePipeHolder tile) {
        return cacheCutout.bake((Object)new PipeAllCutoutKey(tile));
    }

    public static List<BakedQuad> getTranslucentModel(TilePipeHolder tile) {
        return cacheTranslucent.bake((Object)new PipeAllTranslucentKey(tile));
    }

    public static void clearModels() {
        cacheCutout.clear();
        cacheTranslucent.clear();
    }

    static {
        ArrayList<ModelCacheJoiner.ModelKeyWrapper> cutout = new ArrayList<ModelCacheJoiner.ModelKeyWrapper>();
        cutout.add(new ModelCacheJoiner.ModelKeyWrapper(PipeAllCutoutKey::getBaseCutout, PipeModelCacheBase.cacheCutout));
        cutout.add(new ModelCacheJoiner.ModelKeyWrapper(PipeAllCutoutKey::getPluggable, PipeModelCachePluggable.cacheCutoutAll));
        cacheCutout = new ModelCacheJoiner(cutout);
        ArrayList<ModelCacheJoiner.ModelKeyWrapper> translucent = new ArrayList<ModelCacheJoiner.ModelKeyWrapper>();
        translucent.add(new ModelCacheJoiner.ModelKeyWrapper(PipeAllTranslucentKey::getBaseTranslucent, PipeModelCacheBase.cacheTranslucent));
        translucent.add(new ModelCacheJoiner.ModelKeyWrapper(PipeAllTranslucentKey::getPluggable, PipeModelCachePluggable.cacheTranslucentAll));
        cacheTranslucent = new ModelCacheJoiner(translucent);
    }

    public static class PipeAllTranslucentKey {
        private final PipeModelCacheBase.PipeBaseTranslucentKey translucent;
        private final PipeModelCachePluggable.PluggableKey pluggable;
        private final int hash;

        public PipeAllTranslucentKey(TilePipeHolder tile) {
            this.translucent = new PipeModelCacheBase.PipeBaseTranslucentKey(tile.getPipe().getModel());
            this.pluggable = new PipeModelCachePluggable.PluggableKey(BlockRenderLayer.TRANSLUCENT, tile);
            this.hash = Objects.hash(this.translucent, this.pluggable);
        }

        public PipeModelCacheBase.PipeBaseTranslucentKey getBaseTranslucent() {
            return this.translucent;
        }

        public PipeModelCachePluggable.PluggableKey getPluggable() {
            return this.pluggable;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeAllTranslucentKey other = (PipeAllTranslucentKey)obj;
            if (!this.translucent.equals(other.translucent)) {
                return false;
            }
            return this.pluggable.equals(other.pluggable);
        }

        public String toString() {
            return "PipeAllTranslucentKey [base=" + this.translucent + ", pluggable = " + this.pluggable + "]";
        }
    }

    public static class PipeAllCutoutKey {
        private final PipeModelCacheBase.PipeBaseCutoutKey cutout;
        private final PipeModelCachePluggable.PluggableKey pluggable;
        private final int hash;

        public PipeAllCutoutKey(TilePipeHolder tile) {
            this.cutout = new PipeModelCacheBase.PipeBaseCutoutKey(tile.getPipe().getModel());
            this.pluggable = new PipeModelCachePluggable.PluggableKey(BlockRenderLayer.CUTOUT, tile);
            this.hash = Objects.hash(this.cutout, this.pluggable);
        }

        public PipeModelCacheBase.PipeBaseCutoutKey getBaseCutout() {
            return this.cutout;
        }

        public PipeModelCachePluggable.PluggableKey getPluggable() {
            return this.pluggable;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipeAllCutoutKey other = (PipeAllCutoutKey)obj;
            if (!this.cutout.equals(other.cutout)) {
                return false;
            }
            return this.pluggable.equals(other.pluggable);
        }

        public String toString() {
            return "PipeAllCutoutKey [base=" + this.cutout + ", pluggable = " + this.pluggable + "]";
        }
    }
}

