/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.client;

import buildcraft.api.transport.pipe.IPipeBehaviourBaker;
import buildcraft.api.transport.pipe.IPipeBehaviourRenderer;
import buildcraft.api.transport.pipe.IPipeFlowBaker;
import buildcraft.api.transport.pipe.IPipeFlowRenderer;
import buildcraft.api.transport.pipe.PipeApiClient;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.api.transport.pluggable.IPlugDynamicRenderer;
import buildcraft.api.transport.pluggable.IPluggableStaticBaker;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import java.util.HashMap;
import java.util.Map;

public enum PipeRegistryClient implements PipeApiClient.IClientRegistry
{
    INSTANCE;

    private final Map<Class<?>, IPipeFlowRenderer<?>> flowRenderMap = new HashMap();
    private final Map<Class<?>, IPipeBehaviourRenderer<?>> behaviourRenderMap = new HashMap();
    private final Map<Class<?>, IPlugDynamicRenderer<?>> plugRenderMap = new HashMap();
    private final Map<Class<?>, IPipeFlowBaker<?>> flowBakerMap = new HashMap();
    private final Map<Class<?>, IPipeBehaviourBaker<?>> behaviourBakerMap = new HashMap();
    private final Map<Class<?>, IPluggableStaticBaker<?>> plugBakerMap = new HashMap();

    public <F extends PipeFlow> void registerRenderer(Class<? extends F> flowClass, IPipeFlowRenderer<F> renderer) {
        this.flowRenderMap.put(flowClass, renderer);
    }

    public <B extends PipeBehaviour> void registerRenderer(Class<? extends B> behaviourClass, IPipeBehaviourRenderer<B> renderer) {
        this.behaviourRenderMap.put(behaviourClass, renderer);
    }

    public <P extends PipePluggable> void registerRenderer(Class<? extends P> plugClass, IPlugDynamicRenderer<P> renderer) {
        this.plugRenderMap.put(plugClass, renderer);
    }

    public <F extends PipeFlow> void registerBaker(Class<? extends F> flowClass, IPipeFlowBaker<F> baker) {
        this.flowBakerMap.put(flowClass, baker);
    }

    public <B extends PipeBehaviour> void registerBaker(Class<? extends B> flowClass, IPipeBehaviourBaker<B> baker) {
        this.behaviourBakerMap.put(flowClass, baker);
    }

    public <P extends PluggableModelKey> void registerBaker(Class<? extends P> keyClass, IPluggableStaticBaker<P> renderer) {
        this.plugBakerMap.put(keyClass, renderer);
    }

    public static <F extends PipeFlow> IPipeFlowRenderer<F> getFlowRenderer(F flow) {
        return PipeRegistryClient.INSTANCE.flowRenderMap.get(flow.getClass());
    }

    public static <B extends PipeBehaviour> IPipeBehaviourRenderer<B> getBehaviourRenderer(B behaviour) {
        return PipeRegistryClient.INSTANCE.behaviourRenderMap.get(behaviour.getClass());
    }

    public static <P extends PipePluggable> IPlugDynamicRenderer<P> getPlugRenderer(P plug) {
        return PipeRegistryClient.INSTANCE.plugRenderMap.get(plug.getClass());
    }

    public static <F extends PipeFlow> IPipeFlowBaker<F> getFlowBaker(F flow) {
        return PipeRegistryClient.INSTANCE.flowBakerMap.get(flow.getClass());
    }

    public static <B extends PipeBehaviour> IPipeBehaviourBaker<B> getBehaviourBaker(B behaviour) {
        return PipeRegistryClient.INSTANCE.behaviourBakerMap.get(behaviour.getClass());
    }

    public static <P extends PluggableModelKey> IPluggableStaticBaker<P> getPlugBaker(P key) {
        return PipeRegistryClient.INSTANCE.plugBakerMap.get(key.getClass());
    }
}

