/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.library.core;

import betterwithmods.library.core.BWLib;
import betterwithmods.library.core.ClassTransformer;
import betterwithmods.library.core.MethodSignature;
import betterwithmods.library.core.SafeClassWriter;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public interface Transformer {
    public byte[] transform(byte[] var1);

    default public byte[] transform(byte[] basicClass, Pair<MethodSignature, ClassTransformer.MethodAction> ... methods) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (Pair<MethodSignature, ClassTransformer.MethodAction> pair : methods) {
            BWLib.log("Applying Transformation to method (" + pair.getLeft() + ")");
            didAnything |= ClassTransformer.findMethodAndTransform(node, (MethodSignature)pair.getLeft(), (ClassTransformer.MethodAction)pair.getRight());
        }
        if (didAnything) {
            SafeClassWriter writer = new SafeClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public String[] getClasses();
}

