/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagertrades.loaders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.crazysnailboy.mods.villagertrades.VillagerTradesMod;
import net.crazysnailboy.mods.villagertrades.common.config.ModConfiguration;
import net.crazysnailboy.mods.villagertrades.common.registry.VillagerRegistryHelper;
import net.crazysnailboy.mods.villagertrades.util.FileUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class VillagerLoader {
    public static void loadCustomVillagerData() {
        Map<String, String> villagerFiles = VillagerLoader.sortVillagers(FileUtils.createFileMap("villagers", ModConfiguration.loadVillagersFromJar));
        for (String fileName : villagerFiles.keySet()) {
            String fileContents = villagerFiles.get(fileName);
            try {
                VillagerLoader.loadVillagerFromFile(fileContents);
            }
            catch (Exception ex) {
                VillagerTradesMod.LOGGER.error("Error parsing \"" + fileName + "\": " + ex.getMessage());
            }
        }
    }

    private static Map<String, String> sortVillagers(Map<String, String> villagerFiles) {
        LinkedList<Map.Entry<String, String>> list = new LinkedList<Map.Entry<String, String>>(villagerFiles.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                JsonObject j1 = new JsonParser().parse(o1.getValue()).getAsJsonObject();
                JsonObject j2 = new JsonParser().parse(o2.getValue()).getAsJsonObject();
                JsonObject p1 = j1.get("profession").getAsJsonObject();
                JsonObject p2 = j2.get("profession").getAsJsonObject();
                int id1 = p1.has("id") ? p1.get("id").getAsInt() : 0;
                int id2 = p2.has("id") ? p2.get("id").getAsInt() : 0;
                String name1 = p1.get("name").getAsString();
                String name2 = p2.get("name").getAsString();
                return id1 != id2 ? id2 - id1 : name1.compareTo(name2);
            }
        });
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry entry : list) {
            result.put((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    private static void loadVillagerFromFile(String fileContents) {
        VillagerRegistry.VillagerProfession profession;
        JsonObject jsonVillager = new JsonParser().parse(fileContents).getAsJsonObject();
        JsonObject jsonProfession = jsonVillager.get("profession").getAsJsonObject();
        String name = jsonProfession.get("name").getAsString();
        String texture = jsonProfession.has("texture") ? jsonProfession.get("texture").getAsString() : null;
        String zombieTexture = jsonProfession.has("zombieTexture") ? jsonProfession.get("zombieTexture").getAsString() : null;
        JsonArray jsonCareers = jsonVillager.get("careers").getAsJsonArray();
        if (!ForgeRegistries.VILLAGER_PROFESSIONS.containsKey(new ResourceLocation(name))) {
            profession = new VillagerRegistry.VillagerProfession(name, texture, zombieTexture);
            ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)profession);
        } else {
            profession = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(name));
        }
        for (JsonElement jsonCareer : jsonCareers) {
            String careerName = jsonCareer.getAsString();
            if (new VillagerRegistryHelper.VTTVillagerProfession(profession).getCareer(careerName) != null) continue;
            new VillagerRegistry.VillagerCareer(profession, careerName);
        }
    }
}

