/*
 * Decompiled with CFR 0.152.
 */
package net.crazysnailboy.mods.villagertrades.common.registry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.commons.lang3.StringUtils;

public class VillagerRegistryHelper {
    public static VillagerRegistry.VillagerProfession getProfession(String value) {
        return StringUtils.isNumeric((CharSequence)value) ? VillagerRegistryHelper.getProfessionById(Integer.parseInt(value)) : VillagerRegistryHelper.getProfessionByName(new ResourceLocation(value));
    }

    private static VillagerRegistry.VillagerProfession getProfessionById(int value) {
        return VillagerRegistry.getById((int)value);
    }

    private static VillagerRegistry.VillagerProfession getProfessionByName(ResourceLocation value) {
        return (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(value);
    }

    public static List<Map.Entry<Integer, String>> getProfessionIdsAndNamesSortedById() {
        ArrayList<Map.Entry<Integer, String>> professions = new ArrayList<Map.Entry<Integer, String>>();
        for (VillagerRegistry.VillagerProfession profession : ForgeRegistries.VILLAGER_PROFESSIONS.getValues()) {
            VTTVillagerProfession wrapper = new VTTVillagerProfession(profession);
            int id = wrapper.getId();
            String name = wrapper.getName().toString();
            professions.add(new AbstractMap.SimpleEntry<Integer, String>(id, name));
        }
        Collections.sort(professions, new Comparator<Map.Entry<Integer, String>>(){

            @Override
            public int compare(Map.Entry<Integer, String> o1, Map.Entry<Integer, String> o2) {
                return o1.getKey() - o2.getKey();
            }
        });
        return professions;
    }

    public static class VTTVillagerCareer {
        private static final Class careerClass = VillagerRegistry.VillagerCareer.class;
        public VillagerRegistry.VillagerCareer career;

        public int getId() {
            int id = (Integer)ObfuscationReflectionHelper.getPrivateValue((Class)careerClass, (Object)this.career, (String[])new String[]{"id"});
            return id + 1;
        }

        public String getName() {
            return this.career.getName();
        }

        public int getCareerLevels() {
            List trades = (List)ObfuscationReflectionHelper.getPrivateValue((Class)careerClass, (Object)this.career, (String[])new String[]{"trades"});
            return trades.size();
        }

        public List<List<EntityVillager.ITradeList>> getTrades() {
            List trades = (List)ObfuscationReflectionHelper.getPrivateValue((Class)careerClass, (Object)this.career, (String[])new String[]{"trades"});
            return trades;
        }

        public List<EntityVillager.ITradeList> getTrades(int level) {
            List trades = (List)ObfuscationReflectionHelper.getPrivateValue((Class)careerClass, (Object)this.career, (String[])new String[]{"trades"});
            int index = level - 1;
            return index >= 0 && index < trades.size() ? (List)trades.get(index) : null;
        }

        public VTTVillagerCareer(VillagerRegistry.VillagerCareer career) {
            this.career = career;
        }
    }

    public static class VTTVillagerProfession {
        private static final Class professionClass = VillagerRegistry.VillagerProfession.class;
        public VillagerRegistry.VillagerProfession profession;

        public int getId() {
            return VillagerRegistry.getId((VillagerRegistry.VillagerProfession)this.profession);
        }

        public ResourceLocation getName() {
            return this.profession.getRegistryName();
        }

        public List<VillagerRegistry.VillagerCareer> getCareers() {
            return (List)ObfuscationReflectionHelper.getPrivateValue((Class)professionClass, (Object)this.profession, (String[])new String[]{"careers"});
        }

        public VillagerRegistry.VillagerCareer getCareer(String name) {
            List careers = (List)ObfuscationReflectionHelper.getPrivateValue((Class)professionClass, (Object)this.profession, (String[])new String[]{"careers"});
            for (VillagerRegistry.VillagerCareer career : careers) {
                if (!career.getName().equals(name)) continue;
                return career;
            }
            return null;
        }

        public VillagerRegistry.VillagerCareer getCareer(int id) {
            return this.profession.getCareer(id - 1);
        }

        public VTTVillagerProfession(VillagerRegistry.VillagerProfession profession) {
            this.profession = profession;
        }
    }
}

