/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public final class BlockShapeUtils {
    private BlockShapeUtils() {
    }

    public static List<BlockPos> getCircle(BlockPos pos, int radius, List<BlockPos> list) {
        int xo = radius;
        int zo = 0;
        int err = 1 - radius;
        ArrayList<BlockPos> s1 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s2 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s3 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s4 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s5 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s6 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s7 = new ArrayList<BlockPos>();
        ArrayList<BlockPos> s8 = new ArrayList<BlockPos>();
        while (xo >= zo) {
            s1.add(pos.func_177982_a(xo, 0, zo));
            if (xo != zo) {
                s2.add(pos.func_177982_a(zo, 0, xo));
            }
            if (zo != 0) {
                s3.add(pos.func_177982_a(-zo, 0, xo));
            }
            if (xo != zo) {
                s4.add(pos.func_177982_a(-xo, 0, zo));
            }
            if (zo != 0) {
                s5.add(pos.func_177982_a(-xo, 0, -zo));
            }
            if (xo != zo) {
                s6.add(pos.func_177982_a(-zo, 0, -xo));
            }
            if (zo != 0) {
                s7.add(pos.func_177982_a(zo, 0, -xo));
            }
            if (xo != zo && zo != 0) {
                s8.add(pos.func_177982_a(xo, 0, -zo));
            }
            if (err < 0) {
                err = err + 2 * ++zo + 1;
                continue;
            }
            err = err + 2 * (++zo - --xo) + 1;
        }
        list.addAll(s1);
        ListIterator it = s2.listIterator(s2.size());
        while (it.hasPrevious()) {
            list.add((BlockPos)it.previous());
        }
        list.addAll(s3);
        it = s4.listIterator(s4.size());
        while (it.hasPrevious()) {
            list.add((BlockPos)it.previous());
        }
        list.addAll(s5);
        it = s6.listIterator(s6.size());
        while (it.hasPrevious()) {
            list.add((BlockPos)it.previous());
        }
        list.addAll(s7);
        it = s8.listIterator(s8.size());
        while (it.hasPrevious()) {
            list.add((BlockPos)it.previous());
        }
        return list;
    }

    public static List<BlockPos> getRingSegment(BlockPos pos, double startAngle, double endAngle, double innerRadius, double outerRadius, boolean includeCenter, List<BlockPos> list) {
        double twoPi = Math.PI * 2;
        double halfPi = 1.5707963267948966;
        if ((startAngle %= Math.PI * 2) < 0.0) {
            startAngle += Math.PI * 2;
        }
        if ((endAngle %= Math.PI * 2) < 0.0) {
            endAngle += Math.PI * 2;
        }
        int qa1 = MathHelper.func_76128_c((double)(startAngle / 1.5707963267948966));
        startAngle -= (double)qa1 * 1.5707963267948966;
        double radiusSq = outerRadius * outerRadius;
        int rotation = (4 - qa1) % 4;
        int maxRot = MathHelper.func_76128_c((double)((endAngle -= (double)qa1 * 1.5707963267948966) / 1.5707963267948966));
        for (int rot = 0; rot <= maxRot; ++rot) {
            double ca1 = rot == 0 ? startAngle : 0.0;
            double ca2 = rot == maxRot ? endAngle % 1.5707963267948966 : 1.5707963267948966;
            double cos1 = Math.cos(ca1);
            double tan1 = Math.tan(ca1);
            double tan2 = Math.tan(ca2);
            int minX = 0;
            int maxX = MathHelper.func_76143_f((double)(cos1 * outerRadius));
            for (int xo = minX; xo <= maxX; ++xo) {
                double dstSq;
                double dxSq = ((double)xo - 0.5) * ((double)xo - 0.5);
                int minZ = MathHelper.func_76128_c((double)(tan1 * (double)xo));
                int maxZ = MathHelper.func_76128_c((double)Math.min(tan2 * (double)xo, outerRadius));
                if ((double)xo <= innerRadius) {
                    minZ += MathHelper.func_76143_f((double)(innerRadius - Math.sqrt(xo * xo + minZ * minZ)));
                }
                for (int zo = minZ; zo < maxZ && !((dstSq = dxSq + ((double)zo + 0.5) * ((double)zo + 0.5)) >= radiusSq); ++zo) {
                    int nz;
                    int nx;
                    if (dstSq <= innerRadius * innerRadius) continue;
                    switch (rotation) {
                        default: {
                            nx = xo - 1;
                            break;
                        }
                        case 1: {
                            nx = zo;
                            break;
                        }
                        case 2: {
                            nx = -xo + 1;
                            break;
                        }
                        case 3: {
                            nx = -zo;
                        }
                    }
                    switch (rotation) {
                        default: {
                            nz = zo;
                            break;
                        }
                        case 1: {
                            nz = -xo + 1;
                            break;
                        }
                        case 2: {
                            nz = -zo;
                            break;
                        }
                        case 3: {
                            nz = xo - 1;
                        }
                    }
                    if (!includeCenter && nx == 0 && nz == 0) continue;
                    list.add(pos.func_177982_a(nx, 0, nz));
                }
            }
            if (--rotation >= 0) continue;
            rotation += 4;
        }
        return list;
    }
}

