/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.plant.BlockDoublePlantBL;

public class WorldGenDoublePlantCluster
extends WorldGenerator {
    private final BlockDoublePlantBL block;
    private final int offset;
    private final int attempts;
    private boolean isUnderwater = false;

    public WorldGenDoublePlantCluster(BlockDoublePlantBL block, int offset, int attempts) {
        this.block = block;
        this.offset = offset;
        this.attempts = attempts;
    }

    public WorldGenDoublePlantCluster(BlockDoublePlantBL block) {
        this(block, 8, 128);
    }

    public WorldGenDoublePlantCluster setUnderwater(boolean underwater) {
        this.isUnderwater = underwater;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean generated = false;
        IBlockState iblockstate = worldIn.func_180495_p(position);
        while ((iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)worldIn, position) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, position)) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            iblockstate = worldIn.func_180495_p(position);
        }
        for (int i = 0; i < this.attempts; ++i) {
            BlockPos blockpos = position.func_177982_a(rand.nextInt(this.offset) - rand.nextInt(this.offset), rand.nextInt(this.offset / 2 + 1) - rand.nextInt(this.offset / 2 + 1), rand.nextInt(this.offset) - rand.nextInt(this.offset));
            if (!worldIn.func_175623_d(blockpos) && (!this.isUnderwater || !worldIn.func_180495_p(blockpos).func_185904_a().func_76224_d()) || !worldIn.field_73011_w.func_191066_m() && blockpos.func_177956_o() >= 254 || !this.block.func_176196_c(worldIn, blockpos)) continue;
            this.block.placeAt(worldIn, blockpos, 2);
            generated = true;
        }
        return generated;
    }
}

