/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thebetweenlands.common.block.plant.BlockThorns;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.feature.WorldGenCave;

public class WorldGenCaveThorns
extends WorldGenCave {
    private BlockThorns thorns = (BlockThorns)BlockRegistry.THORNS;
    private static final int MIN_RADIUS = 2;
    private static final int MAX_RADIUS = 3;
    private static final int LENGTH_RANGE = 5;
    private static final int MIN_LENGTH = 2;
    private static final int MAX_HEIGHT = 8;

    public WorldGenCaveThorns() {
        this(false);
    }

    public WorldGenCaveThorns(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    public boolean func_180709_b(World world, Random random, BlockPos origin) {
        if (!this.isGoodStart(world, origin)) {
            return false;
        }
        int radius = random.nextInt(2) + 2;
        int radiusSq = radius * radius;
        Stack<BlockPos> searching = new Stack<BlockPos>();
        ArrayList<BlockPos> checked = new ArrayList<BlockPos>();
        ArrayList<WorldGenCave.PlantLocation> locations = new ArrayList<WorldGenCave.PlantLocation>();
        BlockPos start = origin.func_177982_a(0, -1, 0);
        searching.push(start);
        checked.add(start);
        while (!searching.isEmpty()) {
            BlockPos pos = (BlockPos)searching.pop();
            double distSq = origin.func_177954_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            if ((double)random.nextFloat() > distSq / (double)radiusSq) {
                locations.add(new WorldGenCave.PlantLocation(world, pos));
            }
            for (EnumFacing dir : this.directions) {
                BlockPos below;
                BlockPos offsetPos = pos.func_177972_a(dir);
                if (offsetPos.func_177954_c((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p()) > (double)radiusSq) continue;
                if (this.supports(world, offsetPos.func_177982_a(0, 1, 0))) {
                    if (checked.contains(offsetPos)) continue;
                    searching.push(offsetPos);
                    checked.add(offsetPos);
                    continue;
                }
                if (!this.supports(world, offsetPos) || checked.contains(below = offsetPos.func_177982_a(0, -1, 0))) continue;
                searching.push(below);
                checked.add(below);
            }
        }
        if (locations.size() < 5) {
            return false;
        }
        int maximumHeight = 0;
        for (WorldGenCave.PlantLocation location : locations) {
            if (location.getHeight() <= maximumHeight) continue;
            maximumHeight = location.getHeight();
        }
        if (maximumHeight < 3) {
            return false;
        }
        int[] facesWithThorns = new int[4];
        for (WorldGenCave.PlantLocation location : locations) {
            BlockPos pos = location.getPos();
            int sideCount = 0;
            int metadata = 0;
            for (int n = 0; n < this.directions.length; ++n) {
                EnumFacing face = this.directions[n];
                BlockPos neighbourPos = pos.func_177972_a(face);
                if (!this.isValidBlock(world, neighbourPos) || !world.isSideSolid(neighbourPos, face)) continue;
                int side = 1 << n;
                facesWithThorns[sideCount++] = side;
                metadata |= side;
            }
            this.func_175903_a(world, pos, this.thorns.func_176203_a(metadata));
            if (metadata <= 0 || location.getHeight() <= 1) continue;
            int hangingMetadata = facesWithThorns[random.nextInt(sideCount)];
            int length = random.nextInt(location.getHeight() > 8 ? 8 : location.getHeight() - 1) + 1;
            for (int n = 1; n < length; ++n) {
                this.func_175903_a(world, pos.func_177982_a(0, -n, 0), this.thorns.func_176203_a(hangingMetadata));
            }
        }
        return true;
    }
}

