/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.biome;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.spawning.ICustomSpawnEntry;
import thebetweenlands.common.entity.mobs.EntityAngler;
import thebetweenlands.common.entity.mobs.EntityBlindCaveFish;
import thebetweenlands.common.entity.mobs.EntityBoulderSprite;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityFirefly;
import thebetweenlands.common.entity.mobs.EntityGasCloud;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;
import thebetweenlands.common.entity.mobs.EntitySporeling;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.biome.BiomeBetweenlands;
import thebetweenlands.common.world.biome.spawning.spawners.BetweenstoneCaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.CaveSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.GreeblingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SporelingSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SurfaceSpawnEntry;
import thebetweenlands.common.world.biome.spawning.spawners.SwampHagCaveSpawnEntry;
import thebetweenlands.common.world.gen.biome.decorator.BiomeDecoratorMarsh;
import thebetweenlands.common.world.gen.biome.feature.Marsh1Feature;
import thebetweenlands.common.world.gen.biome.feature.Marsh2Feature;
import thebetweenlands.common.world.gen.biome.feature.PatchFeature;
import thebetweenlands.util.FogGenerator;

public class BiomeMarsh
extends BiomeBetweenlands {
    private FogGenerator fogGenerator;
    private float fogRangeInterpolateStart = 0.0f;
    private float fogRangeInterpolateEnd = 0.0f;

    public BiomeMarsh(int type) {
        super(new ResourceLocation("thebetweenlands", "marsh_" + type), new Biome.BiomeProperties("Marsh " + type).func_185398_c(119.0f).func_185400_d(1.1f).func_185402_a(4742680).func_185410_a(0.8f).func_185395_b(0.9f));
        this.setWeight(type == 0 ? 10 : 4);
        this.getBiomeGenerator().addFeature(type == 0 ? new Marsh1Feature() : new Marsh2Feature()).addFeature(new PatchFeature(0.109375, 0.109375, BlockRegistry.PEAT.func_176223_P())).addFeature(new PatchFeature(0.390625, 0.390625, BlockRegistry.PEAT.func_176223_P())).addFeature(new PatchFeature(0.171875, 0.171875, BlockRegistry.MUD.func_176223_P())).addFeature(new PatchFeature(0.265625, 0.265625, BlockRegistry.MUD.func_176223_P())).setDecorator(new BiomeDecoratorMarsh(this));
        this.setFoliageColors(6451223, 6534529);
    }

    @Override
    protected void addSpawnEntries(List<ICustomSpawnEntry> entries) {
        super.addSpawnEntries(entries);
        entries.add(new SurfaceSpawnEntry(0, EntityFirefly.class, EntityFirefly::new, 65).setCanSpawnOnWater(true).setSpawnCheckRadius(32.0));
        entries.add(new SporelingSpawnEntry(1, EntitySporeling.class, EntitySporeling::new, 80).setGroupSize(2, 5).setSpawnCheckRadius(32.0));
        entries.add(new CaveSpawnEntry(2, EntityBlindCaveFish.class, EntityBlindCaveFish::new, 30).setCanSpawnInWater(true).setGroupSize(3, 5).setSpawnCheckRadius(32.0));
        entries.add(new GreeblingSpawnEntry(12, 10).setGroupSize(1, 3).setSpawnCheckRadius(64.0).setGroupSpawnRadius(4.0).setSpawningInterval(24000));
        entries.add(new SurfaceSpawnEntry(3, EntityWight.class, EntityWight::new, 5).setHostile(true).setSpawnCheckRadius(64.0).setSpawningInterval(4000));
        entries.add(new CaveSpawnEntry(4, EntityWight.class, EntityWight::new, 16).setHostile(true).setSpawnCheckRadius(64.0));
        entries.add(new SurfaceSpawnEntry(5, EntityPeatMummy.class, EntityPeatMummy::new, 12).setHostile(true).setSpawnCheckRadius(64.0));
        entries.add(new SurfaceSpawnEntry(6, EntityChiromaw.class, EntityChiromaw::new, 40).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(20.0));
        entries.add(new CaveSpawnEntry(7, EntityChiromaw.class, EntityChiromaw::new, 60).setHostile(true).setSpawnCheckRadius(40.0).setGroupSize(1, 3));
        entries.add(new SwampHagCaveSpawnEntry(8, 120).setHostile(true).setSpawnCheckRadius(24.0).setGroupSize(1, 3));
        entries.add(new CaveSpawnEntry(9, EntityAngler.class, EntityAngler::new, 40).setCanSpawnInWater(true).setHostile(true).setGroupSize(1, 3));
        entries.add(new SurfaceSpawnEntry(10, EntityGasCloud.class, EntityGasCloud::new, 3).setCanSpawnOnWater(true).setHostile(true).setSpawnCheckRadius(64.0).setSpawnCheckRangeY(64.0));
        entries.add(new BetweenstoneCaveSpawnEntry(11, EntityBoulderSprite.class, EntityBoulderSprite::new, 60).setHostile(true).setSpawnCheckRadius(16.0).setSpawnCheckRangeY(8.0));
    }

    @Override
    public void updateFog() {
        if (this.fogGenerator == null || this.fogGenerator.getSeed() != Minecraft.func_71410_x().field_71441_e.func_72905_C()) {
            this.fogGenerator = new FogGenerator(Minecraft.func_71410_x().field_71441_e.func_72905_C());
        }
        float[] range = this.fogGenerator.getFogRange(0.0f, 1.0f);
        this.fogRangeInterpolateStart = range[0];
        this.fogRangeInterpolateEnd = range[1];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getFogStart(float farPlaneDistance, int mode) {
        float fogStart = Math.min(10.0f, super.getFogStart(farPlaneDistance, mode));
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null || viewEntity.field_70163_u <= 110.0) {
            return fogStart;
        }
        float fogEnd = super.getFogEnd(farPlaneDistance, mode);
        return fogStart + (fogEnd - fogStart) * this.fogRangeInterpolateStart;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getFogEnd(float farPlaneDistance, int mode) {
        float fogEnd = super.getFogEnd(farPlaneDistance, mode);
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null || viewEntity.field_70163_u <= 110.0) {
            return fogEnd;
        }
        float fogStart = Math.min(10.0f, super.getFogStart(farPlaneDistance, mode));
        return fogStart + ((fogEnd - fogStart) * this.fogRangeInterpolateEnd + 16.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int[] getFogRGB() {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null || viewEntity.field_70163_u <= 110.0) {
            return super.getFogRGB();
        }
        int[] targetFogColor = (int[])super.getFogRGB().clone();
        float fogBrightness = 110.0f - this.fogRangeInterpolateEnd * 110.0f;
        if (fogBrightness < 0.0f) {
            fogBrightness = 0.0f;
        } else if (fogBrightness > 110.0f) {
            fogBrightness = 110.0f;
        }
        for (int i = 0; i < 3; ++i) {
            int diff = 255 - targetFogColor[i];
            targetFogColor[i] = (int)((double)targetFogColor[i] + (double)diff / 255.0 * (double)fogBrightness);
        }
        return targetFogColor;
    }

    @Override
    public void addTypes() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }
}

