/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankPropertiesWrapper;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.ItemStackHandler;
import thebetweenlands.api.block.ICenser;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.common.block.container.BlockCenser;
import thebetweenlands.common.inventory.container.ContainerCenser;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityCenser
extends TileEntityBasicInventory
implements IFluidHandler,
ITickable,
ICenser {
    private final FluidTank fluidTank;
    private final IFluidTankProperties[] properties = new IFluidTankProperties[1];
    private static final int INV_SIZE = 3;
    private int remainingItemAmount = 0;
    private float prevDungeonFogStrength = 0.0f;
    private float dungeonFogStrength = 0.0f;
    private float prevEffectStrength = 0.0f;
    private float effectStrength = 0.0f;
    private int maxConsumptionTicks;
    private int consumptionTicks;
    private boolean isFluidRecipe;
    private Object currentRecipeContext;
    private ICenserRecipe<Object> currentRecipe;
    private boolean internalSlotChanged = false;
    private int maxFuelTicks;
    private int fuelTicks;
    private boolean checkInternalSlotForRecipes = true;
    private boolean checkInputSlotForTransfer = true;
    private boolean isRecipeRunning = false;

    public TileEntityCenser() {
        super("container.bl.censer", (NonNullList<ItemStack>)NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a), (te, inv) -> new ItemStackHandler((NonNullList)inv, (TileEntityBasicInventory)((Object)te)){
            final /* synthetic */ TileEntityBasicInventory val$te;
            {
                this.val$te = tileEntityBasicInventory;
                super(x0);
            }

            public void setSize(int size) {
                this.stacks = this.val$te.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
            }

            protected void onContentsChanged(int slot) {
                if (this.val$te.func_145830_o()) {
                    this.val$te.func_70296_d();
                    if (slot == 2) {
                        ((TileEntityCenser)this.val$te).internalSlotChanged = true;
                    }
                }
                if (slot == 2) {
                    ((TileEntityCenser)this.val$te).checkInternalSlotForRecipes = true;
                    ((TileEntityCenser)this.val$te).checkInputSlotForTransfer = true;
                } else if (slot == 1) {
                    ((TileEntityCenser)this.val$te).checkInputSlotForTransfer = true;
                }
            }

            public int getSlotLimit(int slot) {
                return slot == 2 ? 1 : super.getSlotLimit(slot);
            }

            protected int getStackLimit(int slot, ItemStack stack) {
                return slot == 2 ? 1 : super.getStackLimit(slot, stack);
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return slot == 2 ? stack : super.insertItem(slot, stack, simulate);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return slot == 2 ? ItemStack.field_190927_a : super.extractItem(slot, amount, simulate);
            }
        });
        this.fluidTank = new FluidTank(null, 8000){

            public boolean canFillFluidType(FluidStack fluid) {
                return super.canFillFluidType(fluid) && TileEntityCenser.this.getEffect(fluid) != null;
            }
        };
        this.fluidTank.setTileEntity((TileEntity)this);
        this.properties[0] = new FluidTankPropertiesWrapper(this.fluidTank);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluidTank.readFromNBT(nbt.func_74775_l("fluidTank"));
        this.remainingItemAmount = nbt.func_74762_e("remainingItemAmount");
        this.consumptionTicks = nbt.func_74762_e("consumptionTicks");
        this.maxConsumptionTicks = nbt.func_74762_e("maxConsumptionTicks");
        this.fuelTicks = nbt.func_74762_e("fuelTicks");
        this.maxFuelTicks = nbt.func_74762_e("maxFuelTicks");
        this.readRecipeNbt(nbt, false);
    }

    protected void readRecipeNbt(NBTTagCompound nbt, boolean packet) {
        this.isFluidRecipe = nbt.func_74767_n("fluidRecipe");
        this.currentRecipe = null;
        this.currentRecipeContext = null;
        if (nbt.func_150297_b("recipeId", 8)) {
            ResourceLocation id = new ResourceLocation(nbt.func_74779_i("recipeId"));
            ICenserRecipe<?> recipe = null;
            Object recipeContext = null;
            if (this.isFluidRecipe && this.fluidTank.getFluid() != null) {
                recipe = this.getEffect(this.fluidTank.getFluid());
                if (recipe != null) {
                    recipeContext = recipe.createContext(this.fluidTank.getFluid());
                }
            } else if (!this.isFluidRecipe && (recipe = this.getEffect(this.func_70301_a(2))) != null) {
                recipeContext = recipe.createContext(this.func_70301_a(2));
            }
            if (recipe != null && this.canRecipeRun(this.isFluidRecipe, recipe)) {
                this.currentRecipe = recipe;
                this.currentRecipeContext = recipeContext;
                if (recipeContext != null && id.equals((Object)recipe.getId()) && nbt.func_150297_b("recipeNbt", 10)) {
                    NBTTagCompound recipeNbt = nbt.func_74775_l("recipeNbt");
                    recipe.read(recipeContext, recipeNbt, packet);
                }
            } else {
                this.consumptionTicks = -1;
                this.maxConsumptionTicks = -1;
            }
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("remainingItemAmount", this.remainingItemAmount);
        nbt.func_74768_a("consumptionTicks", this.consumptionTicks);
        nbt.func_74768_a("maxConsumptionTicks", this.maxConsumptionTicks);
        nbt.func_74768_a("fuelTicks", this.fuelTicks);
        nbt.func_74768_a("maxFuelTicks", this.maxFuelTicks);
        this.writeRecipeNbt(nbt, false);
        return nbt;
    }

    protected void writeRecipeNbt(NBTTagCompound nbt, boolean packet) {
        nbt.func_74757_a("fluidRecipe", this.isFluidRecipe);
        if (this.currentRecipe != null) {
            nbt.func_74778_a("recipeId", this.currentRecipe.getId().toString());
            if (this.currentRecipeContext != null) {
                NBTTagCompound contextNbt = new NBTTagCompound();
                this.currentRecipe.save(this.currentRecipeContext, contextNbt, packet);
                nbt.func_74782_a("recipeNbt", (NBTBase)contextNbt);
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writePacketNbt(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.readPacketNbt(packet.func_148857_g());
    }

    protected NBTTagCompound writePacketNbt(NBTTagCompound nbt) {
        this.writeInventoryNBT(nbt);
        nbt.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("remainingItemAmount", this.remainingItemAmount);
        nbt.func_74768_a("consumptionTicks", this.consumptionTicks);
        nbt.func_74768_a("maxConsumptionTicks", this.maxConsumptionTicks);
        nbt.func_74768_a("fuelTicks", this.fuelTicks);
        nbt.func_74768_a("maxFuelTicks", this.maxFuelTicks);
        this.writeRecipeNbt(nbt, true);
        return nbt;
    }

    protected void readPacketNbt(NBTTagCompound nbt) {
        this.readInventoryNBT(nbt);
        this.fluidTank.readFromNBT(nbt.func_74775_l("fluidTank"));
        this.remainingItemAmount = nbt.func_74762_e("remainingItemAmount");
        this.consumptionTicks = nbt.func_74762_e("consumptionTicks");
        this.maxConsumptionTicks = nbt.func_74762_e("maxConsumptionTicks");
        this.fuelTicks = nbt.func_74762_e("fuelTicks");
        this.maxFuelTicks = nbt.func_74762_e("maxFuelTicks");
        this.readRecipeNbt(nbt, true);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writePacketNbt(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readPacketNbt(nbt);
    }

    public void receiveGUIData(int id, int value) {
        switch (id) {
            case 0: {
                this.remainingItemAmount = value;
                break;
            }
            case 1: {
                if (this.fluidTank.getFluid() == null) break;
                this.fluidTank.getFluid().amount = value;
                break;
            }
            case 2: {
                this.consumptionTicks = value;
                break;
            }
            case 3: {
                this.maxConsumptionTicks = value;
                break;
            }
            case 4: {
                this.fuelTicks = value;
                break;
            }
            case 5: {
                this.maxFuelTicks = value;
            }
        }
    }

    public void sendGUIData(ContainerCenser censer, IContainerListener craft) {
        craft.func_71112_a((Container)censer, 0, this.remainingItemAmount);
        craft.func_71112_a((Container)censer, 1, this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0);
        craft.func_71112_a((Container)censer, 2, this.consumptionTicks);
        craft.func_71112_a((Container)censer, 3, this.maxConsumptionTicks);
        craft.func_71112_a((Container)censer, 4, this.fuelTicks);
        craft.func_71112_a((Container)censer, 5, this.maxFuelTicks);
    }

    public void func_73660_a() {
        IBlockState stat;
        if (!this.field_145850_b.field_72995_K) {
            if (this.fuelTicks > 0) {
                --this.fuelTicks;
                this.func_70296_d();
                if (this.fuelTicks <= 0) {
                    IBlockState stat2 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, stat2, stat2, 2);
                }
            } else {
                this.fuelTicks = 0;
            }
            if (this.checkInternalSlotForRecipes) {
                ICenserRecipe<?> recipe;
                this.checkInternalSlotForRecipes = false;
                FluidStack fluid = this.fluidTank.getFluid();
                ItemStack internalStack = this.func_70301_a(2);
                if (fluid != null && fluid.amount > 0) {
                    recipe = this.getEffect(fluid);
                    if (recipe != null && recipe.matchesInput(fluid)) {
                        this.isFluidRecipe = true;
                        this.currentRecipe = recipe;
                        this.currentRecipeContext = recipe.createContext(fluid);
                        this.currentRecipe.onStart(this.currentRecipeContext);
                        this.maxConsumptionTicks = this.consumptionTicks = this.currentRecipe.getConsumptionDuration(this.currentRecipeContext, this);
                        this.func_70296_d();
                        stat = this.field_145850_b.func_180495_p(this.field_174879_c);
                        this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
                    }
                } else if (!internalStack.func_190926_b() && (recipe = this.getEffect(internalStack)) != null && recipe.matchesInput(internalStack)) {
                    this.isFluidRecipe = false;
                    this.currentRecipe = recipe;
                    this.currentRecipeContext = recipe.createContext(internalStack);
                    this.currentRecipe.onStart(this.currentRecipeContext);
                    this.maxConsumptionTicks = this.consumptionTicks = this.currentRecipe.getConsumptionDuration(this.currentRecipeContext, this);
                    this.func_70296_d();
                    stat = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
                }
            }
        }
        this.isRecipeRunning = false;
        if (this.currentRecipe != null) {
            ItemStack fuelStack;
            boolean isDisabled;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            boolean bl = isDisabled = state.func_177230_c() instanceof BlockCenser && (Boolean)state.func_177229_b((IProperty)BlockCenser.ENABLED) == false;
            if (!this.field_145850_b.field_72995_K && !isDisabled && this.fuelTicks <= 0 && this.isFilled() && !(fuelStack = this.func_70301_a(0)).func_190926_b() && TileEntityFurnace.func_145954_b((ItemStack)fuelStack)) {
                this.maxFuelTicks = this.fuelTicks = TileEntityFurnace.func_145952_a((ItemStack)fuelStack) * 4;
                fuelStack.func_190918_g(1);
                if (fuelStack.func_190916_E() <= 0) {
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
                this.func_70296_d();
                stat = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
            }
            if (!this.canRecipeRun(this.isFluidRecipe, this.currentRecipe)) {
                if (!this.field_145850_b.field_72995_K) {
                    this.currentRecipe.onStop(this.currentRecipeContext);
                    this.currentRecipe = null;
                    this.currentRecipeContext = null;
                    this.consumptionTicks = -1;
                    this.maxConsumptionTicks = -1;
                    this.func_70296_d();
                    IBlockState stat3 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, stat3, stat3, 2);
                }
            } else if (this.fuelTicks > 0 && !isDisabled) {
                this.isRecipeRunning = true;
                int toRemove = this.currentRecipe.update(this.currentRecipeContext, this);
                if (!this.field_145850_b.field_72995_K) {
                    if (--this.consumptionTicks <= 0) {
                        toRemove += this.currentRecipe.getConsumptionAmount(this.currentRecipeContext, this);
                    }
                    if (toRemove > 0) {
                        if (this.isFluidRecipe) {
                            this.fluidTank.drainInternal(toRemove, true);
                            this.checkInputSlotForTransfer = true;
                        } else {
                            this.remainingItemAmount = Math.max(0, this.remainingItemAmount - toRemove);
                            if (this.remainingItemAmount <= 0) {
                                this.func_70299_a(2, ItemStack.field_190927_a);
                            }
                        }
                        this.maxConsumptionTicks = this.consumptionTicks = this.currentRecipe.getConsumptionDuration(this.currentRecipeContext, this);
                    }
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack internalStack;
            if (this.checkInputSlotForTransfer) {
                this.checkInputSlotForTransfer = false;
                ItemStack inputStack = this.func_70301_a(1);
                if (!inputStack.func_190926_b()) {
                    ICenserRecipe<?> recipe;
                    FluidActionResult fillResult;
                    if (this.func_70301_a(2).func_190926_b() && (fillResult = FluidUtil.tryEmptyContainer((ItemStack)inputStack, (IFluidHandler)this, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                        this.func_70299_a(1, fillResult.getResult());
                    } else if (!this.isFilled() && (recipe = this.getEffect(inputStack)) != null) {
                        this.remainingItemAmount = Math.min(recipe.getInputAmount(inputStack), 1000);
                        ItemStack internalStack2 = inputStack.func_77946_l();
                        internalStack2.func_190920_e(1);
                        this.func_70299_a(2, internalStack2);
                        this.func_70299_a(1, recipe.consumeInput(inputStack));
                    }
                }
            }
            if (this.currentRecipe == null && !(internalStack = this.func_70301_a(2)).func_190926_b() && this.getEffect(internalStack) == null) {
                this.func_70299_a(2, ItemStack.field_190927_a);
            }
        }
        if (!this.field_145850_b.field_72995_K && this.internalSlotChanged) {
            this.internalSlotChanged = false;
            BlockPos pos = this.getCenserPos();
            IBlockState stat4 = this.getCenserWorld().func_180495_p(pos);
            this.getCenserWorld().func_184138_a(pos, stat4, stat4, 2);
        }
        boolean isCreatingDungeonFog = this.isRecipeRunning && this.currentRecipe.isCreatingDungeonFog(this.currentRecipeContext, this);
        this.prevDungeonFogStrength = this.dungeonFogStrength;
        if (isCreatingDungeonFog && this.dungeonFogStrength < 1.0f) {
            this.dungeonFogStrength += 0.01f;
            if (this.dungeonFogStrength > 1.0f) {
                this.dungeonFogStrength = 1.0f;
            }
        } else if (!isCreatingDungeonFog && this.dungeonFogStrength > 0.0f) {
            this.dungeonFogStrength -= 0.01f;
            if (this.dungeonFogStrength < 0.0f) {
                this.dungeonFogStrength = 0.0f;
            }
        }
        this.prevEffectStrength = this.effectStrength;
        if (this.isRecipeRunning && this.effectStrength < 1.0f) {
            this.effectStrength += 0.01f;
            if (this.effectStrength > 1.0f) {
                this.effectStrength = 1.0f;
            }
        } else if (!this.isRecipeRunning && this.effectStrength > 0.0f) {
            this.effectStrength -= 0.01f;
            if (this.effectStrength < 0.0f) {
                this.effectStrength = 0.0f;
            }
        }
    }

    protected boolean canRecipeRun(boolean isFluidRecipe, ICenserRecipe<?> recipe) {
        return (!isFluidRecipe || this.fluidTank.getFluidAmount() > 0 && recipe.matchesInput(this.fluidTank.getFluid())) && (isFluidRecipe || !this.func_70301_a(2).func_190926_b() && this.remainingItemAmount > 0 && recipe.matchesInput(this.func_70301_a(2)));
    }

    protected ICenserRecipe<?> getEffect(FluidStack stack) {
        return AbstractCenserRecipe.getRecipe(stack);
    }

    protected ICenserRecipe<?> getEffect(ItemStack stack) {
        return AbstractCenserRecipe.getRecipe(stack);
    }

    protected boolean isFilled() {
        return this.fluidTank.getFluidAmount() > 0 || !this.func_70301_a(2).func_190926_b();
    }

    private void extractFluids(FluidStack fluid) {
        if (fluid.isFluidEqual(this.fluidTank.getFluid())) {
            this.fluidTank.drain(fluid.amount, true);
        }
        this.func_70296_d();
    }

    public boolean hasFuel() {
        return !this.func_70301_a(0).func_190926_b() && ItemMisc.EnumItemMisc.SULFUR.isItemOf(this.func_70301_a(0)) && this.func_70301_a(0).func_190916_E() >= 1;
    }

    @Nullable
    public ICenserRecipe<Object> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Nullable
    public Object getCurrentRecipeContext() {
        return this.currentRecipeContext;
    }

    @Override
    public int getCurrentRemainingInputAmount() {
        return this.isFluidRecipe ? this.fluidTank.getFluidAmount() : this.remainingItemAmount;
    }

    @Override
    public int getCurrentMaxInputAmount() {
        return this.isFluidRecipe ? this.fluidTank.getCapacity() : 1000;
    }

    public int getMaxFuelTicks() {
        return this.maxFuelTicks;
    }

    public int getFuelTicks() {
        return this.fuelTicks;
    }

    @Override
    public int[] func_180463_a(EnumFacing facing) {
        switch (facing) {
            case DOWN: 
            case UP: {
                return new int[]{1};
            }
        }
        return new int[]{0};
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        if (super.func_180462_a(slot, stack, side)) {
            FluidStack fluid;
            return slot != 1 || ((fluid = FluidUtil.getFluidContained((ItemStack)stack)) == null || this.getEffect(fluid) == null) && this.getEffect(stack) == null;
        }
        return false;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.remainingItemAmount > 0) {
            return 0;
        }
        if (doFill) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
            this.checkInternalSlotForRecipes = true;
            this.checkInputSlotForTransfer = true;
        }
        return this.fluidTank.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
            this.checkInternalSlotForRecipes = true;
            this.checkInputSlotForTransfer = true;
        }
        return this.fluidTank.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (doDrain) {
            this.func_70296_d();
            IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 2);
            this.checkInternalSlotForRecipes = true;
            this.checkInputSlotForTransfer = true;
        }
        return this.fluidTank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, facing);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getFogRenderArea();
    }

    public float getDungeonFogStrength(float partialTicks) {
        return this.prevDungeonFogStrength + (this.dungeonFogStrength - this.prevDungeonFogStrength) * partialTicks;
    }

    @Override
    public float getEffectStrength(float partialTicks) {
        return this.prevEffectStrength + (this.effectStrength - this.prevEffectStrength) * partialTicks;
    }

    @Override
    public boolean isRecipeRunning() {
        return this.isRecipeRunning;
    }

    public AxisAlignedBB getFogRenderArea() {
        float width = 13.0f;
        float height = 12.0f;
        BlockPos pos = this.getCenserPos();
        return new AxisAlignedBB((double)pos.func_177958_n() + 0.5 - (double)(width / 2.0f), (double)pos.func_177956_o() - 0.1, (double)pos.func_177952_p() + 0.5 - (double)(width / 2.0f), (double)pos.func_177958_n() + 0.5 + (double)(width / 2.0f), (double)pos.func_177956_o() - 0.1 + (double)height, (double)pos.func_177952_p() + 0.5 + (double)(width / 2.0f));
    }

    @Override
    public ItemStack getInputStack() {
        return this.func_70301_a(1);
    }

    @Override
    public World getCenserWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getCenserPos() {
        return this.func_174877_v();
    }
}

