/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.recipes.IAnimatorRecipe;
import thebetweenlands.client.audio.AnimatorSound;
import thebetweenlands.common.inventory.container.ContainerAnimator;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityAnimator
extends TileEntityBasicInventory
implements ITickable {
    public ItemStack itemToAnimate = ItemStack.field_190927_a;
    public int fuelBurnProgress;
    public int lifeCrystalLife;
    public int fuelConsumed = 0;
    public int requiredFuelCount = 32;
    public int requiredLifeCount = 32;
    public boolean itemAnimated = false;
    private int prevStackSize = 0;
    private ItemStack prevItem = ItemStack.field_190927_a;
    private boolean running = false;
    private boolean soundPlaying = false;

    public TileEntityAnimator() {
        super(3, "container.bl.animator");
    }

    public void func_73660_a() {
        IAnimatorRecipe recipe;
        if (this.isSlotInUse(0) && this.isValidFocalItem()) {
            this.itemToAnimate = (ItemStack)this.inventory.get(0);
            if (!this.field_145850_b.field_72995_K && (recipe = AnimatorRecipe.getRecipe(this.itemToAnimate)) != null) {
                this.requiredFuelCount = recipe.getRequiredFuel(this.itemToAnimate);
                this.requiredLifeCount = recipe.getRequiredLife(this.itemToAnimate);
            }
        } else {
            this.itemToAnimate = ItemStack.field_190927_a;
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldBeRunning;
            if (this.isCrystalInslot()) {
                this.lifeCrystalLife = 128 - this.getCrystalPower();
            }
            if (!(this.isSlotInUse(0) && this.isSlotInUse(1) && this.isSlotInUse(2))) {
                this.fuelBurnProgress = 0;
                this.fuelConsumed = 0;
            }
            if (!this.itemToAnimate.func_190926_b() && this.isCrystalInslot() && this.isSulfurInSlot() && this.fuelConsumed < this.requiredFuelCount && this.isValidFocalItem() && this.lifeCrystalLife >= this.requiredLifeCount) {
                ++this.fuelBurnProgress;
                if (this.fuelBurnProgress >= 42) {
                    this.fuelBurnProgress = 0;
                    this.func_70298_a(2, 1);
                    ++this.fuelConsumed;
                    this.func_70296_d();
                }
                this.itemAnimated = false;
            }
            if (!(!this.isSlotInUse(2) || this.itemAnimated || this.isSlotInUse(0) && this.isSlotInUse(1))) {
                this.fuelBurnProgress = 0;
                this.fuelConsumed = 0;
            }
            if (this.fuelConsumed >= this.requiredFuelCount && this.isSlotInUse(0) && this.isSlotInUse(1) && !this.itemAnimated) {
                recipe = AnimatorRecipe.getRecipe((ItemStack)this.inventory.get(0));
                if (recipe != null) {
                    ItemStack result = recipe.onAnimated(this.field_145850_b, this.func_174877_v(), (ItemStack)this.inventory.get(0));
                    if (result.func_190926_b()) {
                        result = recipe.getResult((ItemStack)this.inventory.get(0));
                    }
                    if (!result.func_190926_b()) {
                        this.func_70299_a(0, result.func_77946_l());
                    }
                }
                ((ItemStack)this.inventory.get(1)).func_77964_b(((ItemStack)this.inventory.get(1)).func_77952_i() + this.requiredLifeCount);
                this.func_70296_d();
                this.itemAnimated = true;
            }
            if (this.prevStackSize != (this.isSlotInUse(0) ? ((ItemStack)this.inventory.get(0)).func_190916_E() : 0)) {
                this.func_70296_d();
            }
            if (this.prevItem != (this.isSlotInUse(0) ? (ItemStack)this.inventory.get(0) : ItemStack.field_190927_a)) {
                this.func_70296_d();
            }
            this.prevItem = this.isSlotInUse(0) ? (ItemStack)this.inventory.get(0) : ItemStack.field_190927_a;
            this.prevStackSize = this.isSlotInUse(0) ? ((ItemStack)this.inventory.get(0)).func_190916_E() : 0;
            boolean bl = shouldBeRunning = this.isSlotInUse(0) && this.isCrystalInslot() && this.isSulfurInSlot() && this.fuelConsumed < this.requiredFuelCount && this.lifeCrystalLife >= this.requiredLifeCount && this.isValidFocalItem();
            if (this.running != shouldBeRunning) {
                this.running = shouldBeRunning;
                this.func_70296_d();
            }
            this.func_145836_u();
        } else if (this.isRunning() && !this.soundPlaying) {
            this.playAnimatorSound();
            this.soundPlaying = true;
        } else if (!this.isRunning()) {
            this.soundPlaying = false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playAnimatorSound() {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new AnimatorSound(SoundRegistry.ANIMATOR, SoundCategory.BLOCKS, this));
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.size() <= 0;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public boolean isCrystalInslot() {
        return this.isSlotInUse(1) && ((ItemStack)this.inventory.get(1)).func_77973_b() == ItemRegistry.LIFE_CRYSTAL && ((ItemStack)this.inventory.get(1)).func_77952_i() < ((ItemStack)this.inventory.get(1)).func_77958_k();
    }

    public int getCrystalPower() {
        if (this.isCrystalInslot()) {
            return ((ItemStack)this.inventory.get(1)).func_77952_i();
        }
        return 0;
    }

    public boolean isSulfurInSlot() {
        return this.isSlotInUse(2) && ((ItemStack)this.inventory.get(2)).func_77973_b() == ItemRegistry.ITEMS_MISC && ((ItemStack)this.inventory.get(2)).func_77952_i() == ItemMisc.EnumItemMisc.SULFUR.getID();
    }

    public boolean isSlotInUse(int slot) {
        return !((ItemStack)this.inventory.get(slot)).func_190926_b();
    }

    public boolean isValidFocalItem() {
        return !((ItemStack)this.inventory.get(0)).func_190926_b() && AnimatorRecipe.getRecipe((ItemStack)this.inventory.get(0)) != null;
    }

    public void sendGUIData(ContainerAnimator animator, IContainerListener listener) {
        listener.func_71112_a((Container)animator, 0, this.fuelBurnProgress);
        listener.func_71112_a((Container)animator, 1, this.lifeCrystalLife);
        listener.func_71112_a((Container)animator, 2, this.itemAnimated ? 1 : 0);
        listener.func_71112_a((Container)animator, 3, this.fuelConsumed);
        listener.func_71112_a((Container)animator, 4, this.requiredFuelCount);
        listener.func_71112_a((Container)animator, 5, this.requiredLifeCount);
    }

    public void getGUIData(int id, int value) {
        switch (id) {
            case 0: {
                this.fuelBurnProgress = value;
                break;
            }
            case 1: {
                this.lifeCrystalLife = value;
                break;
            }
            case 2: {
                this.itemAnimated = value == 1;
                break;
            }
            case 3: {
                this.fuelConsumed = value;
                break;
            }
            case 4: {
                this.requiredFuelCount = value;
                break;
            }
            case 5: {
                this.requiredLifeCount = value;
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeNBT(nbt);
        return nbt;
    }

    protected void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("life", this.lifeCrystalLife);
        nbt.func_74768_a("progress", this.fuelBurnProgress);
        nbt.func_74768_a("itemsConsumed", this.fuelConsumed);
        nbt.func_74757_a("lifeDepleted", this.itemAnimated);
        NBTTagCompound toAnimateCompound = new NBTTagCompound();
        if (!this.itemToAnimate.func_190926_b()) {
            this.itemToAnimate.func_77955_b(toAnimateCompound);
        }
        nbt.func_74782_a("toAnimate", (NBTBase)toAnimateCompound);
        nbt.func_74757_a("running", this.running);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readNBT(nbt);
    }

    protected void readNBT(NBTTagCompound nbt) {
        this.lifeCrystalLife = nbt.func_74762_e("life");
        this.fuelBurnProgress = nbt.func_74762_e("progress");
        this.fuelConsumed = nbt.func_74762_e("itemsConsumed");
        this.itemAnimated = nbt.func_74767_n("lifeDepleted");
        NBTTagCompound toAnimateStackCompound = nbt.func_74775_l("toAnimate");
        this.itemToAnimate = toAnimateStackCompound.func_150297_b("id", 8) ? new ItemStack(toAnimateStackCompound) : ItemStack.field_190927_a;
        this.running = nbt.func_74767_n("running");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeNBT(nbt);
        this.writeInventoryNBT(nbt);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound nbt = packet.func_148857_g();
        this.readNBT(nbt);
        this.readInventoryNBT(nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeNBT(nbt);
        this.writeInventoryNBT(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound nbt) {
        super.handleUpdateTag(nbt);
        this.readNBT(nbt);
        this.readInventoryNBT(nbt);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (slot == 1 && !stack.func_190926_b() && stack.func_77973_b().equals(ItemRegistry.LIFE_CRYSTAL)) {
            return true;
        }
        if (slot == 2 && !stack.func_190926_b() && stack.func_77973_b().equals(ItemRegistry.ITEMS_MISC) && stack.func_77952_i() == ItemMisc.EnumItemMisc.SULFUR.getID()) {
            return true;
        }
        return slot == 0 && ((ItemStack)this.inventory.get(0)).func_190926_b();
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            return new int[]{0};
        }
        return new int[]{1, 2};
    }
}

