/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.herblore.elixir.effects.ElixirEffect;
import thebetweenlands.common.registries.AspectRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class TileEntityAlembic
extends TileEntity
implements ITickable {
    public static final int DISTILLING_TIME = 4800;
    public static final int AMOUNT_PER_VIAL = 5000;
    public static final float ISOLATION_LOSS_MULTIPLIER = 0.15f;
    private boolean running = false;
    private int progress = 0;
    private ItemStack infusionBucket = ItemStack.field_190927_a;
    private int producedAmount = 0;
    private int producableAmount = 0;
    private int producableStrength;
    private int producableDuration;
    private ElixirEffect producableElixir = null;
    private List<Aspect> producableItemAspects = new ArrayList<Aspect>();
    private ElixirRecipe recipe = null;
    private int bucketInfusionTime;
    private boolean loadInfusionData = false;

    public void addInfusion(ItemStack bucket) {
        this.infusionBucket = bucket.func_77946_l();
        this.loadFromInfusion();
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (this.loadInfusionData) {
            this.loadFromInfusion();
            this.loadInfusionData = false;
        }
        if (this.isFull() && !this.hasFinished()) {
            ++this.progress;
            if (!this.field_145850_b.field_72995_K) {
                if (!this.running || this.progress % 20 == 0) {
                    this.func_70296_d();
                }
                this.running = true;
                if (this.hasFinished()) {
                    this.producedAmount = this.producableAmount;
                }
            }
        } else if (!this.field_145850_b.field_72995_K) {
            if (this.running) {
                this.func_70296_d();
            }
            this.running = false;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.infusionBucket.func_190926_b()) {
            nbt.func_74782_a("infusionBucket", (NBTBase)this.infusionBucket.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("producedAmount", this.producedAmount);
        nbt.func_74757_a("running", this.running);
        NBTTagList aspectList = new NBTTagList();
        for (Aspect aspect : this.producableItemAspects) {
            NBTTagCompound aspectCompound = new NBTTagCompound();
            aspect.writeToNBT(aspectCompound);
            aspectList.func_74742_a((NBTBase)aspectCompound);
        }
        nbt.func_74782_a("producableItemAspects", (NBTBase)aspectList);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("infusionBucket")) {
            this.infusionBucket = new ItemStack(nbt.func_74775_l("infusionBucket"));
        }
        this.loadInfusionData = true;
        this.progress = nbt.func_74762_e("progress");
        this.producedAmount = nbt.func_74762_e("producedAmount");
        this.running = nbt.func_74767_n("running");
        if (nbt.func_74764_b("producableItemAspects")) {
            this.producableItemAspects.clear();
            NBTTagList aspectList = nbt.func_150295_c("producableItemAspects", 10);
            for (int i = 0; i < aspectList.func_74745_c(); ++i) {
                NBTTagCompound aspectCompound = aspectList.func_150305_b(i);
                Aspect aspect = Aspect.readFromNBT(aspectCompound);
                this.producableItemAspects.add(aspect);
            }
        }
    }

    public void func_70296_d() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        super.func_70296_d();
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a("running", this.running);
        NBTTagCompound itemStackCompound = new NBTTagCompound();
        if (!this.infusionBucket.func_190926_b()) {
            this.infusionBucket.func_77955_b(itemStackCompound);
        }
        nbt.func_74782_a("infusionBucket", (NBTBase)itemStackCompound);
        nbt.func_74768_a("progress", this.progress);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.running = tag.func_74767_n("running");
        NBTTagCompound itemStackCompound = tag.func_74775_l("infusionBucket");
        ItemStack oldStack = this.infusionBucket;
        this.infusionBucket = itemStackCompound.func_74764_b("id") && !itemStackCompound.func_74779_i("id").isEmpty() ? new ItemStack(itemStackCompound) : ItemStack.field_190927_a;
        if (!this.infusionBucket.func_190926_b() && !ItemStack.func_77989_b((ItemStack)this.infusionBucket, (ItemStack)oldStack)) {
            this.loadFromInfusion();
        }
        this.progress = tag.func_74762_e("progress");
    }

    public ElixirRecipe getElixirRecipe() {
        return this.recipe;
    }

    public int getInfusionTime() {
        return this.bucketInfusionTime;
    }

    public float getProgress() {
        return (float)this.progress / 4800.0f;
    }

    private void loadFromInfusion() {
        boolean bl;
        ElixirRecipe recipe;
        int infusionTime;
        this.recipe = null;
        if (this.infusionBucket.func_190926_b() || this.infusionBucket.func_77978_p() == null) {
            return;
        }
        this.bucketInfusionTime = infusionTime = this.infusionBucket.func_77978_p().func_74762_e("infusionTime");
        if (this.infusionBucket.func_77978_p() == null || !this.infusionBucket.func_77978_p().func_74764_b("ingredients")) {
            this.addInvalidInfusion();
            return;
        }
        NBTTagList nbtList = (NBTTagList)this.infusionBucket.func_77978_p().func_74781_a("ingredients");
        ArrayList<ItemStack> infusionIngredients = new ArrayList<ItemStack>();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            infusionIngredients.add(new ItemStack(nbtList.func_150305_b(i)));
        }
        List<IAspectType> infusionAspects = this.getInfusionAspects(infusionIngredients);
        this.recipe = recipe = ElixirRecipes.getFromAspects(infusionAspects);
        if (recipe == null || infusionTime < recipe.idealInfusionTime - recipe.infusionTimeVariation || infusionTime > recipe.idealInfusionTime + recipe.infusionTimeVariation) {
            this.addInvalidInfusion();
            return;
        }
        List<Aspect> infusionItemAspects = this.getInfusionItemAspects(infusionIngredients);
        int totalAmount = 500;
        int strengthAspectAmount = 0;
        int durationAspectAmount = 0;
        for (Aspect aspect : infusionItemAspects) {
            totalAmount += aspect.amount;
            if (recipe.strengthAspect != null && aspect.type == recipe.strengthAspect) {
                strengthAspectAmount += aspect.amount;
            }
            if (recipe.durationAspect == null || aspect.type != recipe.durationAspect) continue;
            durationAspectAmount += aspect.amount;
        }
        int recipeByariis = 0;
        for (IAspectType a : recipe.aspects) {
            if (a != AspectRegistry.BYARIIS) continue;
            ++recipeByariis;
        }
        this.producableAmount = totalAmount;
        boolean bl2 = true;
        for (IAspectType a : infusionAspects) {
            if (a != AspectRegistry.BYARIIS) continue;
            if (recipeByariis <= 0) {
                bl = !bl;
                continue;
            }
            --recipeByariis;
        }
        this.producableElixir = bl ? recipe.positiveElixir : recipe.negativeElixir;
        float relStrengthAmount = (float)strengthAspectAmount / 30000.0f;
        float relDurationAmount = (float)durationAspectAmount / 30000.0f;
        this.producableStrength = MathHelper.func_76141_d((float)(relStrengthAmount * 5.0f));
        this.producableDuration = bl ? recipe.baseDuration + MathHelper.func_76141_d((float)((float)recipe.durationModifier * relDurationAmount)) : recipe.negativeBaseDuration + MathHelper.func_76141_d((float)((float)recipe.negativeDurationModifier * relDurationAmount));
    }

    private void addInvalidInfusion() {
        this.producableElixir = null;
        this.producableAmount = 0;
        this.producableDuration = 0;
        this.producableStrength = 0;
        this.producableItemAspects.clear();
        if (!this.infusionBucket.func_190926_b() && this.infusionBucket.func_77978_p() != null && this.infusionBucket.func_77978_p().func_74764_b("ingredients")) {
            NBTTagList nbtList = (NBTTagList)this.infusionBucket.func_77978_p().func_74781_a("ingredients");
            ArrayList<ItemStack> infusionIngredients = new ArrayList<ItemStack>();
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                infusionIngredients.add(new ItemStack(nbtList.func_150305_b(i)));
            }
            List<Aspect> infusionAspects = this.getInfusionItemAspects(infusionIngredients);
            for (Aspect aspect : infusionAspects) {
                this.producableItemAspects.add(new Aspect(aspect.type, MathHelper.func_76141_d((float)((float)aspect.amount * 0.85f / 3.0f))));
            }
        }
    }

    public List<IAspectType> getInfusionAspects(List<ItemStack> ingredients) {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        for (ItemStack ingredient : ingredients) {
            ItemAspectContainer container = ItemAspectContainer.fromItem(ingredient, AspectManager.get(this.field_145850_b));
            for (Aspect aspect : container.getAspects()) {
                infusingAspects.add(aspect.type);
            }
        }
        return infusingAspects;
    }

    private List<Aspect> getInfusionItemAspects(List<ItemStack> ingredients) {
        ArrayList<Aspect> infusingItemAspects = new ArrayList<Aspect>();
        for (ItemStack ingredient : ingredients) {
            ItemAspectContainer container = ItemAspectContainer.fromItem(ingredient, AspectManager.get(this.field_145850_b));
            infusingItemAspects.addAll(container.getAspects());
        }
        return infusingItemAspects;
    }

    public boolean isFull() {
        return !this.infusionBucket.func_190926_b();
    }

    public boolean hasFinished() {
        return this.progress >= 4800;
    }

    public boolean hasElixir() {
        return (float)this.producedAmount > 0.0f;
    }

    public boolean isRunning() {
        return this.running;
    }

    public ItemStack getElixir(int vialType) {
        if (this.isFull() && this.hasFinished()) {
            if (this.producableElixir != null) {
                ItemStack elixir = ItemStack.field_190927_a;
                if (this.hasElixir()) {
                    elixir = this.createElixir(this.producableElixir, this.producableStrength, this.producableDuration, vialType);
                }
                this.producedAmount -= 5000;
                if ((float)this.producedAmount <= 0.0f || !this.hasElixir()) {
                    this.reset();
                }
                return elixir;
            }
            ItemStack aspectVial = ItemStack.field_190927_a;
            if (this.producableItemAspects.size() >= 1) {
                Aspect aspect = this.producableItemAspects.get(0);
                this.producableItemAspects.remove(0);
                int removedAmount = aspect.amount;
                Iterator<Aspect> itemAspectIT = this.producableItemAspects.iterator();
                while (itemAspectIT.hasNext()) {
                    Aspect currentAspect = itemAspectIT.next();
                    if (currentAspect.type != aspect.type) continue;
                    removedAmount += currentAspect.amount;
                    itemAspectIT.remove();
                }
                if (removedAmount > 5000) {
                    this.producableItemAspects.add(new Aspect(aspect.type, removedAmount - 5000));
                    removedAmount = 5000;
                }
                aspectVial = new ItemStack((Item)ItemRegistry.ASPECT_VIAL, 1, vialType);
                ItemAspectContainer aspectContainer = ItemAspectContainer.fromItem(aspectVial);
                aspectContainer.add(aspect.type, removedAmount);
            }
            if (this.producableItemAspects.size() == 0) {
                this.reset();
            }
            return aspectVial;
        }
        return null;
    }

    public void reset() {
        this.producableItemAspects.clear();
        this.infusionBucket = ItemStack.field_190927_a;
        this.producableAmount = 0;
        this.producableDuration = 0;
        this.producableElixir = null;
        this.producableStrength = 0;
        this.producedAmount = 0;
        this.progress = 0;
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    private ItemStack createElixir(ElixirEffect elixir, int strength, int duration, int vialType) {
        return ItemRegistry.ELIXIR.getElixirItem(elixir, duration, strength, vialType);
    }
}

