/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.equipment;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.common.item.equipment.ItemRing;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.util.NBTHelper;

public class ItemRingOfPower
extends ItemRing {
    public static final UUID POWER_SPEED_MODIFIER_ATTRIBUTE_UUID = UUID.fromString("ac457979-c0c4-4782-bfc3-53f995b21a4b");

    public ItemRingOfPower() {
        this.func_77656_e(1800);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.addAll(ItemTooltipHandler.splitTooltip(I18n.func_135052_a((String)"tooltip.bl.ring.power.bonus", (Object[])new Object[0]), 0));
        if (GuiScreen.func_146272_n()) {
            String toolTip = I18n.func_135052_a((String)"tooltip.bl.ring.power", (Object[])new Object[]{KeyBindRegistry.RADIAL_MENU.getDisplayName()});
            list.addAll(ItemTooltipHandler.splitTooltip(toolTip, 1));
        } else {
            list.add(I18n.func_135052_a((String)"tooltip.bl.press.shift", (Object[])new Object[0]));
        }
    }

    @Override
    public void onEquip(ItemStack stack, Entity entity, IInventory inventory) {
        IAttributeInstance speedAttrib;
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("ringActive", true);
        if (entity instanceof EntityLivingBase && (speedAttrib = ((EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_111263_d)) != null && speedAttrib.func_111127_a(POWER_SPEED_MODIFIER_ATTRIBUTE_UUID) == null) {
            speedAttrib.func_111121_a(new AttributeModifier(POWER_SPEED_MODIFIER_ATTRIBUTE_UUID, "Ring of power speed modifier", 0.2, 2));
        }
    }

    @Override
    public void onUnequip(ItemStack stack, Entity entity, IInventory inventory) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74757_a("ringActive", false);
        if (entity instanceof EntityLivingBase) {
            IAttributeInstance speedAttrib;
            boolean hasOtherRing = false;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack invStack = inventory.func_70301_a(i);
                if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof ItemRingOfPower) || invStack == stack) continue;
                hasOtherRing = true;
                break;
            }
            if (!hasOtherRing && (speedAttrib = ((EntityLivingBase)entity).func_110148_a(SharedMonsterAttributes.field_111263_d)) != null) {
                speedAttrib.func_188479_b(POWER_SPEED_MODIFIER_ATTRIBUTE_UUID);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("ringActive");
    }
}

