/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.item.armor.ItemRubberBoots;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.util.NBTHelper;

public class ItemMarshRunnerBoots
extends ItemRubberBoots {
    private static final int MAX_WALK_TICKS = 30;

    @Override
    public boolean func_82789_a(ItemStack armour, ItemStack material) {
        return ItemMisc.EnumItemMisc.RUBBER_BALL.isItemOf(material);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(itemStack);
        int walkTicksLeft = nbt.func_74762_e("walkTicksLeft");
        IBlockState blockBelowPlayer = world.func_180495_p(player.func_180425_c().func_177977_b());
        if (player.field_70122_E && blockBelowPlayer.func_177230_c() instanceof BlockSwampWater) {
            player.field_70159_w *= 0.03333333333333333 * (double)walkTicksLeft;
            player.field_70179_y *= 0.03333333333333333 * (double)walkTicksLeft;
        }
        if (!player.field_70170_p.field_72995_K) {
            boolean playerOnGround;
            boolean bl = playerOnGround = player.field_70122_E && !player.func_70090_H() && !(blockBelowPlayer.func_177230_c() instanceof BlockSwampWater);
            if (walkTicksLeft == 0 || playerOnGround) {
                nbt.func_74768_a("walkTicksLeft", 30);
            } else if (walkTicksLeft > 1) {
                nbt.func_74768_a("walkTicksLeft", --walkTicksLeft);
            }
        }
    }

    public static boolean checkPlayerWalkOnWater(EntityPlayer player) {
        if (player.func_70093_af() || ElixirEffectRegistry.EFFECT_HEAVYWEIGHT.isActive((EntityLivingBase)player)) {
            return false;
        }
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        return !boots.func_190926_b() && boots.func_77973_b() instanceof ItemMarshRunnerBoots && boots.func_77978_p() != null && boots.func_77978_p().func_74762_e("walkTicksLeft") > 1;
    }

    public static double getWalkPercentage(EntityPlayer player) {
        ItemStack boots = (ItemStack)player.field_71071_by.field_70460_b.get(0);
        if (!boots.func_190926_b() && boots.func_77973_b() instanceof ItemMarshRunnerBoots && boots.func_77978_p() != null) {
            return (double)boots.func_77978_p().func_74762_e("walkTicksLeft") / 30.0;
        }
        return 0.0;
    }
}

