/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.book.GuiManualHerblore;
import thebetweenlands.common.herblore.book.HLEntryRegistry;
import thebetweenlands.common.herblore.book.ManualCategory;
import thebetweenlands.common.herblore.book.Page;
import thebetweenlands.common.registries.ItemRegistry;

@SideOnly(value=Side.CLIENT)
public class ManualWidgetBase {
    public static ResourceLocation icons = new ResourceLocation("thebetweenlands:textures/gui/manual/icons.png");
    public static String processTimeString = I18n.func_74838_a((String)"manual.widget.process.time");
    public static String processTimeMinutesString = I18n.func_74838_a((String)"manual.widget.process.time.minutes");
    public static String processTimeSecondsString = I18n.func_74838_a((String)"manual.widget.process.time.seconds");
    public static String burnTimeString = I18n.func_74838_a((String)"manual.widget.burn.time");
    public ArrayList<PageLink> pageLinks = new ArrayList();
    public GuiManualHerblore manual;
    public int unchangedXStart;
    public int unchangedYStart;
    public int xStart;
    public int yStart;
    public boolean isPageRight = false;
    public boolean isEmpty = false;
    protected int mouseX;
    protected int mouseY;

    @SideOnly(value=Side.CLIENT)
    public ManualWidgetBase(int xStart, int yStart) {
        this.unchangedXStart = xStart;
        this.unchangedYStart = yStart;
    }

    @SideOnly(value=Side.CLIENT)
    public static int renderTooltip(int x, int y, List<String> tooltipData, int color, int color2) {
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        int var7 = -12;
        if (!tooltipData.isEmpty()) {
            int var6;
            int var5 = 0;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (var6 = 0; var6 < tooltipData.size(); ++var6) {
                var7 = fontRenderer.func_78256_a(tooltipData.get(var6));
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 12;
            var7 = y - 12;
            int var9 = 8;
            if (tooltipData.size() > 1) {
                var9 += 2 + (tooltipData.size() - 1) * 10;
            }
            float z = 300.0f;
            ManualWidgetBase.drawGradientRect(var6 - 3, var7 - 4, z, var6 + var5 + 3, var7 - 3, color2, color2);
            ManualWidgetBase.drawGradientRect(var6 - 3, var7 + var9 + 3, z, var6 + var5 + 3, var7 + var9 + 4, color2, color2);
            ManualWidgetBase.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 + var9 + 3, color2, color2);
            ManualWidgetBase.drawGradientRect(var6 - 4, var7 - 3, z, var6 - 3, var7 + var9 + 3, color2, color2);
            ManualWidgetBase.drawGradientRect(var6 + var5 + 3, var7 - 3, z, var6 + var5 + 4, var7 + var9 + 3, color2, color2);
            int var12 = (color & 0xFFFFFF) >> 1 | color & 0xFF000000;
            ManualWidgetBase.drawGradientRect(var6 - 3, var7 - 3 + 1, z, var6 - 3 + 1, var7 + var9 + 3 - 1, color, var12);
            ManualWidgetBase.drawGradientRect(var6 + var5 + 2, var7 - 3 + 1, z, var6 + var5 + 3, var7 + var9 + 3 - 1, color, var12);
            ManualWidgetBase.drawGradientRect(var6 - 3, var7 - 3, z, var6 + var5 + 3, var7 - 3 + 1, color, color);
            ManualWidgetBase.drawGradientRect(var6 - 3, var7 + var9 + 2, z, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            GlStateManager.func_179097_i();
            for (int var13 = 0; var13 < tooltipData.size(); ++var13) {
                String var14 = tooltipData.get(var13);
                fontRenderer.func_175063_a(var14, (float)var6, (float)var7, -1);
                if (var13 == 0) {
                    var7 += 2;
                }
                var7 += 10;
            }
            GlStateManager.func_179126_j();
        }
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return var7 + 12;
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(int left, int top, float z, int right, int bottom, int startColor, int endColor) {
        float var7 = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float var8 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float var9 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float var10 = (float)(startColor & 0xFF) / 255.0f;
        float var11 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float var12 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float var13 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float var14 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_181662_b((double)right, (double)top, (double)z).func_181666_a(var8, var9, var10, var7).func_181675_d();
        vertexBuffer.func_181662_b((double)left, (double)top, (double)z).func_181666_a(var8, var9, var10, var7).func_181675_d();
        vertexBuffer.func_181662_b((double)left, (double)bottom, (double)z).func_181666_a(var12, var13, var14, var11).func_181675_d();
        vertexBuffer.func_181662_b((double)right, (double)bottom, (double)z).func_181666_a(var12, var13, var14, var11).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public void init(GuiManualHerblore manual) {
        this.manual = manual;
        this.resize();
    }

    @SideOnly(value=Side.CLIENT)
    public void setPageToLeft() {
        this.isPageRight = false;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPageToRight() {
        this.isPageRight = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.drawBackGround();
        this.pageLinks.clear();
        this.drawForeGround();
    }

    @SideOnly(value=Side.CLIENT)
    public void resize() {
        this.xStart = (this.isPageRight ? this.manual.xStartRightPage : this.manual.xStart) + this.unchangedXStart;
        this.yStart = this.manual.yStart + this.unchangedYStart;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBackGround() {
    }

    @SideOnly(value=Side.CLIENT)
    public void changeXStart(int xStart) {
        this.unchangedXStart = xStart;
    }

    @SideOnly(value=Side.CLIENT)
    public void changeYStart(int yStart) {
        this.unchangedYStart = yStart;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawForeGround() {
    }

    @SideOnly(value=Side.CLIENT)
    public void drawToolTip() {
    }

    @SideOnly(value=Side.CLIENT)
    public void keyTyped(char c, int key) {
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (this.manual.untilUpdate % 5 == 0) {
            this.resize();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(int x, int y, int mouseButton) {
        if (mouseButton == 0) {
            for (PageLink link : this.pageLinks) {
                if (x < link.x || y < link.y || x > link.x + link.width || y > link.y + link.height) continue;
                this.manual.changeCategory(link.category, link.pageNumber + link.category.getIndexPages());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(int xPos, int yPos, ItemStack stack, boolean hasSpecialTooltip, boolean addPageLink, Item book) {
        RenderItem render = Minecraft.func_71410_x().func_175599_af();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        GlStateManager.func_179126_j();
        render.func_180450_b(stack, xPos, yPos);
        render.func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, xPos, yPos);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        boolean shouldShowTooltip = false;
        if (addPageLink) {
            int lengthBefore = this.pageLinks.size();
            PageLink link = new PageLink(xPos, yPos, 16, 16, stack, book);
            if (link.category != null) {
                this.pageLinks.add(link);
            }
            boolean bl = shouldShowTooltip = this.pageLinks.size() > lengthBefore;
        }
        if (!hasSpecialTooltip && this.mouseX >= xPos && this.mouseY >= yPos && this.mouseX <= xPos + 16 && this.mouseY <= yPos + 16 && !stack.func_190926_b()) {
            List tooltipData = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            if (addPageLink && shouldShowTooltip) {
                tooltipData.add(I18n.func_94522_b((String)"manual.open_entry") ? I18n.func_74838_a((String)"manual.open_entry") : I18n.func_150826_b((String)"manual.open_entry"));
            }
            Iterator iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = (String)iterator.next();
                if (!first) {
                    s_ = TextFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            ManualWidgetBase.renderTooltip(this.mouseX, this.mouseY, parsedTooltip, 0xFFFFFF, -267386864);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void addSpecialItemTooltip(int xPos, int yPos, ItemStack stack, ArrayList<String> toolTips) {
        if (this.mouseX >= xPos && this.mouseY >= yPos && this.mouseX <= xPos + 16 && this.mouseY <= yPos + 16 && stack != null) {
            List tooltipData = stack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            ArrayList<String> parsedTooltip = new ArrayList<String>();
            boolean first = true;
            for (String tip : toolTips) {
                tooltipData.add(tip);
            }
            Iterator<String> iterator = tooltipData.iterator();
            while (iterator.hasNext()) {
                String s;
                String s_ = s = iterator.next();
                if (!first) {
                    s_ = TextFormatting.GRAY + s;
                }
                parsedTooltip.add(s_);
                first = false;
            }
            ManualWidgetBase.renderTooltip(this.mouseX, this.mouseY, parsedTooltip, 0xFFFFFF, -267386864);
        }
    }

    public static class PageLink {
        public int x;
        public int y;
        public int width;
        public int height;
        public int pageNumber;
        public ManualCategory category;

        public PageLink(int x, int y, int width, int height, ItemStack item, Item book) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            if (item != null && book == ItemRegistry.MANUAL_HL) {
                for (ManualCategory category : HLEntryRegistry.CATEGORIES) {
                    block1: for (Page page : category.getVisiblePages()) {
                        if (page.pageItems.size() <= 0) continue;
                        for (ItemStack stack : page.pageItems) {
                            if (stack == null || stack.func_77973_b() != item.func_77973_b() || stack.func_77952_i() != item.func_77952_i() && stack.func_77952_i() != item.func_77952_i() - 1) continue;
                            this.pageNumber = page.pageNumber;
                            this.category = category;
                            continue block1;
                        }
                    }
                }
            }
        }

        public PageLink(int x, int y, int width, int height, IAspectType aspectType) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            if (aspectType != null) {
                for (Page page : HLEntryRegistry.aspectCategory.getVisiblePages()) {
                    if (page.pageAspects.size() <= 0 || !page.pageAspects.contains(aspectType)) continue;
                    this.pageNumber = page.pageNumber;
                    this.category = HLEntryRegistry.aspectCategory;
                    break;
                }
            }
        }

        public String toString() {
            return "page number: " + this.pageNumber + ", category name: " + this.category.getName() + ", xStart: " + this.x + ", yStart: " + this.y + ", width: " + this.width + ", height: " + this.height;
        }
    }
}

