/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.book.widgets.ManualWidgetBase;

@SideOnly(value=Side.CLIENT)
public class AspectItemSlideShowWidget
extends ManualWidgetBase {
    public IAspectType aspectType;
    public ArrayList<ItemStack> items = new ArrayList();
    public int currentItems = 0;

    public AspectItemSlideShowWidget(int xStart, int yStart, IAspectType aspectType) {
        super(xStart, yStart);
        this.aspectType = aspectType;
        this.currentItems = 0;
    }

    public AspectItemSlideShowWidget(int xStart, int yStart, ArrayList<ItemStack> items) {
        super(xStart, yStart);
        this.items = items;
        this.currentItems = 0;
    }

    @Override
    public void drawForeGround() {
        super.drawForeGround();
        if (this.items.size() < this.currentItems) {
            this.currentItems = this.items.size();
        }
        List<ItemStack> subItems = this.items.subList(this.currentItems, this.currentItems + (this.items.size() - this.currentItems > 5 ? 6 : this.items.size() - this.currentItems));
        int width = 0;
        for (ItemStack itemStack : subItems) {
            this.renderItem(this.xStart + width, this.yStart, itemStack, false, true, this.manual.manualType);
            width += 18;
        }
    }

    @Override
    public void resize() {
        super.resize();
        if (this.aspectType != null) {
            this.getItems();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.manual.untilUpdate % 60 == 0) {
            this.currentItems = this.currentItems + 1 < this.items.size() && this.items.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    @Override
    public void mouseClicked(int x, int y, int mouseButton) {
        super.mouseClicked(x, y, mouseButton);
        if (mouseButton == 2 && x >= this.xStart && x <= this.xStart + 96 && y >= this.yStart && y <= this.yStart + 16) {
            this.currentItems = this.currentItems + 1 < this.items.size() && this.items.size() - this.currentItems > 6 ? ++this.currentItems : 0;
            this.drawForeGround();
        }
    }

    public void getItems() {
        this.items.clear();
        AspectManager manager = AspectManager.get((World)Minecraft.func_71410_x().field_71441_e);
        for (Map.Entry<AspectItem, List<AspectManager.AspectItemEntry>> entry : AspectManager.getRegisteredItems().entrySet()) {
            List<Aspect> discoveredAspects = manager.getDiscoveredStaticAspects(entry.getKey(), DiscoveryContainer.getMergedDiscoveryContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            for (Aspect aspect : discoveredAspects) {
                if (!aspect.type.equals(this.aspectType)) continue;
                this.items.add(new ItemStack(entry.getKey().getOriginal().func_77973_b(), 1, entry.getKey().getOriginal().func_77952_i()));
            }
        }
    }
}

