/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.common.entity.mobs.EntityMovingWallFace;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFace;
import thebetweenlands.common.entity.mobs.EntitySpiritTreeFaceSmallBase;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityTamedSpiritTreeFace
extends EntitySpiritTreeFaceSmallBase {
    public EntityTamedSpiritTreeFace(World world) {
        super(world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, false, false, e -> IMob.field_175450_e.apply(e) && !(e instanceof EntityTamedSpiritTreeFace)));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntitySpiritTreeFace.AITrackTargetSpiritTreeFace(this, true, 16.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityMovingWallFace.AIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntitySpiritTreeFace.AISpit(this, 5.0f, 30, 70){

            @Override
            protected float getSpitDamage() {
                return (float)EntityTamedSpiritTreeFace.this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            }
        });
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIWanterTamedSpiritTreeFace(this, 8.0, 0.33, 200));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f){

            public void func_75246_d() {
                EntityTamedSpiritTreeFace.this.getLookHelper().setSpeed(0.33);
                super.func_75246_d();
            }
        });
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this){

            public void func_75246_d() {
                EntityTamedSpiritTreeFace.this.getLookHelper().setSpeed(0.33);
                super.func_75246_d();
            }
        });
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected void fixUnsuitablePosition(int violatedChecks) {
        if (this.isAnchored() && (violatedChecks & 3) != 0) {
            this.setAnchored(false);
        }
        super.fixUnsuitablePosition(violatedChecks);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() instanceof EntityPlayer) {
            return super.func_70097_a(source, amount);
        }
        return false;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean holdsEquipment;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = holdsEquipment = hand == EnumHand.MAIN_HAND && !stack.func_190926_b() && (stack.func_77973_b() instanceof IEquippable || stack.func_77973_b() == ItemRegistry.AMULET_SLOT);
        if (holdsEquipment) {
            return true;
        }
        if (!stack.func_190926_b() && ItemMisc.EnumItemMisc.COMPOST.isItemOf(stack)) {
            double d2;
            double d1;
            double d0;
            int i;
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70691_i(4.0f);
                } else {
                    for (i = 0; i < 7; ++i) {
                        d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                    }
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.func_70099_a(new ItemStack(ItemRegistry.SAP_SPIT, 1 + this.field_70146_Z.nextInt(3)), this.field_70131_O / 2.0f);
                    this.playSpitSound();
                }
                stack.func_190918_g(1);
            } else {
                for (i = 0; i < 4; ++i) {
                    d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
                }
            }
            return true;
        }
        return false;
    }

    public static class AIWanterTamedSpiritTreeFace
    extends EntityMovingWallFace.AIWander<EntityTamedSpiritTreeFace> {
        public AIWanterTamedSpiritTreeFace(EntityTamedSpiritTreeFace entity, double range, double speed) {
            super(entity, range, speed);
        }

        public AIWanterTamedSpiritTreeFace(EntityTamedSpiritTreeFace entity, double range, double speed, int chance) {
            super(entity, range, speed, chance);
        }

        @Override
        protected boolean canMove() {
            return ((EntityTamedSpiritTreeFace)this.entity).isActive() && !((EntityTamedSpiritTreeFace)this.entity).isAttacking();
        }
    }
}

