/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.base.Optional;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.ProtectionShield;
import thebetweenlands.api.entity.IBLBoss;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityMusic;
import thebetweenlands.client.audio.FortressBossIdleSound;
import thebetweenlands.common.entity.mobs.EntityFortressBossBlockade;
import thebetweenlands.common.entity.mobs.EntityFortressBossProjectile;
import thebetweenlands.common.entity.mobs.EntityFortressBossSpawner;
import thebetweenlands.common.entity.mobs.EntityFortressBossTurret;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.sound.BLSoundEvent;
import thebetweenlands.common.world.storage.location.EnumLocationType;
import thebetweenlands.common.world.storage.location.LocationStorage;
import thebetweenlands.util.RotationMatrix;

public class EntityFortressBoss
extends EntityMob
implements IEntityBL,
IBLBoss,
IEntityMusic {
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
    protected static final DataParameter<Integer> SHIELD_STATE = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> SHIELD_ROTATION = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> FLOATING_STATE = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> GROUND_ATTACK_STATE = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<BlockPos> ANCHOR = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187200_j);
    protected static final DataParameter<Float> ANCHOR_RADIUS = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntityFortressBoss.class, (DataSerializer)DataSerializers.field_187203_m);
    public static final double SHIELD_OFFSET_X = 0.0;
    public static final double SHIELD_OFFSET_Y = 1.0;
    public static final double SHIELD_OFFSET_Z = 0.0;
    private static final double ICOSAHEDRON_X = 0.5257311121191336;
    private static final double ICOSAHEDRON_Z = 0.8506508083520399;
    public static final double[][] ICOSAHEDRON_VERTICES = new double[][]{{-0.5257311121191336, 0.0, 0.8506508083520399}, {0.5257311121191336, 0.0, 0.8506508083520399}, {-0.5257311121191336, 0.0, -0.8506508083520399}, {0.5257311121191336, 0.0, -0.8506508083520399}, {0.0, 0.8506508083520399, 0.5257311121191336}, {0.0, 0.8506508083520399, -0.5257311121191336}, {0.0, -0.8506508083520399, 0.5257311121191336}, {0.0, -0.8506508083520399, -0.5257311121191336}, {0.8506508083520399, 0.5257311121191336, 0.0}, {-0.8506508083520399, 0.5257311121191336, 0.0}, {0.8506508083520399, -0.5257311121191336, 0.0}, {-0.8506508083520399, -0.5257311121191336, 0.0}};
    public static final int[][] ICOSAHEDRON_INDICES = new int[][]{{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1}, {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3}, {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6}, {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}};
    public final ProtectionShield shield = new ProtectionShield();
    public final AxisAlignedBB coreBoundingBox;
    private BlockPos anchor = BlockPos.field_177992_a;
    private double anchorRadius;
    private float shieldRotationYaw;
    private float shieldRotationPitch;
    private float shieldRotationRoll;
    private float lastShieldRotationYaw;
    private float lastShieldRotationPitch;
    private float lastShieldRotationRoll;
    private float shieldExplosion;
    private float lastShieldExplosion;
    private int groundTicks = 0;
    private int turretTicks = -1;
    private int groundAttackTicks = -1;
    private int turretStreak = -1;
    private int turretStreakTicks = 0;
    private int wightSpawnTicks = -1;
    private int teleportTicks = -1;
    private int blockadeSpawnTicks = -1;
    private int deathTicks = 0;
    private ISound currentIdleSound;
    private Object2IntMap<Entity> deflectionDamageCooldowns = new Object2IntOpenHashMap();

    public EntityFortressBoss(World world) {
        super(world);
        float width = 1.9f;
        float height = 1.9f;
        this.func_70105_a(width, height);
        float coreWidth = 1.0f;
        float coreHeight = 1.0f;
        this.coreBoundingBox = new AxisAlignedBB((double)(-coreWidth / 2.0f), (double)(0.0f + height / 4.0f), (double)(-coreWidth / 2.0f), (double)(coreWidth / 2.0f), (double)(coreHeight + height / 4.0f), (double)(coreWidth / 2.0f));
        for (int i = 0; i < 20; ++i) {
            this.shield.setActive(i, true);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(320.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SHIELD_STATE, (Object)0);
        this.func_184212_Q().func_187214_a(SHIELD_ROTATION, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(FLOATING_STATE, (Object)true);
        this.func_184212_Q().func_187214_a(GROUND_ATTACK_STATE, (Object)false);
        this.func_184212_Q().func_187214_a(ANCHOR, (Object)BlockPos.field_177992_a);
        this.func_184212_Q().func_187214_a(ANCHOR_RADIUS, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(BOSSINFO_ID, (Object)Optional.absent());
    }

    public float getShieldExplosion(float partialTicks) {
        return this.lastShieldExplosion + (this.shieldExplosion - this.lastShieldExplosion) * partialTicks;
    }

    public void setAnchor(BlockPos anchor, double radius) {
        this.anchor = anchor;
        this.anchorRadius = radius;
    }

    public Vec3d getAnchorCenter() {
        return new Vec3d((double)this.anchor.func_177958_n() + 0.5, (double)this.anchor.func_177956_o() + 0.5, (double)this.anchor.func_177952_p() + 0.5);
    }

    public double getAnchorRadius() {
        return this.anchorRadius;
    }

    public int getGroundAttackTicks() {
        return this.groundAttackTicks;
    }

    public float getShieldRotationYaw(float partialTicks) {
        return this.lastShieldRotationYaw + (this.shieldRotationYaw - this.lastShieldRotationYaw) * partialTicks;
    }

    public float getShieldRotationPitch(float partialTicks) {
        return this.lastShieldRotationPitch + (this.shieldRotationPitch - this.lastShieldRotationPitch) * partialTicks;
    }

    public float getShieldRotationRoll(float partialTicks) {
        return this.lastShieldRotationRoll + (this.shieldRotationRoll - this.lastShieldRotationRoll) * partialTicks;
    }

    public static int rayTraceShield(ProtectionShield shield, Vec3d centerPos, float shieldRotationYaw, float shieldRotationPitch, float shieldRotationRoll, float shieldExplosion, Vec3d pos, Vec3d ray, boolean back) {
        int shieldIndex = -1;
        double centroidX = 0.0;
        double centroidY = 0.0;
        double centroidZ = 0.0;
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.setRotations((float)Math.toRadians(-shieldRotationPitch), (float)Math.toRadians(-shieldRotationYaw), (float)Math.toRadians(-shieldRotationRoll));
        pos = rotationMatrix.transformVec(pos, centerPos);
        ray = rotationMatrix.transformVec(ray, new Vec3d(0.0, 0.0, 0.0));
        for (int i = 0; i <= 19; ++i) {
            if (!shield.isActive(i)) continue;
            double[] v3 = ICOSAHEDRON_VERTICES[ICOSAHEDRON_INDICES[i][0]];
            double[] v2 = ICOSAHEDRON_VERTICES[ICOSAHEDRON_INDICES[i][1]];
            double[] v1 = ICOSAHEDRON_VERTICES[ICOSAHEDRON_INDICES[i][2]];
            double centerX = (v1[0] + v2[0] + v3[0]) / 3.0;
            double centerY = (v1[1] + v2[1] + v3[1]) / 3.0;
            double centerZ = (v1[2] + v2[2] + v3[2]) / 3.0;
            double len = Math.sqrt(centerX * centerX + centerY * centerY + centerZ * centerZ);
            double a = len + (double)shieldExplosion;
            Vec3d center = new Vec3d(centerX, centerY, centerZ);
            centerX += centerPos.field_72450_a;
            centerY += centerPos.field_72448_b;
            centerZ += centerPos.field_72449_c;
            Vec3d vert1Exploded = new Vec3d(v1[0], v1[1], v1[2]);
            double b = vert1Exploded.func_72430_b(center);
            double d = a * Math.tan(b);
            double vertexExplode = Math.sqrt(a * a + d * d) - 1.0;
            Vec3d v1Normalized = new Vec3d(v1[0], v1[1], v1[2]).func_72432_b();
            Vec3d v2Normalized = new Vec3d(v2[0], v2[1], v2[2]).func_72432_b();
            Vec3d v3Normalized = new Vec3d(v3[0], v3[1], v3[2]).func_72432_b();
            Vec3d vert1 = new Vec3d(v1[0] + v1Normalized.field_72450_a * vertexExplode, v1[1] + v1Normalized.field_72448_b * vertexExplode, v1[2] + v1Normalized.field_72449_c * vertexExplode);
            Vec3d vert2 = new Vec3d(v2[0] + v2Normalized.field_72450_a * vertexExplode, v2[1] + v2Normalized.field_72448_b * vertexExplode, v2[2] + v2Normalized.field_72449_c * vertexExplode);
            Vec3d vert3 = new Vec3d(v3[0] + v3Normalized.field_72450_a * vertexExplode, v3[1] + v3Normalized.field_72448_b * vertexExplode, v3[2] + v3Normalized.field_72449_c * vertexExplode);
            vert1 = vert1.func_178787_e(centerPos);
            vert2 = vert2.func_178787_e(centerPos);
            vert3 = vert3.func_178787_e(centerPos);
            Vec3d normal = vert2.func_178788_d(vert1).func_72431_c(vert3.func_178788_d(vert1));
            if (!EntityFortressBoss.rayTraceTriangle(pos, ray, vert1, vert2, vert3) || !back && !(normal.func_72432_b().func_72430_b(ray.func_72432_b()) < Math.cos(Math.toRadians(90.0)))) continue;
            double dx = centerX - pos.field_72450_a;
            double dy = centerY - pos.field_72448_b;
            double dz = centerZ - pos.field_72449_c;
            double pdx = centroidX - pos.field_72450_a;
            double pdy = centroidY - pos.field_72448_b;
            double pdz = centroidZ - pos.field_72449_c;
            if (shieldIndex != -1 && !(Math.sqrt(dx * dx + dy * dy + dz * dz) < Math.sqrt(pdx * pdx + pdy * pdy + pdz * pdz))) continue;
            shieldIndex = i;
            centroidX = centerX;
            centroidY = centerY;
            centroidZ = centerZ;
        }
        return shieldIndex;
    }

    public static boolean rayTraceTriangle(Vec3d pos, Vec3d ray, Vec3d v0, Vec3d v1, Vec3d v2) {
        Vec3d diff2;
        Vec3d rayCross;
        double epsilon = 1.0E-5;
        Vec3d diff1 = v1.func_178788_d(v0);
        double angleDifference = diff1.func_72430_b(rayCross = ray.func_72431_c(diff2 = v2.func_178788_d(v0)));
        if (angleDifference > -1.0E-5 && angleDifference < 1.0E-5) {
            return false;
        }
        double f = 1.0 / angleDifference;
        Vec3d s = pos.func_178788_d(v0);
        double u = f * s.func_72430_b(rayCross);
        if (u < 0.0 || u > 1.0) {
            return false;
        }
        Vec3d q = s.func_72431_c(diff1);
        double v = f * ray.func_72430_b(q);
        if (v < 0.0 || u + v > 1.0) {
            return false;
        }
        double t = f * diff2.func_72430_b(q);
        return 1.0 - t > 1.0E-5;
    }

    public boolean isFloating() {
        return (Boolean)this.func_184212_Q().func_187225_a(FLOATING_STATE);
    }

    public void setFloating(boolean floating) {
        this.func_184212_Q().func_187227_b(FLOATING_STATE, (Object)floating);
    }

    public static AttackShieldResult attackShield(World world, ProtectionShield shield, Vec3d centerPos, float shieldRotationYaw, float shieldRotationPitch, float shieldRotationRoll, float shieldExplosion, Object2IntMap<Entity> deflectionDamageCooldowns, DamageSource source, boolean checkOnly) {
        if (source instanceof EntityDamageSource) {
            EntityDamageSource entityDamage = (EntityDamageSource)source;
            Entity sourceEntity = entityDamage.func_76346_g();
            Entity immediateEntity = entityDamage.func_76364_f();
            Entity attackingEntity = immediateEntity != null ? immediateEntity : sourceEntity;
            int shieldHit = -1;
            boolean isDeflected = false;
            Vec3d ray = null;
            Vec3d pos = null;
            if (attackingEntity == null) {
                isDeflected = true;
            } else {
                ray = attackingEntity instanceof EntityLivingBase ? attackingEntity.func_70040_Z() : new Vec3d(attackingEntity.field_70159_w, attackingEntity.field_70181_x, attackingEntity.field_70179_y).func_72432_b();
                ray = ray.func_186678_a(64.0);
                pos = new Vec3d(attackingEntity.field_70165_t, attackingEntity.field_70163_u + (double)attackingEntity.func_70047_e(), attackingEntity.field_70161_v);
                if ((shield.hasShield() && (!(attackingEntity instanceof EntityPlayer) || !((EntityPlayer)attackingEntity).field_71075_bZ.field_75098_d) || attackingEntity.func_70093_af()) && (shieldHit = EntityFortressBoss.rayTraceShield(shield, centerPos, shieldRotationYaw, shieldRotationPitch, shieldRotationRoll, shieldExplosion, pos, ray, false)) >= 0) {
                    if (!checkOnly) {
                        if (!world.field_72995_K && attackingEntity.func_70093_af() && ((EntityPlayer)attackingEntity).field_71075_bZ.field_75098_d) {
                            shield.setActive(shieldHit, false);
                        }
                        if (world.field_72995_K) {
                            shield.setAnimationTicks(shieldHit, 20);
                        }
                    }
                    isDeflected = true;
                }
            }
            if (isDeflected) {
                if (!checkOnly && !world.field_72995_K) {
                    double len;
                    double dz;
                    double dy;
                    double dx;
                    boolean damaged = false;
                    if (sourceEntity != null && !deflectionDamageCooldowns.containsKey((Object)sourceEntity)) {
                        dx = sourceEntity.field_70165_t - centerPos.field_72450_a;
                        dy = sourceEntity.field_70163_u - centerPos.field_72448_b;
                        dz = sourceEntity.field_70161_v - centerPos.field_72449_c;
                        len = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        sourceEntity.field_70159_w = dx / len * (double)0.8f;
                        sourceEntity.field_70181_x = dy / len * (double)0.8f;
                        sourceEntity.field_70179_y = dz / len * (double)0.8f;
                        sourceEntity.field_70160_al = true;
                        sourceEntity.field_70133_I = true;
                        sourceEntity.func_70097_a(DamageSource.field_76376_m, 2.0f);
                        deflectionDamageCooldowns.put((Object)sourceEntity, 10);
                        damaged = true;
                    }
                    if (immediateEntity != null && !deflectionDamageCooldowns.containsKey((Object)immediateEntity)) {
                        dx = immediateEntity.field_70165_t - centerPos.field_72450_a;
                        dy = immediateEntity.field_70163_u - centerPos.field_72448_b;
                        dz = immediateEntity.field_70161_v - centerPos.field_72449_c;
                        len = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        immediateEntity.field_70159_w = dx / len * (double)0.8f;
                        immediateEntity.field_70181_x = dy / len * (double)0.8f;
                        immediateEntity.field_70179_y = dz / len * (double)0.8f;
                        immediateEntity.field_70160_al = true;
                        immediateEntity.field_70133_I = true;
                        immediateEntity.func_70097_a(DamageSource.field_76376_m, 2.0f);
                        deflectionDamageCooldowns.put((Object)immediateEntity, 10);
                        damaged = true;
                    }
                    if (damaged) {
                        world.func_184148_a(null, centerPos.field_72450_a, centerPos.field_72448_b, centerPos.field_72449_c, (SoundEvent)SoundRegistry.FORTRESS_BOSS_NOPE, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    }
                }
                return new AttackShieldResult(true, shieldHit, pos, ray);
            }
            return new AttackShieldResult(false, shieldHit, pos, ray);
        }
        return new AttackShieldResult(true, -1, null, null);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!this.func_70089_S()) {
            return false;
        }
        if (source instanceof EntityDamageSource) {
            AttackShieldResult result = EntityFortressBoss.attackShield(this.field_70170_p, this.shield, new Vec3d(this.field_70165_t + 0.0, this.field_70163_u + 1.0, this.field_70161_v + 0.0), this.shieldRotationYaw, this.shieldRotationPitch, this.shieldRotationRoll, this.shieldExplosion, this.deflectionDamageCooldowns, source, false);
            if (!result.deflected) {
                if (result.pos != null && result.ray != null && this.coreBoundingBox.func_72317_d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72327_a(result.pos, result.ray.func_72441_c(result.pos.field_72450_a, result.pos.field_72448_b, result.pos.field_72449_c)) != null) {
                    return super.func_70097_a(source, damage);
                }
                return false;
            }
        }
        if (DamageSource.field_76380_i.func_76355_l().equals(source.func_76355_l())) {
            return super.func_70097_a(source, damage);
        }
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("shields", this.shield.packActiveData());
        nbt.func_74780_a("anchorX", (double)this.anchor.func_177958_n());
        nbt.func_74780_a("anchorY", (double)this.anchor.func_177956_o());
        nbt.func_74780_a("anchorZ", (double)this.anchor.func_177952_p());
        nbt.func_74780_a("anchorRadius", this.anchorRadius);
        nbt.func_74757_a("floating", this.isFloating());
        nbt.func_74768_a("groundTicks", this.groundTicks);
        nbt.func_74768_a("turretTicks", this.turretTicks);
        nbt.func_74768_a("groundAttackTicks", this.groundAttackTicks);
        nbt.func_74768_a("turretStreak", this.turretStreak);
        nbt.func_74768_a("turretStreakTicks", this.turretStreakTicks);
        nbt.func_74768_a("wightSpawnTicks", this.wightSpawnTicks);
        nbt.func_74768_a("teleportTicks", this.teleportTicks);
        nbt.func_74768_a("blockadeSpawnTicks", this.blockadeSpawnTicks);
        nbt.func_74768_a("deathTicks", this.deathTicks);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_150297_b("shields", 3)) {
            this.shield.unpackActiveData(nbt.func_74762_e("shields"));
        }
        this.anchor = new BlockPos(nbt.func_74769_h("anchorX"), nbt.func_74769_h("anchorY"), nbt.func_74769_h("anchorZ"));
        this.anchorRadius = nbt.func_74769_h("anchorRadius");
        this.setFloating(nbt.func_74767_n("floating"));
        this.groundTicks = nbt.func_74762_e("groundTicks");
        this.turretTicks = nbt.func_74762_e("turretTicks");
        this.groundAttackTicks = nbt.func_74762_e("groundAttackTicks");
        this.turretStreak = nbt.func_74762_e("turretStreak");
        this.turretStreakTicks = nbt.func_74762_e("turretStreakTicks");
        this.wightSpawnTicks = nbt.func_74762_e("wightSpawnTicks");
        this.teleportTicks = nbt.func_74762_e("teleportTicks");
        this.blockadeSpawnTicks = nbt.func_74762_e("blockadeSpawnTicks");
        this.deathTicks = nbt.func_74762_e("deathTicks");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        this.anchor = this.func_180425_c();
        this.anchorRadius = 10.0;
        return livingdata;
    }

    public void func_70653_a(Entity entity, float dmg, double x, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.field_70170_p.field_72995_K && this.func_70089_S()) {
            this.updateAmbientSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateAmbientSounds() {
        if (this.currentIdleSound != null && !Minecraft.func_71410_x().func_147118_V().func_147692_c(this.currentIdleSound)) {
            this.currentIdleSound = null;
        }
        if (this.currentIdleSound == null) {
            this.currentIdleSound = new FortressBossIdleSound(this);
            Minecraft.func_71410_x().func_147118_V().func_147682_a(this.currentIdleSound);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BOSSINFO_ID, (Object)Optional.of((Object)this.bossInfo.func_186737_d()));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ObjectIterator cooldownIt = this.deflectionDamageCooldowns.object2IntEntrySet().iterator();
        while (cooldownIt.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)cooldownIt.next();
            if (entry.getIntValue() > 0) {
                this.deflectionDamageCooldowns.put(entry.getKey(), entry.getIntValue() - 1);
                continue;
            }
            cooldownIt.remove();
        }
        EntityPlayer closestPlayer = this.field_70170_p.func_184142_a((Entity)this, 32.0, 16.0);
        if (closestPlayer != null) {
            this.func_70625_a((Entity)closestPlayer, 360.0f, 360.0f);
            this.func_70624_b((EntityLivingBase)closestPlayer);
        }
        this.lastShieldRotationYaw = this.shieldRotationYaw;
        this.lastShieldRotationPitch = this.shieldRotationPitch;
        this.lastShieldRotationRoll = this.shieldRotationRoll;
        this.lastShieldExplosion = this.shieldExplosion;
        this.shieldExplosion = this.func_70089_S() ? 0.2f : 0.2f + (float)(this.deathTicks % 16) / 16.0f * ((float)this.deathTicks / 60.0f);
        float shieldRotation = 0.0f;
        if (this.field_70170_p.field_72995_K) {
            shieldRotation = ((Float)this.func_184212_Q().func_187225_a(SHIELD_ROTATION)).floatValue();
            this.anchor = (BlockPos)this.func_184212_Q().func_187225_a(ANCHOR);
            this.anchorRadius = ((Float)this.func_184212_Q().func_187225_a(ANCHOR_RADIUS)).floatValue();
            this.shield.unpackActiveData((Integer)this.func_184212_Q().func_187225_a(SHIELD_STATE));
        } else {
            if (this.func_70089_S()) {
                shieldRotation = this.field_70173_aa;
                this.func_184212_Q().func_187227_b(SHIELD_ROTATION, (Object)Float.valueOf(shieldRotation + 1.0f));
            }
            this.func_184212_Q().func_187227_b(ANCHOR, (Object)this.anchor);
            this.func_184212_Q().func_187227_b(ANCHOR_RADIUS, (Object)Float.valueOf((float)this.anchorRadius));
        }
        int activeShields = 0;
        for (int i = 0; i <= 19; ++i) {
            if (!this.shield.isActive(i)) continue;
            ++activeShields;
        }
        if (this.func_70089_S()) {
            this.shieldRotationYaw = shieldRotation * (1.0f + 0.3f * (float)(20 - activeShields));
            this.shieldRotationPitch = shieldRotation * (1.4f + 0.4f * (float)(20 - activeShields));
            this.shieldRotationRoll = shieldRotation * (1.6f + 0.5f * (float)(20 - activeShields));
        } else {
            this.shieldRotationYaw = shieldRotation * 2.0f;
            this.shieldRotationPitch = 0.0f;
            this.shieldRotationRoll = 0.0f;
        }
        if (this.func_70089_S()) {
            AxisAlignedBB checkArea;
            List players;
            Vec3d anchorCenter = this.getAnchorCenter();
            if (!this.field_70170_p.field_72995_K) {
                if (this.isFloating() && this.field_70163_u < anchorCenter.field_72448_b) {
                    this.field_70181_x = 0.1f;
                } else if (!this.isFloating()) {
                    this.field_70181_x += (double)-0.1f;
                    ++this.groundTicks;
                    if (this.groundTicks > 180 && this.groundAttackTicks > 20) {
                        this.groundTicks = 0;
                        this.setFloating(true);
                    }
                }
                if (this.isFloating() && (this.func_70011_f(anchorCenter.field_72450_a, this.field_70163_u, anchorCenter.field_72449_c) > this.anchorRadius || Math.abs(this.field_70163_u - anchorCenter.field_72448_b) > this.anchorRadius)) {
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_TELEPORT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    this.func_70107_b(anchorCenter.field_72450_a, anchorCenter.field_72448_b, anchorCenter.field_72449_c);
                }
                if (this.field_70173_aa % 12 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                    List currentlyTrackedEntities = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(this.anchorRadius * 2.0, this.anchorRadius * 2.0, this.anchorRadius * 2.0));
                    Iterator it = currentlyTrackedEntities.iterator();
                    while (it.hasNext()) {
                        EntityLivingBase living = (EntityLivingBase)it.next();
                        if (!(living.func_70011_f(anchorCenter.field_72450_a, living.field_70163_u, anchorCenter.field_72449_c) > this.anchorRadius + 4.0) && !(Math.abs(living.field_70163_u - anchorCenter.field_72448_b) > this.anchorRadius)) continue;
                        it.remove();
                    }
                    if (currentlyTrackedEntities.isEmpty()) {
                        this.func_70691_i(1.0f);
                    }
                }
            }
            if (!(players = this.field_70170_p.func_72872_a(EntityPlayer.class, checkArea = this.func_174813_aQ().func_72314_b(32.0, 16.0, 32.0))).isEmpty()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_184212_Q().func_187227_b(SHIELD_STATE, (Object)this.shield.packActiveData());
                    if (this.isFloating() && this.field_70163_u >= anchorCenter.field_72448_b) {
                        List blockades;
                        AxisAlignedBB checkAABB = this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0);
                        List wights = this.field_70170_p.func_72872_a(EntityWight.class, checkAABB);
                        List spawners = this.field_70170_p.func_72872_a(EntityFortressBossSpawner.class, checkAABB);
                        if (wights.isEmpty() && spawners.isEmpty()) {
                            --this.wightSpawnTicks;
                            if (this.wightSpawnTicks <= 0) {
                                int spawnY;
                                if (this.wightSpawnTicks == 0 && Math.abs((double)(spawnY = this.field_70170_p.func_175645_m(this.func_180425_c()).func_177956_o()) - this.field_70163_u) < this.anchorRadius) {
                                    EntityFortressBossSpawner spawner = new EntityFortressBossSpawner(this.field_70170_p, (Entity)this);
                                    spawner.func_70012_b(MathHelper.func_76128_c((double)this.field_70165_t), spawnY, MathHelper.func_76128_c((double)this.field_70161_v), 0.0f, 0.0f);
                                    spawner.setOwner((Entity)this);
                                    this.field_70170_p.func_72838_d((Entity)spawner);
                                }
                                this.wightSpawnTicks = 160 + this.field_70170_p.field_73012_v.nextInt(200);
                            }
                        }
                        if ((blockades = this.field_70170_p.func_72872_a(EntityFortressBossBlockade.class, checkAABB)).isEmpty()) {
                            --this.blockadeSpawnTicks;
                            if (this.blockadeSpawnTicks <= 0) {
                                int spawnY;
                                if (this.blockadeSpawnTicks == 0 && Math.abs((double)(spawnY = this.field_70170_p.func_175645_m(this.func_180425_c()).func_177956_o()) - this.field_70163_u) < this.anchorRadius) {
                                    EntityFortressBossBlockade blockade = new EntityFortressBossBlockade(this.field_70170_p, (Entity)this);
                                    blockade.func_70012_b(this.field_70165_t, spawnY, this.field_70161_v, 0.0f, 0.0f);
                                    blockade.setTriangleSize(1.2f + this.field_70170_p.field_73012_v.nextFloat() * 1.6f);
                                    blockade.setOwner((Entity)this);
                                    blockade.setMaxDespawnTicks(400);
                                    this.field_70170_p.func_72838_d((Entity)blockade);
                                }
                                this.blockadeSpawnTicks = 190 + this.field_70170_p.field_73012_v.nextInt(160);
                            }
                        }
                        --this.teleportTicks;
                        if (this.teleportTicks <= 0) {
                            if (this.teleportTicks == 0) {
                                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_TELEPORT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                                this.func_70012_b(anchorCenter.field_72450_a + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f) * (this.anchorRadius - 1.0), anchorCenter.field_72448_b, anchorCenter.field_72449_c + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 2.0f) * (this.anchorRadius - 1.0), 0.0f, 0.0f);
                            }
                            this.teleportTicks = 140 + this.field_70170_p.field_73012_v.nextInt(200);
                        }
                        if (this.turretStreak <= 0 && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                            if (this.turretStreak == 0) {
                                EntityFortressBossTurret turret;
                                Vec3d dir;
                                ++this.turretStreakTicks;
                                int turretFrequency = MathHelper.func_76128_c((double)(15.0 - 0.04666666666666667 * (double)this.turretStreakTicks));
                                if (this.turretStreakTicks % turretFrequency == 0) {
                                    double angle = 0.041887902047863905 * (double)this.turretStreakTicks;
                                    for (int d = 0; d < 2; ++d) {
                                        dir = new Vec3d(Math.sin(angle) * (double)(d == 0 ? 1 : -1), 0.0, Math.cos(angle) * (double)(d == 0 ? 1 : -1));
                                        dir = dir.func_72432_b().func_186678_a(this.anchorRadius);
                                        turret = new EntityFortressBossTurret(this.field_70170_p, (Entity)this);
                                        turret.func_70012_b(anchorCenter.field_72450_a + dir.field_72450_a, anchorCenter.field_72448_b + dir.field_72448_b, anchorCenter.field_72449_c + dir.field_72449_c, 0.0f, 0.0f);
                                        turret.setAttackDelay(turretFrequency);
                                        this.field_70170_p.func_72838_d((Entity)turret);
                                        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_SUMMON_PROJECTILES, SoundCategory.HOSTILE, 0.25f, 0.3f + 0.0023333333f * (float)this.turretStreakTicks);
                                    }
                                }
                                if (this.turretStreakTicks >= 300) {
                                    double angle = 0.19634954084936207;
                                    for (int i = 0; i < 32; ++i) {
                                        dir = new Vec3d(Math.sin(angle * (double)i), 0.0, Math.cos(angle * (double)i));
                                        dir = dir.func_72432_b().func_186678_a(this.anchorRadius);
                                        turret = new EntityFortressBossTurret(this.field_70170_p, (Entity)this);
                                        turret.func_70012_b(anchorCenter.field_72450_a + dir.field_72450_a, anchorCenter.field_72448_b + dir.field_72448_b, anchorCenter.field_72449_c + dir.field_72449_c, 0.0f, 0.0f);
                                        turret.setAttackDelay(5 + i / 3);
                                        this.field_70170_p.func_72838_d((Entity)turret);
                                    }
                                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_SUMMON_PROJECTILES, SoundCategory.HOSTILE, 1.0f, 1.0f);
                                    this.turretStreakTicks = 0;
                                    this.turretStreak = -1;
                                }
                            }
                            if (this.turretStreak < 0) {
                                this.turretStreak = 250 + this.field_70170_p.field_73012_v.nextInt(200);
                                this.turretStreakTicks = 0;
                            }
                        } else if (this.turretTicks <= 0) {
                            if (this.turretTicks == 0) {
                                double angle = 0.6981317007977318;
                                for (int i = 0; i < 9; ++i) {
                                    if (this.field_70170_p.field_73012_v.nextInt(3) != 0) continue;
                                    Vec3d dir = new Vec3d(Math.sin(angle * (double)i), 0.0, Math.cos(angle * (double)i));
                                    dir = dir.func_72432_b().func_186678_a(8.0);
                                    EntityFortressBossTurret turret = new EntityFortressBossTurret(this.field_70170_p, (Entity)this);
                                    turret.func_70012_b(anchorCenter.field_72450_a + dir.field_72450_a, anchorCenter.field_72448_b + dir.field_72448_b, anchorCenter.field_72449_c + dir.field_72449_c, 0.0f, 0.0f);
                                    turret.setDeflectable(this.field_70170_p.field_73012_v.nextInt(2) != 0);
                                    this.field_70170_p.func_72838_d((Entity)turret);
                                }
                                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FORTRESS_BOSS_SUMMON_PROJECTILES, SoundCategory.HOSTILE, 1.0f, 1.0f);
                            }
                            this.turretTicks = 100 + this.field_70170_p.field_73012_v.nextInt(200);
                        } else {
                            --this.turretTicks;
                            if (this.turretStreak > 0) {
                                --this.turretStreak;
                            }
                        }
                    }
                    if (!this.isFloating() && this.field_70122_E) {
                        if (this.groundAttackTicks <= 0) {
                            if (this.groundAttackTicks == 0) {
                                double angle = 0.19634954084936207;
                                for (int i = 0; i < 32; ++i) {
                                    Vec3d dir = new Vec3d(Math.sin(angle * (double)i), 0.0, Math.cos(angle * (double)i));
                                    dir = dir.func_72432_b();
                                    float speed = 0.8f;
                                    EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, (Entity)this);
                                    bullet.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0f, 0.0f);
                                    bullet.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, speed, 0.0f);
                                    this.field_70170_p.func_72838_d((Entity)bullet);
                                }
                            }
                            this.groundAttackTicks = 40 + this.field_70170_p.field_73012_v.nextInt(80);
                            this.func_184212_Q().func_187227_b(GROUND_ATTACK_STATE, (Object)false);
                            this.turretStreak = -1;
                            this.turretTicks = -1;
                        } else {
                            --this.groundAttackTicks;
                            if (this.groundAttackTicks <= 20) {
                                this.func_184212_Q().func_187227_b(GROUND_ATTACK_STATE, (Object)true);
                            }
                        }
                    } else {
                        this.func_184212_Q().func_187227_b(GROUND_ATTACK_STATE, (Object)false);
                    }
                } else {
                    for (int i = 0; i <= 19; ++i) {
                        if (this.shield.getAnimationTicks(i) == 0 && this.field_70170_p.field_73012_v.nextInt(50) == 0) {
                            this.shield.setAnimationTicks(i, 40);
                        }
                        if (this.shield.getAnimationTicks(i) <= 0) continue;
                        this.shield.setAnimationTicks(i, this.shield.getAnimationTicks(i) - 1);
                        if (this.shield.getAnimationTicks(i) != 20) continue;
                        this.shield.setAnimationTicks(i, 0);
                    }
                    if (((Boolean)this.func_184212_Q().func_187225_a(GROUND_ATTACK_STATE)).booleanValue()) {
                        if (this.groundAttackTicks < 20) {
                            ++this.groundAttackTicks;
                        }
                    } else {
                        this.groundAttackTicks = 0;
                    }
                }
            }
        } else {
            this.setFloating(true);
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.isFloating()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.02f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.8f;
                this.field_70181_x *= (double)0.8f;
                this.field_70179_y *= (double)0.8f;
            } else {
                float friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                float groundFriction = 0.16277136f / (friction * friction * friction);
                this.func_191958_b(strafe, up, forward, this.field_70122_E ? 0.1f * groundFriction : 0.02f);
                friction = 0.91f;
                if (this.field_70122_E) {
                    friction = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.91f;
                }
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)friction;
                this.field_70181_x *= (double)friction;
                this.field_70179_y *= (double)friction;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double dx = this.field_70165_t - this.field_70169_q;
            double dz = this.field_70161_v - this.field_70166_s;
            float distanceMoved = MathHelper.func_76133_a((double)(dx * dx + dz * dz)) * 4.0f;
            if (distanceMoved > 1.0f) {
                distanceMoved = 1.0f;
            }
            this.field_70721_aZ += (distanceMoved - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.func_70637_d(false);
            super.func_191986_a(0.0f, 0.0f, 0.0f);
        }
    }

    protected void func_70609_aI() {
        this.bossInfo.func_186735_a(0.0f);
        if (this.deathTicks == 0 && !this.field_70170_p.field_72995_K) {
            Vec3d anchorCenter = this.getAnchorCenter();
            this.field_70170_p.func_184148_a(null, anchorCenter.field_72450_a, anchorCenter.field_72448_b, anchorCenter.field_72449_c, (SoundEvent)SoundRegistry.FORTRESS_BOSS_TELEPORT, SoundCategory.HOSTILE, 1.0f, 1.0f);
            this.func_70107_b(anchorCenter.field_72450_a, anchorCenter.field_72448_b, anchorCenter.field_72449_c);
            List trackedEntities = this.field_70170_p.func_72872_a(EntityWight.class, this.func_174813_aQ().func_72314_b(this.anchorRadius * 2.0, 512.0, this.anchorRadius * 2.0));
            Iterator it = trackedEntities.iterator();
            while (it.hasNext()) {
                Entity entity = (Entity)it.next();
                if (!(entity.func_70011_f(anchorCenter.field_72450_a, entity.field_70163_u, anchorCenter.field_72449_c) > this.anchorRadius) && !(Math.abs(entity.field_70163_u - anchorCenter.field_72448_b) > this.anchorRadius)) continue;
                it.remove();
            }
            for (Entity entity : trackedEntities) {
                if (!(entity instanceof EntityWight) && !(entity instanceof EntityFortressBossSpawner) && !(entity instanceof EntityFortressBossProjectile) && !(entity instanceof EntityFortressBossTurret) && !(entity instanceof EntityFortressBossBlockade)) continue;
                entity.func_70106_y();
            }
        }
        ++this.deathTicks;
        this.func_184212_Q().func_187227_b(SHIELD_ROTATION, (Object)Float.valueOf((float)this.deathTicks / 3.0f * ((float)this.deathTicks / 3.0f)));
        for (int i = 0; i <= 19; ++i) {
            this.shield.setActive(i, (float)i * 6.8421054f > (float)this.deathTicks);
        }
        this.func_184212_Q().func_187227_b(SHIELD_STATE, (Object)this.shield.packActiveData());
        if (!this.field_70170_p.field_72995_K) {
            int xp;
            if (this.deathTicks > 100 && this.deathTicks % 5 == 0) {
                int dropXP;
                for (xp = 800; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
            }
            if (this.deathTicks > 130) {
                int dropXP;
                for (xp = 3000; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, dropXP));
                }
                for (int c = 0; c < 4; ++c) {
                    double yawAngle = 1.0471975511965976;
                    for (int i = 0; i < 6; ++i) {
                        Vec3d dir = new Vec3d(Math.sin(yawAngle * (double)i), (double)(c - 2) / 4.0 * 2.0, Math.cos(yawAngle * (double)i));
                        dir = dir.func_72432_b();
                        float speed = 0.8f;
                        EntityFortressBossProjectile bullet = new EntityFortressBossProjectile(this.field_70170_p, (Entity)this);
                        bullet.func_70012_b(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0f, 0.0f);
                        bullet.func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, speed, 0.0f);
                        this.field_70170_p.func_72838_d((Entity)bullet);
                    }
                }
                List<LocationStorage> locations = LocationStorage.getLocations(this.field_70170_p, this.func_174791_d());
                for (LocationStorage location : locations) {
                    if (location.getType() != EnumLocationType.WIGHT_TOWER || location.getGuard() == null) continue;
                    location.getGuard().clear(this.field_70170_p);
                    location.setDirty(true);
                }
                this.func_70106_y();
            }
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.FORTRESS_BOSS;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.FORTRESS_BOSS_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.FORTRESS_BOSS_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FORTRESS_BOSS_DEATH;
    }

    public void func_70642_aH() {
        if (this.field_70170_p.field_72995_K || !this.func_174814_R()) {
            // empty if block
        }
    }

    @Override
    public BLSoundEvent getMusicFile(EntityPlayer listener) {
        return SoundRegistry.FORTRESS_BOSS_LOOP;
    }

    @Override
    public double getMusicRange(EntityPlayer listener) {
        return 20.0;
    }

    @Override
    public boolean isMusicActive(EntityPlayer listener) {
        return this.func_70089_S();
    }

    @Override
    public int getMusicLayer(EntityPlayer listener) {
        return 1;
    }

    @Override
    public UUID getBossInfoUuid() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(BOSSINFO_ID)).or((Object)new UUID(0L, 0L));
    }

    public static class AttackShieldResult {
        public final boolean deflected;
        public final int shieldHit;
        @Nullable
        public final Vec3d pos;
        @Nullable
        public final Vec3d ray;

        public AttackShieldResult(boolean deflected, int shieldHit, Vec3d pos, Vec3d ray) {
            this.deflected = deflected;
            this.shieldHit = shieldHit;
            this.pos = pos;
            this.ray = ray;
        }
    }
}

