/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.portal;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import thebetweenlands.api.capability.IPortalCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class PortalEntityCapability
extends EntityCapability<PortalEntityCapability, IPortalCapability, EntityPlayer>
implements IPortalCapability,
ISerializableCapability {
    private boolean inPortal = false;
    private boolean wasTeleported = false;
    private int ticksUntilTeleport = 0;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "portal");
    }

    @Override
    protected Capability<IPortalCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_PORTAL;
    }

    @Override
    protected Class<IPortalCapability> getCapabilityClass() {
        return IPortalCapability.class;
    }

    @Override
    protected PortalEntityCapability getDefaultCapabilityImplementation() {
        return new PortalEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("inPortal", this.inPortal);
        nbt.func_74768_a("ticks", this.ticksUntilTeleport);
        nbt.func_74757_a("wasTeleported", this.wasTeleported);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.inPortal = nbt.func_74767_n("inPortal");
        this.ticksUntilTeleport = nbt.func_74762_e("ticks");
        this.wasTeleported = nbt.func_74767_n("wasTeleported");
    }

    @Override
    public boolean isInPortal() {
        return this.inPortal;
    }

    @Override
    public void setInPortal(boolean inPortal) {
        this.inPortal = inPortal;
    }

    @Override
    public int getTicksUntilTeleport() {
        return this.ticksUntilTeleport;
    }

    @Override
    public void setTicksUntilTeleport(int ticks) {
        this.ticksUntilTeleport = ticks;
    }

    @Override
    public boolean wasTeleported() {
        return this.wasTeleported;
    }

    @Override
    public void setWasTeleported(boolean wasTeleported) {
        this.wasTeleported = wasTeleported;
    }
}

