/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public abstract class BlockSpreadingDeath
extends Block {
    public static final PropertyBool INACTIVE = PropertyBool.func_177716_a((String)"inactive");

    public BlockSpreadingDeath(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)INACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INACTIVE});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INACTIVE) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)INACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            this.checkAndRevertBiome(worldIn, pos);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        int spreadTime = this.getScheduledSpreadTime(worldIn, pos, state);
        if (spreadTime > 0) {
            worldIn.func_175684_a(pos, (Block)this, spreadTime);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (!((Boolean)state.func_177229_b((IProperty)INACTIVE)).booleanValue() && this.shouldSpread(world, pos, state)) {
                int spreadTime;
                IBlockState offsetState;
                BlockPos target;
                int i;
                boolean spread = false;
                for (i = 0; i < 16; ++i) {
                    target = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(3) - 1, rand.nextInt(3) - 1);
                    if (!world.func_175667_e(target) || (offsetState = world.func_180495_p(target)).func_177230_c() == this || !this.canSpreadInto(world, pos, state, target, offsetState)) continue;
                    this.spreadInto(world, pos, state, target, offsetState);
                    if (this.getSpreadingBiome() != null) {
                        this.convertBiome(world, target, this.getSpreadingBiome());
                    }
                    spread = true;
                }
                if (!spread) {
                    for (i = 0; i < 16; ++i) {
                        target = pos.func_177982_a(rand.nextInt(5) - 2, rand.nextInt(5) - 2, rand.nextInt(5) - 2);
                        if (!world.func_175667_e(target) || (offsetState = world.func_180495_p(target)).func_177230_c() == this || !this.canSpreadInto(world, pos, state, target, offsetState)) continue;
                        this.spreadInto(world, pos, state, target, offsetState);
                        if (this.getSpreadingBiome() != null) {
                            this.convertBiome(world, target, this.getSpreadingBiome());
                        }
                        spread = true;
                    }
                }
                if ((spreadTime = this.getScheduledSpreadTime(world, pos, state)) > 0) {
                    world.func_175684_a(pos, (Block)this, spreadTime);
                }
            }
            if (world.field_73012_v.nextInt(6) == 0) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)INACTIVE, (Comparable)Boolean.valueOf(true)));
            }
            if (this.getSpreadingBiome() != null && rand.nextInt(3) == 0 && world.getBiomeForCoordsBody(pos) != this.getSpreadingBiome()) {
                this.convertBiome(world, pos, this.getSpreadingBiome());
            }
        }
    }

    protected boolean shouldSpread(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    public boolean canSpreadInto(World world, BlockPos pos, IBlockState state, BlockPos offsetPos, IBlockState offsetState) {
        IBlockState offsetStateUp = world.func_180495_p(offsetPos.func_177984_a());
        return offsetStateUp.func_177230_c() != this && !offsetStateUp.func_185915_l() && (this.getPreviousBiome() == null || world.getBiomeForCoordsBody(offsetPos) == this.getPreviousBiome());
    }

    public abstract void spreadInto(World var1, BlockPos var2, IBlockState var3, BlockPos var4, IBlockState var5);

    protected int getScheduledSpreadTime(World world, BlockPos pos, IBlockState state) {
        return -1;
    }

    @Nullable
    public Biome getSpreadingBiome() {
        return null;
    }

    @Nullable
    public Biome getPreviousBiome() {
        return null;
    }

    protected void checkAndRevertBiome(World world, BlockPos pos) {
        if (this.getPreviousBiome() != null && this.getSpreadingBiome() != null && world.getBiomeForCoordsBody(pos) == this.getSpreadingBiome()) {
            this.convertBiome(world, pos, this.getPreviousBiome());
        }
    }

    protected void convertBiome(World world, BlockPos pos, Biome biome) {
        Chunk chunk = world.func_175726_f(pos);
        byte[] biomes = (byte[])chunk.func_76605_m().clone();
        int index = (pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF;
        biomes[index] = (byte)(Biome.func_185362_a((Biome)biome) & 0xFF);
        chunk.func_76616_a(biomes);
        chunk.func_76630_e();
    }
}

