/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.plant;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.BlockStateContainerHelper;
import thebetweenlands.common.block.SoilHelper;
import thebetweenlands.common.block.plant.BlockPlantUnderwater;
import thebetweenlands.common.block.plant.BlockStackablePlant;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockStackablePlantUnderwater
extends BlockPlantUnderwater {
    protected static final AxisAlignedBB STACKABLE_PLANT_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);
    public static final PropertyBool IS_TOP = BlockStackablePlant.IS_TOP;
    public static final PropertyBool IS_BOTTOM = BlockStackablePlant.IS_BOTTOM;
    public static final PropertyInteger AGE = BlockStackablePlant.AGE;
    protected int maxHeight = -1;
    protected boolean harvestAll = false;
    protected boolean resetAge = true;
    protected final ThreadLocal<Boolean> harvesting = new ThreadLocal();

    public BlockStackablePlantUnderwater() {
        this(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
    }

    public BlockStackablePlantUnderwater(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STACKABLE_PLANT_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return BlockStateContainerHelper.extendBlockstateContainer((ExtendedBlockState)super.func_180661_e(), new IProperty[]{AGE, IS_TOP, IS_BOTTOM}, new IUnlistedProperty[0]);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean isTop = !this.isSamePlant(worldIn.func_180495_p(pos.func_177984_a()));
        boolean isBottom = !this.isSamePlant(worldIn.func_180495_p(pos.func_177977_b()));
        return state.func_177226_a((IProperty)IS_TOP, (Comparable)Boolean.valueOf(isTop)).func_177226_a((IProperty)IS_BOTTOM, (Comparable)Boolean.valueOf(isBottom));
    }

    @Override
    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176208_a(world, pos, state, player);
        boolean removed = false;
        Boolean harvesting = this.harvesting.get();
        if (harvesting == null || !harvesting.booleanValue()) {
            this.harvesting.set(true);
            int height = 1;
            while (this.isSamePlant(world.func_180495_p(pos.func_177981_b(height)))) {
                ++height;
            }
            for (int offset = height - 1; this.harvestAll && this.isSamePlant(world.func_180495_p(pos.func_177981_b(offset))) || !this.harvestAll && offset >= 0; --offset) {
                if (offset != 0) {
                    BlockPos offsetPos = pos.func_177981_b(offset);
                    IBlockState blockState = world.func_180495_p(offsetPos);
                    boolean canHarvest = player.func_184812_l_() ? false : blockState.func_177230_c().canHarvestBlock((IBlockAccess)world, offsetPos, player);
                    boolean otherRemoved = this.removeOtherBlockAsPlayer(world, offsetPos, player, canHarvest);
                    if (!otherRemoved || !canHarvest) continue;
                    ItemStack stack = player.func_184614_ca() == null ? null : player.func_184614_ca().func_77946_l();
                    blockState.func_177230_c().func_180657_a(world, player, offsetPos, blockState, world.func_175625_s(offsetPos), stack);
                    continue;
                }
                removed = this.removePlant(world, pos, null, false);
            }
            this.harvesting.set(false);
        }
        if (removed) {
            return true;
        }
        return this.removePlant(world, pos, player, willHarvest);
    }

    protected boolean removeOtherBlockAsPlayer(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        IBlockState blockState = world.func_180495_p(pos);
        boolean removed = blockState.func_177230_c().removedByPlayer(blockState, world, pos, player, canHarvest);
        if (removed) {
            blockState.func_177230_c().func_176206_d(world, pos, blockState);
        }
        return removed;
    }

    protected boolean isSamePlant(IBlockState blockState) {
        return blockState.func_177230_c() == this;
    }

    public BlockStackablePlantUnderwater setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180645_a(worldIn, pos, state, rand);
        this.checkAndDropBlock(worldIn, pos, state);
        if (this.canGrow(worldIn, pos, state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextFloat() <= this.getGrowthChance(worldIn, pos, state, rand) ? 1 : 0) != 0)) {
            int currentAge = (Integer)state.func_177229_b((IProperty)AGE);
            if (currentAge >= 15) {
                int height = 1;
                while (this.isSamePlant(worldIn.func_180495_p(pos.func_177979_c(height)))) {
                    ++height;
                }
                if (this.canGrowUp(worldIn, pos, state, height)) {
                    this.growUp(worldIn, pos);
                }
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(this.resetAge ? 0 : 15)));
            } else {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(currentAge + 1)));
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    protected float getGrowthChance(World world, BlockPos pos, IBlockState state, Random rand) {
        return 0.5f;
    }

    protected boolean canGrow(World world, BlockPos pos, IBlockState state) {
        return true;
    }

    protected boolean canGrowUp(World world, BlockPos pos, IBlockState state, int height) {
        return world.func_180495_p(pos.func_177984_a()) != this && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h && (this.maxHeight == -1 || height < this.maxHeight);
    }

    protected void growUp(World world, BlockPos pos) {
        world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        int height = 1;
        while (this.isSamePlant(worldIn.func_180495_p(pos.func_177979_c(height)))) {
            ++height;
        }
        return super.func_176196_c(worldIn, pos) && (this.maxHeight == -1 || height - 1 < this.maxHeight);
    }

    @Override
    protected boolean canSustainPlant(IBlockState state) {
        return (this.maxHeight == -1 || this.maxHeight > 1) && this.isSamePlant(state) || SoilHelper.canSustainUnderwaterPlant(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{AGE});
        if (this.maxHeight == 1) {
            builder.ignore(new IProperty[]{IS_TOP, IS_BOTTOM});
        }
    }

    @Override
    public boolean isFarmable(World world, BlockPos pos, IBlockState state) {
        return false;
    }
}

