/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.advancments;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import thebetweenlands.common.advancments.BLTrigger;
import thebetweenlands.common.advancments.BlockPredicate;

public class BreakBlockTrigger
extends BLTrigger<Instance, Listener> {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "break_block");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    @Override
    public Listener createListener(PlayerAdvancements playerAdvancements) {
        return new Listener(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        BlockPredicate[] blockPredicates = BlockPredicate.deserializeArray((JsonElement)json.getAsJsonArray("blocks"));
        LocationPredicate locationpredicate = LocationPredicate.func_193454_a((JsonElement)json.get("location"));
        return new Instance(blockPredicates, locationpredicate);
    }

    public void trigger(EntityPlayerMP player, BlockPos pos, IBlockState state) {
        Listener listeners = (Listener)this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(state, pos, player.func_71121_q());
        }
    }

    static class Listener
    extends BLTrigger.Listener<Instance> {
        public Listener(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        public void trigger(IBlockState state, BlockPos pos, WorldServer world) {
            ArrayList<ICriterionTrigger.Listener> list = new ArrayList<ICriterionTrigger.Listener>();
            for (ICriterionTrigger.Listener listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(state, pos, world)) continue;
                list.add(listener);
                break;
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final BlockPredicate[] blocks;
        private final LocationPredicate location;

        public Instance(BlockPredicate[] blocks, LocationPredicate location) {
            super(ID);
            this.blocks = blocks;
            this.location = location;
        }

        public boolean test(IBlockState state, BlockPos pos, WorldServer world) {
            ArrayList list = Lists.newArrayList((Object[])this.blocks);
            int amount = list.size();
            list.removeIf(predicate -> predicate.test(state));
            return amount > list.size() && this.location.func_193453_a(world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
    }
}

