/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BLDataFixers {
    private BLDataFixers() {
    }

    public static void register() {
        ModFixs fixes = FMLCommonHandler.instance().getDataFixer().init("thebetweenlands", 1);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileEntityNameFixer());
    }

    private static class TileEntityNameFixer
    implements IFixableData {
        private static final String[] NAMES = new String[]{"druid_altar", "purifier", "weedwood_workbench", "compost_bin", "loot_pot", "mob_spawner", "wisp", "sulfur_furnace", "sulfur_furnace_dual", "betweenlands_chest", "rubber_tap", "spike_trap", "possessed_block", "item_cage", "weedwood_sign", "mud_flower_pot", "gecko_cage", "infuser", "mortar", "animator", "alembic", "dug_soil", "item_shelf", "tar_beast_spawner", "tar_loot_pot_1", "tar_loot_pot_2", "tar_loot_pot_3", "syrmorite_hopper", "moss_bed", "aspect_vial", "aspectrus_crop", "repeller", "present"};
        private static final Map<String, String> MAP;

        private TileEntityNameFixer() {
        }

        public int func_188216_a() {
            return 1;
        }

        public NBTTagCompound func_188217_a(NBTTagCompound nbt) {
            String id = nbt.func_74779_i("id");
            if (MAP.containsKey(id)) {
                nbt.func_74778_a("id", MAP.get(id));
            }
            return nbt;
        }

        static {
            ImmutableMap.Builder names = ImmutableMap.builder();
            for (String name : NAMES) {
                names.put((Object)("minecraft:tile.thebetweenlands." + name), (Object)("thebetweenlands:" + name));
            }
            MAP = names.build();
        }
    }
}

