/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.loader.IFastTESRBakedModels;
import thebetweenlands.client.render.model.tile.ModelSpikeBlock;
import thebetweenlands.common.block.structure.BlockSpikeTrap;
import thebetweenlands.common.tile.TileEntitySpikeTrap;
import thebetweenlands.util.StatePropertyHelper;

@SideOnly(value=Side.CLIENT)
public class RenderSpikeTrap
extends TileEntitySpecialRenderer<TileEntitySpikeTrap>
implements IFastTESRBakedModels {
    private static final ModelSpikeBlock MODEL = new ModelSpikeBlock();
    private final ResourceLocation spikeTexture;
    private final ModelResourceLocation[] overlayModelLocations = new ModelResourceLocation[EnumFacing.field_82609_l.length];
    private final Map<ModelResourceLocation, EnumFacing> overlayModelFacings = new HashMap<ModelResourceLocation, EnumFacing>();
    protected static BlockRendererDispatcher blockRenderer;
    private IBakedModel[] overlayModels = new IBakedModel[EnumFacing.field_82609_l.length];

    public RenderSpikeTrap() {
        this(new ResourceLocation("thebetweenlands:spike_trap"), new ResourceLocation("thebetweenlands:textures/tiles/spike_block_spikes_1.png"));
    }

    public RenderSpikeTrap(ResourceLocation overlayModel, ResourceLocation spikeTexture) {
        this.spikeTexture = spikeTexture;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            ModelResourceLocation location;
            this.overlayModelLocations[facing.ordinal()] = location = new ModelResourceLocation(overlayModel, "facing=" + facing.func_176610_l() + ",overlay=true");
            this.overlayModelFacings.put(location, facing);
        }
    }

    @Override
    public Collection<ModelResourceLocation> getModelLocations() {
        return ImmutableSet.copyOf((Object[])this.overlayModelLocations);
    }

    @Override
    public void onModelBaked(ModelResourceLocation location, IBakedModel model) {
        this.overlayModels[this.overlayModelFacings.get((Object)location).ordinal()] = model;
    }

    public void render(TileEntitySpikeTrap tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.renderFast(tile, x, y, z, partialTicks, destroyStage, alpha);
    }

    private void renderFast(TileEntitySpikeTrap tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.func_147499_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179147_l();
        GlStateManager.func_179129_p();
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        this.renderTileEntityFast(tile, x, y, z, partialTicks, destroyStage, alpha, buffer);
        buffer.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
    }

    private void renderSpikes(TileEntitySpikeTrap tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tile.animationTicks > 0) {
            EnumFacing facing = StatePropertyHelper.getStatePropertySafely(tile, BlockSpikeTrap.class, BlockSpikeTrap.field_176387_N, EnumFacing.UP);
            if (tile.func_145831_w() != null) {
                RenderHelper.func_74519_b();
                int i = tile.func_145831_w().func_175626_b(tile.func_174877_v().func_177972_a(facing), 0);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.func_147499_a(this.spikeTexture);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            switch (facing) {
                case UP: {
                    GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case DOWN: {
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case NORTH: {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
            GlStateManager.func_179129_p();
            MODEL.renderSpikes(tile, partialTicks);
            GlStateManager.func_179089_o();
            GlStateManager.func_179121_F();
        }
    }

    public void renderTileEntityFast(TileEntitySpikeTrap tile, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        BlockPos pos = tile.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)tile.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockSpikeTrap) {
            if (tile.type != 0) {
                if (blockRenderer == null) {
                    blockRenderer = Minecraft.func_71410_x().func_175602_ab();
                }
                if (state.func_177230_c() instanceof BlockSpikeTrap) {
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockSpikeTrap.field_176387_N);
                    buffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
                    blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, this.overlayModels[facing.ordinal()], state, pos, buffer, false);
                }
            }
            this.renderSpikes(tile, x, y, z, partialTicks, destroyStage, 1.0f);
        }
    }
}

