/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelInfuser;
import thebetweenlands.common.block.container.BlockInfuser;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.tile.TileEntityInfuser;
import thebetweenlands.util.StatePropertyHelper;

@SideOnly(value=Side.CLIENT)
public class RenderInfuser
extends TileEntitySpecialRenderer<TileEntityInfuser> {
    private final ModelInfuser model = new ModelInfuser();
    public static ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/infuser.png");

    public void render(TileEntityInfuser infuser, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        this.func_147499_a(TEXTURE);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (infuser == null || !infuser.func_145830_o()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.5f, (float)1.5f, (float)0.5f);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            this.model.render();
            GlStateManager.func_179121_F();
            return;
        }
        BlockPos pos = infuser.func_174877_v();
        EnumFacing facing = StatePropertyHelper.getStatePropertySafely(infuser, BlockInfuser.class, BlockInfuser.FACING, EnumFacing.NORTH);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        switch (facing) {
            default: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.model.render();
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(infuser.getStirProgress() * 4), (float)0.0f, (float)1.0f, (float)0.0f);
        this.model.renderSpoon();
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        ElixirRecipe recipe = infuser.getInfusingRecipe();
        if (BetweenlandsConfig.DEBUG.debug) {
            String elixirName = recipe != null ? recipe.name : " N/A";
            this.renderStirCount("Evap: " + infuser.getEvaporation() + " Temp: " + infuser.getTemperature() + " Time: " + infuser.getInfusionTime() + " Recipe: " + elixirName, x, y, z);
        }
        int amount = infuser.waterTank.getFluidAmount();
        int capacity = infuser.waterTank.getCapacity();
        float size = 1.0f / (float)capacity * (float)amount;
        int itemBob = infuser.getItemBob();
        int stirProgress = infuser.getStirProgress();
        float crystalRotation = infuser.getCrystalRotation();
        double itemY = y + 0.3 + (double)size * 0.5;
        Random rand = new Random();
        rand.setSeed(pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p());
        for (int i = 0; i <= 6; ++i) {
            float randRot = rand.nextFloat() * 360.0f;
            double xo = -0.2 + (double)rand.nextFloat() * 0.4;
            double zo = -0.2 + (double)rand.nextFloat() * 0.4;
            double rot = (stirProgress < 90 && amount >= 100 ? (double)stirProgress * 4.0 + 45.0 : 45.0) + (double)randRot;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)0.0, (double)(z + 0.5));
            GlStateManager.func_179114_b((float)((float)(-rot)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)xo, (double)0.0, (double)zo);
            this.renderItemInSlot(infuser, i, 0.0, itemY, 0.0, amount >= 100 ? (i % 2 == 0 ? (double)itemBob * 0.01 : (double)(-itemBob + 20) * 0.01) : 0.0, -rot);
            GlStateManager.func_179121_F();
        }
        this.renderItemInSlot(infuser, 7, x + 0.5, y + 1.43, z + 0.5, (double)itemBob * 0.01, crystalRotation);
        if (amount >= 100) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder vb = tess.func_178180_c();
            TextureAtlasSprite waterSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(FluidRegistry.SWAMP_WATER.getStill().toString());
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            this.func_147499_a(TextureMap.field_110575_b);
            float tx = (float)x + 0.0f;
            float ty = (float)(y + (double)0.35f + (double)(size * 0.5f));
            float tz = (float)z + 0.0f;
            vb.func_178969_c((double)tx, (double)ty, (double)tz);
            vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            float[] targetColor = infuser.getInfusionColorGradientTicks() > 0 ? new float[]{infuser.prevInfusionColor[0] + (infuser.currentInfusionColor[0] - infuser.prevInfusionColor[0]) / 30.0f * (float)infuser.getInfusionColorGradientTicks(), infuser.prevInfusionColor[1] + (infuser.currentInfusionColor[1] - infuser.prevInfusionColor[1]) / 30.0f * (float)infuser.getInfusionColorGradientTicks(), infuser.prevInfusionColor[2] + (infuser.currentInfusionColor[2] - infuser.prevInfusionColor[2]) / 30.0f * (float)infuser.getInfusionColorGradientTicks(), infuser.prevInfusionColor[3] + (infuser.currentInfusionColor[3] - infuser.prevInfusionColor[3]) / 30.0f * (float)infuser.getInfusionColorGradientTicks()} : infuser.currentInfusionColor;
            vb.func_181662_b(0.1875, 0.0, 0.1875).func_187315_a((double)waterSprite.func_94209_e(), (double)waterSprite.func_94206_g()).func_181666_a(targetColor[0], targetColor[1], targetColor[2], targetColor[3]).func_181675_d();
            vb.func_181662_b(0.1875, 0.0, 0.8125).func_187315_a((double)waterSprite.func_94209_e(), (double)waterSprite.func_94210_h()).func_181666_a(targetColor[0], targetColor[1], targetColor[2], targetColor[3]).func_181675_d();
            vb.func_181662_b(0.8125, 0.0, 0.8125).func_187315_a((double)waterSprite.func_94212_f(), (double)waterSprite.func_94210_h()).func_181666_a(targetColor[0], targetColor[1], targetColor[2], targetColor[3]).func_181675_d();
            vb.func_181662_b(0.8125, 0.0, 0.1875).func_187315_a((double)waterSprite.func_94212_f(), (double)waterSprite.func_94206_g()).func_181666_a(targetColor[0], targetColor[1], targetColor[2], targetColor[3]).func_181675_d();
            vb.func_178969_c(0.0, 0.0, 0.0);
            tess.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void renderItemInSlot(TileEntityInfuser infuser, int slotIndex, double x, double y, double z, double itemBob, double rotation) {
        if (!infuser.func_70301_a(slotIndex).func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
            GlStateManager.func_179137_b((double)0.0, (double)itemBob, (double)0.0);
            GlStateManager.func_179114_b((float)((float)rotation), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(infuser.func_70301_a(slotIndex), ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    private void renderStirCount(String count, double x, double y, double z) {
        float scale = 0.02666667f;
        float height = 0.8f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)height + 0.75), (double)(z + 0.5));
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        int width = fontrenderer.func_78256_a(count) / 2;
        vb.func_181662_b((double)(-width - 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vb.func_181662_b((double)(-width - 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vb.func_181662_b((double)(width + 1), 8.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        vb.func_181662_b((double)(width + 1), -1.0, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(count, -fontrenderer.func_78256_a(count) / 2, 0, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(count, -fontrenderer.func_78256_a(count) / 2, 0, -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

