/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.common.entity.mobs.EntityGasCloud;

public class ParticleGasCloud
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected boolean rotateReversed = false;
    protected EntityGasCloud cloud;

    protected ParticleGasCloud(World world, double x, double y, double z, double vecX, double vecY, double vecZ, float startRotation, float scale) {
        this(world, null, x, y, z, vecX, vecY, vecZ, startRotation, scale);
    }

    protected ParticleGasCloud(World world, EntityGasCloud cloud, double x, double y, double z, double vecX, double vecY, double vecZ, float startRotation, float scale) {
        super(world, x, y, z, vecX, vecY, vecZ);
        this.cloud = cloud;
        this.field_187129_i = this.field_187129_i * 0.01 + vecX;
        this.field_187130_j = this.field_187130_j * 0.01 + vecY;
        this.field_187131_k = this.field_187131_k * 0.01 + vecZ;
        this.field_187126_f = this.field_187123_c = (x += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187127_g = this.field_187124_d = (y += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187128_h = this.field_187125_e = (z += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_70547_e = 60;
        this.field_70544_f = scale;
        this.field_190017_n = false;
        this.field_190015_G = this.field_190014_F = startRotation;
        if (startRotation < 0.0f) {
            this.rotateReversed = true;
        }
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.cloud != null && !this.cloud.func_70089_S()) {
            int[] gasColor = this.cloud.getGasColor();
            float fade = 1.0f - (float)this.cloud.field_70725_aQ / 80.0f;
            this.func_82338_g((float)Math.pow(fade, 2.0) * (float)gasColor[3] / 255.0f);
            this.func_70538_b((float)gasColor[0] / 255.0f * fade, (float)gasColor[1] / 255.0f * fade, (float)gasColor[2] / 255.0f * fade);
        }
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        float scale = 0.1f * this.field_70544_f;
        float interpX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float interpY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float interpZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int lightmapX = brightness >> 16 & 0xFFFF;
        int lightmapY = brightness & 0xFFFF;
        Vec3d[] scaledRotations = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        if (this.field_190014_F != 0.0f) {
            float interpRoll = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(interpRoll * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(interpRoll * 0.5f)) * (float)ParticleGasCloud.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(interpRoll * 0.5f)) * (float)ParticleGasCloud.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(interpRoll * 0.5f)) * (float)ParticleGasCloud.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d((double)f10, (double)f11, (double)f12);
            for (int l = 0; l < 4; ++l) {
                scaledRotations[l] = vec3d.func_186678_a(2.0 * scaledRotations[l].func_72430_b(vec3d)).func_178787_e(scaledRotations[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(scaledRotations[l]).func_186678_a((double)(2.0f * f9)));
            }
        }
        int fadeInDuration = 15;
        int fadeOutStart = 45;
        int fadeOutDuration = this.field_70547_e - fadeOutStart;
        float alpha = this.field_70546_d < fadeOutStart ? this.field_82339_as * Math.min((float)this.field_70546_d / (float)fadeInDuration, 1.0f) : this.field_82339_as * (1.0f - Math.min((float)(this.field_70546_d - fadeOutStart) / (float)fadeOutDuration, 1.0f));
        worldRendererIn.func_181662_b((double)interpX + scaledRotations[0].field_72450_a, (double)interpY + scaledRotations[0].field_72448_b, (double)interpZ + scaledRotations[0].field_72449_c).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(lightmapX, lightmapY).func_181675_d();
        worldRendererIn.func_181662_b((double)interpX + scaledRotations[1].field_72450_a, (double)interpY + scaledRotations[1].field_72448_b, (double)interpZ + scaledRotations[1].field_72449_c).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(lightmapX, lightmapY).func_181675_d();
        worldRendererIn.func_181662_b((double)interpX + scaledRotations[2].field_72450_a, (double)interpY + scaledRotations[2].field_72448_b, (double)interpZ + scaledRotations[2].field_72449_c).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(lightmapX, lightmapY).func_181675_d();
        worldRendererIn.func_181662_b((double)interpX + scaledRotations[3].field_72450_a, (double)interpY + scaledRotations[3].field_72448_b, (double)interpZ + scaledRotations[3].field_72449_c).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(lightmapX, lightmapY).func_181675_d();
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.field_190015_G = this.field_190014_F;
        this.field_190014_F += this.rotateReversed ? -0.015f : 0.015f;
    }

    public int func_70537_b() {
        return 1;
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleGasCloud> {
        public Factory() {
            super(ParticleGasCloud.class, ParticleTextureStitcher.create(ParticleGasCloud.class, new ResourceLocation("thebetweenlands:particle/gas_cloud")));
        }

        @Override
        protected void setDefaultArguments(World world, double x, double y, double z, ParticleFactory.ParticleArgs<?> args) {
            ((ParticleFactory.ParticleArgs)args.withData(null, Float.valueOf(world.field_73012_v.nextFloat() * 2.0f * (float)Math.PI * 2.0f - (float)Math.PI * 2))).withScale((world.field_73012_v.nextFloat() * 0.75f + 0.6f) * 10.0f);
        }

        @Override
        public ParticleGasCloud createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleGasCloud(args.world, args.data.getObject(EntityGasCloud.class, 0), args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.data.getFloat(1), args.scale);
        }
    }
}

