/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.model.animation.IClip;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;

public class ModelTransform
implements IModel {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();
    private final IModel model;
    private final TRSRTransformation transform;

    public ModelTransform(IModel model, TRSRTransformation transform) {
        this.model = model;
        this.transform = transform;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IModelState stateWrapper = part -> {
            Optional<TRSRTransformation> transformation = state.apply(part);
            if (!part.isPresent()) {
                transformation = transformation.isPresent() ? Optional.of(((TRSRTransformation)transformation.get()).compose(TRSRTransformation.blockCenterToCorner((TRSRTransformation)this.transform))) : Optional.of(TRSRTransformation.blockCenterToCorner((TRSRTransformation)this.transform));
            }
            return transformation;
        };
        return this.model.bake(stateWrapper, format, bakedTextureGetter);
    }

    public Optional<? extends IClip> getClip(String name) {
        return this.model.getClip(name);
    }

    public IModelState getDefaultState() {
        return this.model.getDefaultState();
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.model.getDependencies();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.model.getTextures();
    }

    public IModel gui3d(boolean value) {
        return new ModelTransform(this.model.gui3d(value), this.transform);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        TRSRTransformation transform = this.transform;
        String transformJsonStr = (String)customData.get((Object)"trsr_transformation");
        if (transformJsonStr != null) {
            transform = (TRSRTransformation)GSON.fromJson(transformJsonStr, TRSRTransformation.class);
        }
        JsonParser parser = new JsonParser();
        IModel transformedModel = this.model;
        if (customData.containsKey((Object)"transformed_model") || transformedModel == null) {
            ResourceLocation baseModelLocation = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"transformed_model")), (String)"transformed_model"));
            transformedModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)baseModelLocation, (String)"Could not find model for transform model");
        }
        if (customData.containsKey((Object)"model_data")) {
            transformedModel = transformedModel.process(LoaderExtension.parseJsonElementList(parser, (String)customData.get((Object)"model_data"), "model_data"));
        }
        return new ModelTransform(transformedModel, transform);
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        return new ModelTransform(this.model.retexture(textures), this.transform);
    }

    public IModel smoothLighting(boolean value) {
        return new ModelTransform(this.model.smoothLighting(value), this.transform);
    }

    public IModel uvlock(boolean value) {
        return new ModelTransform(this.model.uvlock(value), this.transform);
    }
}

