/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ModelDynBucketBL
implements IModel {
    private final IModel model;
    private final ResourceLocation baseLocation;
    private final ResourceLocation liquidLocation;
    private final ResourceLocation coverLocation;
    private final Fluid fluid;
    private final boolean flipGas;

    public ModelDynBucketBL() {
        this.model = ModelDynBucket.MODEL;
        this.baseLocation = null;
        this.liquidLocation = null;
        this.coverLocation = null;
        this.fluid = null;
        this.flipGas = false;
    }

    public ModelDynBucketBL(ResourceLocation baseLocation, ResourceLocation liquidLocation, ResourceLocation coverLocation, Fluid fluid, boolean flipGas) {
        this.model = new ModelDynBucket(baseLocation, liquidLocation, coverLocation, fluid, flipGas);
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.model.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return this.model.bake(state, format, bakedTextureGetter);
    }

    public IModelState getDefaultState() {
        return this.model.getDefaultState();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        JsonParser parser = new JsonParser();
        Fluid fluid = this.fluid;
        if (customData.containsKey((Object)"default_fluid")) {
            String fluidName = JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"default_fluid")), (String)"default_fluid");
            fluid = FluidRegistry.getFluid((String)fluidName);
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr;
            switch (flipStr = JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"flipGas")), (String)"flipGas")) {
                case "true": {
                    flip = true;
                    break;
                }
                case "false": {
                    flip = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
                }
            }
        }
        ResourceLocation baseLocation = null;
        ResourceLocation liquidLocation = null;
        ResourceLocation coverLocation = null;
        baseLocation = customData.containsKey((Object)"base_texture") ? new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"base_texture")), (String)"base_texture")) : this.baseLocation;
        liquidLocation = customData.containsKey((Object)"liquid_template") ? new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"liquid_template")), (String)"liquid_template")) : this.liquidLocation;
        coverLocation = customData.containsKey((Object)"cover_texture") ? new ResourceLocation(JsonUtils.func_151206_a((JsonElement)parser.parse((String)customData.get((Object)"cover_texture")), (String)"cover_texture")) : this.coverLocation;
        return new ModelDynBucketBL(baseLocation, liquidLocation, coverLocation, fluid, flip);
    }
}

