/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.StalactiteHelper;

public class SpikeRenderer {
    private List<BakedQuad> quads = new ArrayList<BakedQuad>();
    public final int length;
    public final float widthScale;
    public final float heightScale;
    public final float offsetScale;
    public final int bx;
    public final int by;
    public final int bz;
    public final double x;
    public final double y;
    public final double z;
    private VertexFormat format;
    private TextureAtlasSprite sprite;

    public SpikeRenderer(int length, float widthScale, float heightScale, float offsetScale, long seed) {
        this(length, widthScale, heightScale, offsetScale, seed, 0.0, 0.0, 0.0);
    }

    public SpikeRenderer(int length, float widthScale, float heightScale, float offsetScale, long seed, double x, double y, double z) {
        this.length = length;
        this.widthScale = widthScale;
        this.heightScale = heightScale;
        this.offsetScale = offsetScale;
        Random rand = new Random();
        rand.setSeed(seed);
        this.bx = rand.nextInt();
        this.by = rand.nextInt(128);
        this.bz = rand.nextInt();
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public VertexFormat getFormat() {
        return this.format;
    }

    public SpikeRenderer build(VertexFormat format, TextureAtlasSprite sprite) {
        return this.build(format, sprite, sprite);
    }

    public SpikeRenderer build(VertexFormat format, TextureAtlasSprite bottomSprite, TextureAtlasSprite midSprite) {
        this.sprite = bottomSprite;
        this.format = format;
        QuadBuilder builder = new QuadBuilder(format);
        for (int y = 0; y < this.length; ++y) {
            float distToMidTop;
            float distToMidBottom;
            double halfTotalHeightSQ;
            int distUp = this.length - 1 - y;
            int distDown = y;
            boolean noTop = true;
            boolean noBottom = false;
            float height = 1.0f;
            int totalHeight = 1 + distDown + distUp;
            double squareAmount = 1.2;
            if (noTop) {
                halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
                distToMidBottom = Math.abs(distUp + 1);
                distToMidTop = Math.abs(distUp);
            } else if (noBottom) {
                halfTotalHeightSQ = Math.pow(totalHeight, squareAmount);
                distToMidBottom = Math.abs(distDown);
                distToMidTop = Math.abs(distDown + 1);
            } else {
                float halfTotalHeight = (float)totalHeight * 0.5f;
                halfTotalHeightSQ = Math.pow(halfTotalHeight, squareAmount);
                distToMidBottom = Math.abs(halfTotalHeight - (float)distUp - 1.0f);
                distToMidTop = Math.abs(halfTotalHeight - (float)distUp);
            }
            int minValBottom = noBottom && distDown == 0 ? 0 : 1;
            int minValTop = noTop && distUp == 0 ? 0 : 1;
            int scaledValBottom = (int)(Math.pow(distToMidBottom, squareAmount) / halfTotalHeightSQ * (double)(8 - minValBottom)) + minValBottom;
            int scaledValTop = (int)(Math.pow(distToMidTop, squareAmount) / halfTotalHeightSQ * (double)(8 - minValTop)) + minValTop;
            float umin = 0.0f;
            float umax = 16.0f;
            float vmin = 0.0f;
            float vmax = 16.0f;
            float halfSize = (float)scaledValBottom / 16.0f * this.widthScale;
            float halfSizeTexW = halfSize * (umax - umin);
            float halfSize1 = (float)scaledValTop / 16.0f * this.widthScale;
            float halfSizeTex1 = halfSize1 * (umax - umin);
            StalactiteHelper core = StalactiteHelper.getValsFor(this.bx, this.by + y, this.bz);
            if (distDown == 0 && !noBottom) {
                core.bX = 0.5;
                core.bZ = 0.5;
            }
            if (distUp == 0 && !noTop) {
                core.tX = 0.5;
                core.tZ = 0.5;
            }
            core.bX *= (double)this.offsetScale;
            core.tX *= (double)this.offsetScale;
            core.bZ *= (double)this.offsetScale;
            core.tZ *= (double)this.offsetScale;
            core.bX += this.x;
            core.tX += this.x;
            core.bZ += this.z;
            core.tZ += this.z;
            if (y == 0) {
                builder.setSprite(bottomSprite);
            } else {
                builder.setSprite(midSprite);
            }
            builder.addVertex(core.bX - (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ - (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
            builder.addVertex(core.bX - (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ + (double)halfSize, umin, vmax);
            builder.addVertex(core.tX - (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ + (double)halfSize1, umin, vmin);
            builder.addVertex(core.tX - (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ - (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
            builder.addVertex(core.bX + (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
            builder.addVertex(core.bX + (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ - (double)halfSize, umin, vmax);
            builder.addVertex(core.tX + (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ - (double)halfSize1, umin, vmin);
            builder.addVertex(core.tX + (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
            builder.addVertex(core.bX + (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ - (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
            builder.addVertex(core.bX - (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ - (double)halfSize, umin, vmax);
            builder.addVertex(core.tX - (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ - (double)halfSize1, umin, vmin);
            builder.addVertex(core.tX + (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ - (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
            builder.addVertex(core.bX - (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmax);
            builder.addVertex(core.bX + (double)halfSize, this.y + (double)((float)y * this.heightScale), core.bZ + (double)halfSize, umin, vmax);
            builder.addVertex(core.tX + (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ + (double)halfSize1, umin, vmin);
            builder.addVertex(core.tX - (double)halfSize1, this.y + (double)(((float)y + height) * this.heightScale), core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
            if (distUp == 0) {
                builder.addVertex(core.tX - (double)halfSize1, this.y + (double)y + (double)height, core.tZ - (double)halfSize1, umin, vmin);
                builder.addVertex(core.tX - (double)halfSize1, this.y + (double)y + (double)height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin);
                builder.addVertex(core.tX + (double)halfSize1, this.y + (double)y + (double)height, core.tZ + (double)halfSize1, umin + halfSizeTex1 * 2.0f, vmin + halfSizeTex1 * 2.0f);
                builder.addVertex(core.tX + (double)halfSize1, this.y + (double)y + (double)height, core.tZ - (double)halfSize1, umin, vmin + halfSizeTex1 * 2.0f);
            }
            if (distDown != 0) continue;
            builder.addVertex(core.bX - (double)halfSize, this.y + (double)y, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmin);
            builder.addVertex(core.bX - (double)halfSize, this.y + (double)y, core.bZ - (double)halfSize, umin, vmin);
            builder.addVertex(core.bX + (double)halfSize, this.y + (double)y, core.bZ - (double)halfSize, umin, vmin + halfSizeTexW * 2.0f);
            builder.addVertex(core.bX + (double)halfSize, this.y + (double)y, core.bZ + (double)halfSize, umin + halfSizeTexW * 2.0f, vmin + halfSizeTexW * 2.0f);
        }
        this.quads = builder.build().nonCulledQuads;
        return this;
    }

    public void upload(BufferBuilder buffer) {
        for (BakedQuad quad : this.quads) {
            buffer.func_178981_a(quad.func_178209_a());
        }
    }

    public void render() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, this.format);
        this.upload(buffer);
        tessellator.func_78381_a();
    }
}

