/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui.inventory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.recipes.ICenserRecipe;
import thebetweenlands.common.inventory.container.ContainerCenser;
import thebetweenlands.common.tile.TileEntityCenser;

@SideOnly(value=Side.CLIENT)
public class GuiCenser
extends GuiContainer {
    private TileEntityCenser censer;
    private static final ResourceLocation CENSER_GUI_TEXTURE = new ResourceLocation("thebetweenlands:textures/gui/censer.png");

    public GuiCenser(InventoryPlayer inv, TileEntityCenser tile) {
        super((Container)new ContainerCenser(inv, tile));
        this.field_147000_g = 256;
        this.censer = tile;
    }

    protected void func_146976_a(float partialTickTime, int x, int y) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(CENSER_GUI_TEXTURE);
        int xx = (this.field_146294_l - this.field_146999_f) / 2;
        int yy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(xx, yy, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        FluidStack fluidStack;
        ItemStack internalStack;
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        Slot internalSlot = this.field_147002_h.func_75139_a(2);
        ArrayList<String> effectTooltip = null;
        ICenserRecipe<Object> currentRecipe = this.censer.getCurrentRecipe();
        int fuelTicks = this.censer.getFuelTicks();
        if (currentRecipe != null) {
            int amount;
            ArrayList<String> effect = new ArrayList<String>();
            currentRecipe.getLocalizedEffectText(this.censer.getCurrentRecipeContext(), this.censer, effect);
            if (!effect.isEmpty()) {
                effectTooltip = new ArrayList<String>();
                effectTooltip.add("");
                effectTooltip.add(TextFormatting.DARK_PURPLE + I18n.func_74837_a((String)"tooltip.bl.censer_effect", (Object[])new Object[0]));
                effectTooltip.addAll(effect);
            }
            if ((amount = this.censer.getCurrentRemainingInputAmount()) > 0) {
                int maxAmount = this.censer.getCurrentMaxInputAmount();
                int effectColor = currentRecipe.getEffectColor(this.censer.getCurrentRecipeContext(), this.censer, ICenserRecipe.EffectColorType.GUI);
                float percent = (float)amount / (float)maxAmount;
                this.field_73735_i = 100.0f;
                this.field_146296_j.field_77023_b = 100.0f;
                GlStateManager.func_179140_f();
                GlStateManager.func_179091_B();
                GlStateManager.func_179141_d();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179098_w();
                int maxBarHeight = 84;
                int barHeight = MathHelper.func_76123_f((float)(percent * (float)maxBarHeight));
                int barHeightBackground = Math.min(barHeight + 1, maxBarHeight);
                int barHeightBackground2 = Math.min(barHeight + 2, maxBarHeight);
                int barHeightBackground3 = Math.min(barHeight + 3, maxBarHeight);
                this.field_146297_k.func_110434_K().func_110577_a(CENSER_GUI_TEXTURE);
                this.drawTexturedModalRectWithGradient(this.field_147003_i + 67, this.field_147009_r + 18 + maxBarHeight - barHeightBackground3, 195, 1 + maxBarHeight - barHeightBackground3, 47, barHeightBackground3, -14671840, -14671840);
                this.drawTexturedModalRectWithGradient(this.field_147003_i + 67, this.field_147009_r + 18 + maxBarHeight - barHeightBackground2, 195, 1 + maxBarHeight - barHeightBackground2, 47, barHeightBackground2, -11513776, -11513776);
                this.drawTexturedModalRectWithGradient(this.field_147003_i + 67, this.field_147009_r + 18 + maxBarHeight - barHeightBackground, 195, 1 + maxBarHeight - barHeightBackground, 47, barHeightBackground, -8355712, -8355712);
                this.drawTexturedModalRectWithGradient(this.field_147003_i + 67, this.field_147009_r + 18 + maxBarHeight - barHeight, 195, 1 + maxBarHeight - barHeight, 47, barHeight, effectColor, -1);
                GlStateManager.func_179118_c();
                GlStateManager.func_179101_C();
                GlStateManager.func_179145_e();
                this.field_146296_j.field_77023_b = 0.0f;
                this.field_73735_i = 0.0f;
            }
        }
        if (fuelTicks > 0) {
            int maxFuelTicks = this.censer.getMaxFuelTicks();
            float percent = (float)fuelTicks / (float)maxFuelTicks;
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            int maxBarHeight = 14;
            int barHeight = MathHelper.func_76123_f((float)(percent * (float)maxBarHeight));
            this.field_146297_k.func_110434_K().func_110577_a(CENSER_GUI_TEXTURE);
            this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 122 + maxBarHeight - barHeight, 177, 20 + maxBarHeight - barHeight, 14, barHeight);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179145_e();
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
        }
        if (!(internalStack = internalSlot.func_75211_c()).func_190926_b()) {
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, internalStack, this.field_147003_i + internalSlot.field_75223_e, this.field_147009_r + internalSlot.field_75221_f);
            this.field_146296_j.func_180453_a(this.field_146289_q, internalStack, this.field_147003_i + internalSlot.field_75223_e, this.field_147009_r + internalSlot.field_75221_f, null);
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
            if (this.func_146978_c(internalSlot.field_75223_e, internalSlot.field_75221_f, 16, 16, mouseX, mouseY)) {
                this.renderToolTipWithMore(internalStack, mouseX, mouseY, effectTooltip);
            }
        }
        if ((fluidStack = this.censer.getTankProperties()[0].getContents()) != null) {
            ResourceLocation fluidTexture = fluidStack.getFluid().getStill();
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            this.field_73735_i = 90.0f;
            int color = fluidStack.getFluid().getColor(fluidStack);
            if (fluidTexture != null) {
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTexture.toString());
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color >> 0 & 0xFF) / 255.0f;
                float a = (float)(color >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
                this.func_175175_a(this.field_147003_i + internalSlot.field_75223_e - 3, this.field_147009_r + internalSlot.field_75221_f - 3, sprite, 20, 20);
            } else {
                GlStateManager.func_179090_x();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.field_73735_i);
                GuiCenser.func_73734_a((int)(this.field_147003_i + internalSlot.field_75223_e - 3), (int)(this.field_147009_r + internalSlot.field_75221_f - 3), (int)(this.field_147003_i + internalSlot.field_75223_e - 3 + 20), (int)(this.field_147009_r + internalSlot.field_75221_f - 3 + 20), (int)color);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(CENSER_GUI_TEXTURE);
            this.func_73729_b(this.field_147003_i + internalSlot.field_75223_e - 3, this.field_147009_r + internalSlot.field_75221_f - 3, 176, 100, 20, 20);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179145_e();
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
            if (this.func_146978_c(internalSlot.field_75223_e, internalSlot.field_75221_f, 16, 16, mouseX, mouseY)) {
                ArrayList<String> tooltip = new ArrayList<String>();
                tooltip.add(fluidStack.getLocalizedName() + " (" + fluidStack.amount + "mb)");
                if (effectTooltip != null) {
                    tooltip.addAll(effectTooltip);
                }
                this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
            }
        }
        if ((fluidStack == null || fluidStack.amount == 0) && internalStack.func_190926_b()) {
            this.field_73735_i = 100.0f;
            this.field_146296_j.field_77023_b = 100.0f;
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            this.field_146297_k.func_110434_K().func_110577_a(CENSER_GUI_TEXTURE);
            this.func_73729_b(this.field_147003_i + internalSlot.field_75223_e - 1, this.field_147009_r + internalSlot.field_75221_f - 1, 176, 1, 18, 18);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179145_e();
            this.field_146296_j.field_77023_b = 0.0f;
            this.field_73735_i = 0.0f;
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void renderToolTipWithMore(ItemStack stack, int x, int y, @Nullable List<String> more) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List tooltip = this.func_191927_a(stack);
        if (more != null) {
            tooltip.addAll(more);
        }
        this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    protected void drawTexturedModalRectWithGradient(int x, int y, int textureX, int textureY, int width, int height, int colorTop, int colorBottom) {
        float r1 = (float)(colorTop >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(colorTop >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(colorTop >> 0 & 0xFF) / 255.0f;
        float a1 = (float)(colorTop >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(colorBottom >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(colorBottom >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(colorBottom >> 0 & 0xFF) / 255.0f;
        float a2 = (float)(colorBottom >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181666_a(r2, g2, b2, a2).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181666_a(r2, g2, b2, a2).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181666_a(r1, g1, b1, a1).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181666_a(r1, g1, b1, a1).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
    }
}

