/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntitySplitTank
extends TileEntityBase
implements ITickable,
IFluidHandler,
IInventory {
    private int currentMix = 0;
    public int maxMix;
    public int mixUsage;
    private int currentBioDiesel = 0;
    public int maxBioDiesel;
    public int bioDieselGeneration;
    private int currentGlycerin = 0;
    public int maxGlycerin;
    public int glycerinGeneration;
    public int generatingTime;
    private int timeToGenerate = 0;
    protected InventoryBasic inventory = new InventoryBasic("", false, 0);

    public TileEntitySplitTank() {
        this.maxMix = Config.splitTankFluidStorage;
        this.maxBioDiesel = Config.splitTankFluidStorage;
        this.maxGlycerin = Config.splitTankFluidStorage;
        this.generatingTime = Config.splitTankGeneratingTime;
        this.mixUsage = Config.splitTankMixUsage;
        this.glycerinGeneration = Config.splitTankGlycerinGeneration;
        this.bioDieselGeneration = Config.splitTankBioDieselGeneration;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.timeToGenerate > 0) {
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix - this.mixUsage >= 0) {
                this.currentMix -= this.mixUsage;
                if (this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel) {
                    this.currentBioDiesel += this.bioDieselGeneration;
                }
                if (this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
                    this.currentGlycerin += this.glycerinGeneration;
                }
            }
        } else if (this.currentMix >= this.mixUsage && this.currentBioDiesel + this.bioDieselGeneration <= this.maxBioDiesel && this.currentGlycerin + this.glycerinGeneration <= this.maxGlycerin) {
            this.timeToGenerate = this.generatingTime;
        }
        if (this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.synchronize();
        }
        this.func_70296_d();
    }

    public float getBioDieselPerc() {
        return (float)this.currentBioDiesel / (float)this.maxBioDiesel;
    }

    public float getGlycerinPerc() {
        return (float)this.currentGlycerin / (float)this.maxGlycerin;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.currentMix;
            }
            case 1: {
                return this.currentBioDiesel;
            }
            case 2: {
                return this.currentGlycerin;
            }
            case 3: {
                return this.timeToGenerate;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.currentMix = value;
                break;
            }
            case 1: {
                this.currentBioDiesel = value;
                break;
            }
            case 2: {
                this.currentGlycerin = value;
                break;
            }
            case 3: {
                this.timeToGenerate = value;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("mix", this.currentMix);
        compound.func_74768_a("bio_diesel", this.currentBioDiesel);
        compound.func_74768_a("glycerin", this.currentGlycerin);
        compound.func_74768_a("time", this.timeToGenerate);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.currentMix = compound.func_74762_e("mix");
        this.currentBioDiesel = compound.func_74762_e("bio_diesel");
        this.currentGlycerin = compound.func_74762_e("glycerin");
        this.timeToGenerate = compound.func_74762_e("timeToGenerate");
        super.func_145839_a(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public int func_174890_g() {
        return 4;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.split_tank.name", new Object[0]);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, TileEntitySplitTank.this.currentMix);
            }

            public int getCapacity() {
                return TileEntitySplitTank.this.maxMix;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals((Object)ModFluids.CANOLA_METHANOL_MIX);
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrain() {
                return false;
            }
        }, new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack((Fluid)ModFluids.BIO_DIESEL, TileEntitySplitTank.this.currentBioDiesel);
            }

            public int getCapacity() {
                return TileEntitySplitTank.this.maxBioDiesel;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals((Object)ModFluids.BIO_DIESEL);
            }

            public boolean canDrain() {
                return true;
            }
        }, new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack((Fluid)ModFluids.GLYCERIN, TileEntitySplitTank.this.currentGlycerin);
            }

            public int getCapacity() {
                return TileEntitySplitTank.this.maxGlycerin;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals((Object)ModFluids.GLYCERIN);
            }

            public boolean canDrain() {
                return true;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid().equals((Object)ModFluids.CANOLA_METHANOL_MIX)) {
            int amount = Math.min(this.maxMix - this.currentMix, resource.amount);
            if (doFill) {
                this.currentMix += amount;
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.getFluid().equals((Object)ModFluids.GLYCERIN)) {
            int amount = Math.min(resource.amount, this.currentGlycerin);
            if (doDrain) {
                this.currentGlycerin -= amount;
                this.func_70296_d();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN, amount);
        }
        if (resource.getFluid().equals((Object)ModFluids.BIO_DIESEL)) {
            int amount = Math.min(resource.amount, this.currentBioDiesel);
            if (doDrain) {
                this.currentBioDiesel -= amount;
                this.func_70296_d();
            }
            return new FluidStack((Fluid)ModFluids.BIO_DIESEL, amount);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.currentGlycerin > this.currentBioDiesel) {
            int amount = Math.min(maxDrain, this.currentGlycerin);
            if (doDrain) {
                this.currentGlycerin -= amount;
                this.func_70296_d();
            }
            return new FluidStack((Fluid)ModFluids.GLYCERIN, amount);
        }
        int amount = Math.min(maxDrain, this.currentBioDiesel);
        if (doDrain) {
            this.currentBioDiesel -= amount;
            this.func_70296_d();
        }
        return new FluidStack((Fluid)ModFluids.BIO_DIESEL, amount);
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }
}

