/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex;

import com.github.atomicblom.weirdinggadget.Logger;
import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXModel;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.Axis;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMatrixTransform;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexParser;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexScene;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionRange;
import org.apache.logging.log4j.Level;

public enum OpenGEXModelLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Map<ResourceLocation, OgexScene> cache = Maps.newHashMap();
    private Set<String> enabledDomains = Sets.newHashSet();

    private OpenGEXModelLoader() {
        this.enabledDomains.add("steamnsteel_opengex");
    }

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b().toLowerCase()) && modelLocation.func_110623_a().toLowerCase().endsWith(".ogex");
    }

    public void func_110549_a(IResourceManager manager) {
        this.manager = manager;
        this.cache.clear();
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        OgexScene scene;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            try {
                IResource resource;
                try {
                    resource = this.manager.func_110536_a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                OgexParser ogexParser = new OgexParser();
                InputStreamReader reader = new InputStreamReader(resource.func_110527_b());
                OgexScene ogexScene = ogexParser.parseScene(reader);
                this.cache.put(file, ogexScene);
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Exception loading model %s with OGEX loader, skipping", (Object[])new Object[]{modelLocation});
                this.cache.put(file, null);
                throw e;
            }
        }
        if ((scene = this.cache.get(file)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        if (scene.getMetrics().getUp() == Axis.Z) {
            boolean useNormalCycleMatrix;
            block23: {
                useNormalCycleMatrix = true;
                ModContainer ctm = null;
                ModContainer foamfix = null;
                for (ModContainer modContainer : Loader.instance().getModList()) {
                    if ("ctm".equals(modContainer.getModId())) {
                        ctm = modContainer;
                        Logger.info(ctm.toString(), new Object[0]);
                    } else if ("foamfix".equals(modContainer.getModId())) {
                        foamfix = modContainer;
                        Logger.info(foamfix.toString(), new Object[0]);
                    }
                    if (foamfix == null || ctm == null) continue;
                    break;
                }
                try {
                    VersionRange badVersions;
                    if (ctm == null || foamfix == null) break block23;
                    Logger.warning("Detected ctm and foamfix, we might need to hack the model", new Object[0]);
                    String ctmVersionString = ctm.getVersion();
                    if (ctmVersionString.contains("-")) {
                        int dashOffset = ctmVersionString.indexOf("-") + 1;
                        ctmVersionString = ctmVersionString.substring(dashOffset);
                    }
                    DefaultArtifactVersion ctmVersion = new DefaultArtifactVersion(ctmVersionString);
                    try {
                        badVersions = VersionRange.createFromVersionSpec((String)"[0.3.3,)");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Well that didn't work");
                    }
                    if (badVersions.containsVersion((ArtifactVersion)ctmVersion)) {
                        Logger.warning("Look out, we have CTM > v3.3, better check for foamfix anarchy.", new Object[0]);
                        try {
                            Class<?> foamFixShared = Class.forName("pl.asie.foamfix.shared.FoamFixShared");
                            boolean isCoreMod = foamFixShared.getField("isCoremod").getBoolean(null);
                            Object foamFixConfig = foamFixShared.getField("config").get(null);
                            boolean clWipeModelCache = foamFixConfig.getClass().getField("clWipeModelCache").getBoolean(foamFixConfig);
                            if (isCoreMod && clWipeModelCache) {
                                Logger.warning("Detected dastardly combo of foamfix anarchy + ctm 2.3, using alternative rotations", new Object[0]);
                                useNormalCycleMatrix = false;
                                break block23;
                            }
                            Logger.info("Foamfix was not configured as a coremod or clWipeModelCache was not enabled.", new Object[0]);
                        }
                        catch (Exception e) {
                            Logger.warning(e.toString(), new Object[0]);
                            Logger.warning("Nevermind, we couldn't find FoamFixShared.", new Object[0]);
                        }
                        break block23;
                    }
                    Logger.warning("Nope. It's an older version of ctm lib. *phew*", new Object[0]);
                }
                catch (Exception e) {
                    Logger.severe("There was an error detecting if we needed to work around a ctm 3.3/foamfix anarchy bug.", new Object[0]);
                    Logger.severe(e.toString(), new Object[0]);
                }
            }
            float[] foamFixCycleMatrix = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            float[] normalcycleMatrix = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            float[] cycleMatrix = useNormalCycleMatrix ? normalcycleMatrix : foamFixCycleMatrix;
            for (OgexNode ogexNode : scene) {
                OgexMatrixTransform matrixTransform = new OgexMatrixTransform();
                matrixTransform.setMatrix(cycleMatrix);
                ogexNode.getTransforms().add(0, matrixTransform);
            }
        }
        return new OpenGEXModel(file, scene);
    }
}

