/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.playerskins.handlers;

import com.gendeathrow.playerskins.data.LootItem;
import com.gendeathrow.playerskins.data.PlayerSkinData;
import com.gendeathrow.playerskins.handlers.PlayerManager;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class SpecialLootManager {
    public static final HashMap<PlayerSkinData, ArrayList<LootItem>> LOOTTABLES = new HashMap();

    public static boolean addNewSpecial(PlayerSkinData playerSkin, ArrayList<LootItem> drops) {
        if (drops.size() > 0 && !LOOTTABLES.containsKey((Object)playerSkin)) {
            LOOTTABLES.put(playerSkin, drops);
        }
        return true;
    }

    public static boolean hasLoot(String owner) {
        return PlayerManager.getPlayerSkinProfile(owner) != null && LOOTTABLES.containsKey((Object)PlayerManager.getPlayerSkinProfile(owner));
    }

    public static void DropLoot(Entity entity, String owner) {
        if (!SpecialLootManager.hasLoot(owner)) {
            return;
        }
        ArrayList<LootItem> drops = LOOTTABLES.get((Object)PlayerManager.getPlayerSkinProfile(owner));
        if (drops != null) {
            for (LootItem drop : drops) {
                ItemStack stack;
                if (!drop.shouldDrop(entity.field_70170_p.field_73012_v) || (stack = drop.getStack(entity.field_70170_p.field_73012_v)).func_190926_b()) continue;
                entity.func_70099_a(stack, 0.0f);
            }
        }
    }

    public static void clearLootTable() {
        LOOTTABLES.clear();
    }

    public static void readJsonItemDrops(PlayerSkinData playerSkin, JsonObject json) {
        if (!json.has("specialDrops")) {
            return;
        }
        ArrayList<LootItem> drops = new ArrayList<LootItem>();
        for (JsonElement item : json.getAsJsonArray("specialDrops")) {
            LootItem loot = new LootItem();
            try {
                drops.add(loot.readJsonObject(item.getAsJsonObject()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        SpecialLootManager.addNewSpecial(playerSkin, drops);
    }

    public static void writeJsonItemDrops(PlayerSkinData playerSkin, JsonObject json) {
        if (LOOTTABLES.containsKey((Object)playerSkin)) {
            JsonArray itemArray = new JsonArray();
            for (LootItem item : LOOTTABLES.get((Object)playerSkin)) {
                JsonObject itemJson = new JsonObject();
                item.writeJsonObject(itemJson);
                itemArray.add((JsonElement)itemJson);
            }
            if (itemArray.size() > 0) {
                json.add("specialDrops", (JsonElement)itemArray);
            }
        }
    }
}

