/*
 * Decompiled with CFR 0.152.
 */
package com.seth0067.tothebatpoles;

import com.seth0067.tothebatpoles.Holder;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Message
implements IMessage {
    private int holderId;
    private boolean decelerate;
    private float deltaYaw;

    public Message() {
    }

    public Message(Holder holder, boolean decelerate, float deltaYaw) {
        this.holderId = holder.func_145782_y();
        this.decelerate = decelerate;
        this.deltaYaw = deltaYaw;
    }

    public void fromBytes(ByteBuf buf) {
        this.holderId = buf.readInt();
        this.decelerate = buf.readBoolean();
        this.deltaYaw = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.holderId);
        buf.writeBoolean(this.decelerate);
        buf.writeFloat(this.deltaYaw);
    }

    public static class Handler
    implements IMessageHandler<Message, IMessage> {
        public IMessage onMessage(Message message, MessageContext ctx) {
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            Entity entity = world.func_73045_a(message.holderId);
            if (entity instanceof Holder) {
                Holder holder = (Holder)entity;
                world.func_152344_a(() -> {
                    holder.updateSlideAcceleration(message.decelerate);
                    holder.updateSpinVelocity(message.deltaYaw);
                });
            }
            return null;
        }
    }
}

