/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.item.ItemUpgradeKit;
import com.shinoow.abyssalcraft.api.recipe.UpgradeKitRecipes;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import java.util.Map;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.UpgradeKit")
public class UpgradeKit {
    @ZenMethod
    public static void addUpgrade(IItemStack kit, IItemStack input, IItemStack output) {
        if (ACMT.toStack(kit).func_77973_b() instanceof ItemUpgradeKit) {
            ACMTMisc.TASKS.add(new Add(ACMT.toStack(kit), ACMT.toStack(input), ACMT.toStack(output)));
        } else {
            ACLogger.warning((String)"%s is not a Upgrade Kit!", (Object[])new Object[]{ACMT.getItemNameSafely(ACMT.toStack(kit))});
        }
    }

    @ZenMethod
    public static void removeUpgrade(IItemStack input) {
        ACMTMisc.TASKS.add(new Remove(ACMT.toStack(input)));
    }

    @ZenMethod
    public static void removeAll() {
        ACMTMisc.TASKS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            UpgradeKitRecipes.instance().getAllUpgrades().entrySet().forEach(e -> ((Map)e.getValue()).clear());
        }

        public String describe() {
            return "Removing all Upgrade Kit recipes";
        }
    }

    private static class Remove
    implements IAction {
        private ItemStack input;
        Map<ItemUpgradeKit, Map<ItemStack, ItemStack>> recipes;

        public Remove(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            this.recipes = Maps.newHashMap();
            for (Map.Entry entry : UpgradeKitRecipes.instance().getAllUpgrades().entrySet()) {
                for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                    if (!APIUtils.areStacksEqual((ItemStack)this.input, (ItemStack)((ItemStack)e1.getKey()))) continue;
                    if (!this.recipes.containsKey(entry.getKey())) {
                        this.recipes.put((ItemUpgradeKit)entry.getKey(), Maps.newHashMap());
                    }
                    this.recipes.get(entry.getKey()).put((ItemStack)e1.getKey(), (ItemStack)e1.getValue());
                }
            }
            for (Map.Entry<Object, Object> entry : this.recipes.entrySet()) {
                for (Map.Entry e1 : ((Map)entry.getValue()).entrySet()) {
                    UpgradeKitRecipes.instance().getUpgrades((ItemUpgradeKit)entry.getKey()).remove(e1.getKey(), e1.getValue());
                }
            }
        }

        public String describe() {
            return "Removing " + (this.recipes != null ? this.recipes.size() : 0) + " Upgrade Kit recipe(s) for " + ACMT.getItemNameSafely(this.input);
        }
    }

    private static class Add
    implements IAction {
        private ItemStack input;
        private ItemStack output;
        private ItemUpgradeKit kit;

        public Add(ItemStack kit, ItemStack input, ItemStack output) {
            this.kit = (ItemUpgradeKit)kit.func_77973_b();
            this.input = input;
            this.output = output;
        }

        public void apply() {
            AbyssalCraftAPI.addUpgrade((ItemUpgradeKit)this.kit, (ItemStack)this.input, (ItemStack)this.output);
        }

        public String describe() {
            return "Adding Upgrade Kit recipe for " + ACMT.getItemNameSafely(this.output);
        }
    }
}

