/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.recipe.CrystallizerRecipes;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.Crystallizer")
public class Crystallizer {
    @ZenMethod
    public static void addCrystallization(IItemStack input, IItemStack output1, IItemStack output2, float exp) {
        ACMTMisc.TASKS.add(new Add(ACMT.toStack(input), ACMT.toStack(output1), ACMT.toStack(output2), exp));
    }

    @ZenMethod
    public static void addSingleCrystallization(IItemStack input, IItemStack output, float exp) {
        ACMTMisc.TASKS.add(new Add(ACMT.toStack(input), ACMT.toStack(output), exp));
    }

    @ZenMethod
    public static void removeCrystallization(IItemStack input) {
        Crystallizer.removeCrystallizationInput(input);
    }

    @ZenMethod
    public static void removeCrystallizationInput(IItemStack input) {
        ACMTMisc.TASKS.add(new RemoveInput(ACMT.toStack(input)));
    }

    @ZenMethod
    public static void removeCrystallizationOutput(IItemStack output) {
        ACMTMisc.TASKS.add(new RemoveOutput(ACMT.toStack(output)));
    }

    @ZenMethod
    public static void addFuel(IItemStack stack, int burnTime) {
        ACMTMisc.TASKS.add(new AddFuel(ACMT.toStack(stack), burnTime));
    }

    @ZenMethod
    public static void removeFuel(IItemStack stack) {
        ACMTMisc.TASKS.add(new RemoveFuel(ACMT.toStack(stack)));
    }

    @ZenMethod
    public static void removeAll() {
        ACMTMisc.TASKS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            CrystallizerRecipes.instance().getCrystallizationList().clear();
        }

        public String describe() {
            return "Removing all Crystallizer recipes";
        }
    }

    private static class RemoveFuel
    implements IAction {
        private ItemStack stack;

        public RemoveFuel(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            ACMT.CRYSTALLIZER_FUELS.put(this.stack, 0);
        }

        public String describe() {
            return String.format("Removing %s as Crystallizer fuel", ACMT.getItemNameSafely(this.stack));
        }
    }

    private static class AddFuel
    implements IAction {
        private ItemStack stack;
        private int burnTime;

        public AddFuel(ItemStack stack, int burnTime) {
            this.stack = stack;
            this.burnTime = burnTime;
        }

        public void apply() {
            ACMT.CRYSTALLIZER_FUELS.put(this.stack, this.burnTime);
        }

        public String describe() {
            return String.format("Adding %s as Crystallizer fuel with a burntime of %d ", ACMT.getItemNameSafely(this.stack), this.burnTime);
        }
    }

    private static class RemoveOutput
    implements IAction {
        private ItemStack output;

        public RemoveOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            CrystallizerRecipes.instance().getCrystallizationList().entrySet().removeIf(e -> APIUtils.areStacksEqual((ItemStack)this.output, (ItemStack)((ItemStack[])e.getValue())[0]) || APIUtils.areStacksEqual((ItemStack)this.output, (ItemStack)((ItemStack[])e.getValue())[1]));
        }

        public String describe() {
            return "Removing Crystallization recipe(s) for " + ACMT.getItemNameSafely(this.output);
        }
    }

    private static class RemoveInput
    implements IAction {
        private ItemStack input;

        public RemoveInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            CrystallizerRecipes.instance().getCrystallizationList().entrySet().removeIf(e -> APIUtils.areStacksEqual((ItemStack)this.input, (ItemStack)((ItemStack)e.getKey())));
        }

        public String describe() {
            return "Removing Crystallization recipe with input: " + ACMT.getItemNameSafely(this.input);
        }
    }

    private static class Add
    implements IAction {
        private ItemStack input;
        private ItemStack output1;
        private ItemStack output2;
        private float exp;
        private boolean isSingle;

        public Add(ItemStack input, ItemStack output1, ItemStack output2, float exp) {
            this.input = input;
            this.output1 = output1;
            this.output2 = output2;
            this.exp = exp;
        }

        public Add(ItemStack input, ItemStack output, float exp) {
            this(input, output, ItemStack.field_190927_a, exp);
            this.isSingle = true;
        }

        public void apply() {
            if (!this.isSingle) {
                AbyssalCraftAPI.addCrystallization((ItemStack)this.input, (ItemStack)this.output1, (ItemStack)this.output2, (float)this.exp);
            } else {
                AbyssalCraftAPI.addSingleCrystallization((ItemStack)this.input, (ItemStack)this.output1, (float)this.exp);
            }
        }

        public String describe() {
            return "Adding Crystallization recipe for " + ACMT.getItemNameSafely(this.output1) + (!this.output2.func_190926_b() ? " (and " + ACMT.getItemNameSafely(this.output2) + ")" : "");
        }
    }
}

