/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.RecipeRegistry;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;

public class TarringRecipeJEI
implements ICraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    private final ICraftingGridHelper craftingGridHelper;

    public TarringRecipeJEI(IGuiHelper guiHelper) {
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return RecipeRegistry.HEARTHGROVE_LOG_TARRING;
    }

    public void getIngredients(IIngredients ingredients) {
        Item log = Item.func_150898_a((Block)BlockRegistry.LOG_HEARTHGROVE);
        ItemStack inTarWeedwood = ItemRegistry.BL_BUCKET.withFluid(0, FluidRegistry.TAR);
        ItemStack inTarSyrmorite = ItemRegistry.BL_BUCKET.withFluid(1, FluidRegistry.TAR);
        ItemStack inBlock = new ItemStack(log, 1, 1);
        ItemStack outBlock = new ItemStack(log, 1, 5);
        ArrayList<Object> inputLists = new ArrayList<Object>(18);
        ArrayList<NonNullList> outputLists = new ArrayList<NonNullList>(18);
        inputLists.add(0, NonNullList.func_191196_a());
        outputLists.add(0, NonNullList.func_191196_a());
        for (int i = 0; i < 16; ++i) {
            int type = i / 8;
            int amount = i;
            if (inBlock.func_77952_i() == 1 && type == 1) {
                inBlock.func_77964_b(3);
            }
            if (outBlock.func_77952_i() == 5 && type == 1) {
                outBlock.func_190920_e(1);
                outBlock.func_77964_b(7);
            }
            List inStacks = (List)inputLists.get(0);
            inStacks.add(inTarWeedwood);
            inStacks.add(inTarSyrmorite);
            for (int j = 0; j < 8; ++j) {
                List<Object> inputStacks;
                if (inputLists.size() <= j + 1) {
                    inputStacks = new ArrayList<Object>(Collections.nCopies(16, null));
                    inputLists.add(j + 1, inputStacks);
                } else {
                    inputStacks = (List)inputLists.get(j + 1);
                }
                if (j > amount % 8) continue;
                inputStacks.set(amount, inBlock.func_77946_l());
            }
            List outputStacks = (List)outputLists.get(0);
            outputStacks.add(outBlock.func_77946_l());
            outBlock.func_190917_f(1);
        }
        ingredients.setInputLists(VanillaTypes.ITEM, inputLists);
        ingredients.setOutputLists(VanillaTypes.ITEM, outputLists);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        guiItemStacks.setOverrideDisplayFocus(null);
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        guiItemStacks.set(0, (List)outputs.get(0));
        BetweenlandsJEIPlugin.addRecipeName(this.getRegistryName(), guiItemStacks, 0);
    }
}

