/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.storage.location;

import net.minecraft.nbt.NBTTagCompound;
import thebetweenlands.common.world.storage.location.LocationStorage;

public class LocationAmbience {
    private LocationStorage location;
    public final EnumLocationAmbience type;
    private float fogStart = -1.0f;
    private float fogEnd = -1.0f;
    private float fogRangeMultiplier = -1.0f;
    private int[] fogColor = null;
    private int fogBrightness = -1;
    private float fogColorMultiplier = -1.0f;
    private boolean caveFog = true;

    public LocationAmbience(EnumLocationAmbience type) {
        this.type = type;
    }

    LocationAmbience setLocation(LocationStorage location) {
        this.location = location;
        return this;
    }

    public LocationStorage getLocation() {
        return this.location;
    }

    public LocationAmbience setFogRange(float start, float end) {
        this.fogStart = start;
        this.fogEnd = end;
        return this;
    }

    public boolean hasFogRange() {
        return this.fogStart >= 0.0f && this.fogEnd >= 0.0f;
    }

    public float getFogStart() {
        return this.fogStart;
    }

    public float getFogEnd() {
        return this.fogEnd;
    }

    public LocationAmbience setFogRangeMultiplier(float multiplier) {
        this.fogRangeMultiplier = multiplier;
        return this;
    }

    public boolean hasFogRangeMultiplier() {
        return this.fogRangeMultiplier >= 0.0f;
    }

    public float getFogRangeMultiplier() {
        return this.fogRangeMultiplier;
    }

    public LocationAmbience setFogColor(int[] color) {
        this.fogColor = color;
        return this;
    }

    public boolean hasFogColor() {
        return this.fogColor != null && this.fogColor.length == 3;
    }

    public int[] getFogColor() {
        return this.fogColor;
    }

    public LocationAmbience setFogBrightness(int brightness) {
        this.fogBrightness = brightness;
        return this;
    }

    public boolean hasFogBrightness() {
        return this.fogBrightness >= 0;
    }

    public int getFogBrightness() {
        return this.fogBrightness;
    }

    public LocationAmbience setFogColorMultiplier(float multiplier) {
        this.fogColorMultiplier = multiplier;
        return this;
    }

    public boolean hasFogColorMultiplier() {
        return this.fogColorMultiplier >= 0.0f;
    }

    public float getFogColorMultiplier() {
        return this.fogColorMultiplier;
    }

    public LocationAmbience setCaveFog(boolean caveFog) {
        this.caveFog = caveFog;
        return this;
    }

    public boolean hasCaveFog() {
        return this.caveFog;
    }

    public static LocationAmbience readFromNBT(LocationStorage location, NBTTagCompound nbt) {
        EnumLocationAmbience type = EnumLocationAmbience.fromName(nbt.func_74779_i("type"));
        if (type != EnumLocationAmbience.NONE) {
            LocationAmbience ambience = new LocationAmbience(type);
            ambience.setLocation(location);
            if (nbt.func_150297_b("fogStart", 5) && nbt.func_150297_b("fogEnd", 5)) {
                ambience.setFogRange(nbt.func_74760_g("fogStart"), nbt.func_74760_g("fogEnd"));
            }
            if (nbt.func_150297_b("fogColor", 11)) {
                ambience.setFogColor(nbt.func_74759_k("fogColor"));
            }
            if (nbt.func_150297_b("fogBrightness", 3)) {
                ambience.setFogBrightness(nbt.func_74762_e("fogBrightness"));
            }
            if (nbt.func_150297_b("fogColorMultiplier", 5)) {
                ambience.setFogColorMultiplier(nbt.func_74760_g("fogColorMultiplier"));
            }
            if (nbt.func_150297_b("fogRangeMultiplier", 5)) {
                ambience.setFogRangeMultiplier(nbt.func_74760_g("fogRangeMultiplier"));
            }
            if (nbt.func_150297_b("caveFog", 1)) {
                ambience.setCaveFog(nbt.func_74767_n("caveFog"));
            } else {
                ambience.setCaveFog(true);
            }
            return ambience;
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("type", this.type != null ? this.type.name : EnumLocationAmbience.NONE.name);
        if (this.hasFogRange()) {
            nbt.func_74776_a("fogStart", this.fogStart);
            nbt.func_74776_a("fogEnd", this.fogEnd);
        }
        if (this.hasFogColor()) {
            nbt.func_74783_a("fogColor", this.fogColor);
        }
        if (this.hasFogBrightness()) {
            nbt.func_74768_a("fogBrightness", this.fogBrightness);
        }
        if (this.hasFogColorMultiplier()) {
            nbt.func_74776_a("fogColorMultiplier", this.fogColorMultiplier);
        }
        if (this.hasFogRangeMultiplier()) {
            nbt.func_74776_a("fogRangeMultiplier", this.fogRangeMultiplier);
        }
        nbt.func_74757_a("caveFog", this.hasCaveFog());
    }

    public static enum EnumLocationAmbience {
        NONE("none"),
        WIGHT_TOWER("wightTower"),
        SLUDGE_WORM_DUNGEON("sludgeWormDungeon"),
        OTHER("other");

        public static EnumLocationAmbience[] TYPES;
        public final String name;

        private EnumLocationAmbience(String name) {
            this.name = name;
        }

        public static EnumLocationAmbience fromName(String name) {
            for (EnumLocationAmbience type : TYPES) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return NONE;
        }

        static {
            TYPES = EnumLocationAmbience.values();
        }
    }
}

