/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.event;

import java.util.Calendar;
import java.util.GregorianCalendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.ModelRegistry;
import thebetweenlands.common.world.WorldProviderBetweenlands;
import thebetweenlands.common.world.event.BLEnvironmentEventRegistry;
import thebetweenlands.common.world.event.SeasonalEnvironmentEvent;

public class EventSpoopy
extends SeasonalEnvironmentEvent {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "spook");
    private static final long SPOOPY_DATE = new GregorianCalendar(Calendar.getInstance().get(1), 9, 23, 0, 0).getTime().getTime();
    private float skyTransparency = 0.0f;
    private float lastSkyTransparency = 0.0f;

    public EventSpoopy(BLEnvironmentEventRegistry registry) {
        super(registry);
    }

    @Override
    public long getStartDateInMs() {
        return SPOOPY_DATE;
    }

    @Override
    public int getDurationInDays() {
        return 8;
    }

    public void setSkyTransparency(float transparency) {
        this.lastSkyTransparency = this.skyTransparency;
        this.skyTransparency = transparency;
    }

    public float getSkyTransparency(float partialTicks) {
        return (this.skyTransparency + (this.skyTransparency - this.lastSkyTransparency) * partialTicks) / 2.0f;
    }

    @Override
    public ResourceLocation getEventName() {
        return ID;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.isActive() && TheBetweenlands.proxy.getClientWorld() != null && TheBetweenlands.proxy.getClientPlayer() != null) {
            EventSpoopy.updateModelActiveState(active);
            EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
            int px = MathHelper.func_76128_c((double)player.field_70165_t) - 256;
            int py = MathHelper.func_76128_c((double)player.field_70163_u) - 256;
            int pz = MathHelper.func_76128_c((double)player.field_70161_v) - 256;
            TheBetweenlands.proxy.getClientWorld().func_147458_c(px, py, pz, px + 512, py + 512, pz + 512);
        }
        super.setActive(active);
    }

    @Override
    public void update(World world) {
        super.update(world);
        if (world.field_72995_K) {
            if (this.isActive()) {
                if (this.skyTransparency < 1.0f) {
                    this.setSkyTransparency(this.skyTransparency + 0.003f);
                }
                if (this.skyTransparency > 1.0f) {
                    this.setSkyTransparency(1.0f);
                }
            } else {
                if (this.skyTransparency > 0.0f) {
                    this.setSkyTransparency(this.skyTransparency - 0.003f);
                }
                if (this.skyTransparency < 0.0f) {
                    this.setSkyTransparency(0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.field_73011_w instanceof WorldProviderBetweenlands) {
            EventSpoopy.updateModelActiveState(((WorldProviderBetweenlands)world.field_73011_w).getEnvironmentEventRegistry().spoopy.isActive());
        } else {
            EventSpoopy.updateModelActiveState(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateModelActiveState(boolean active) {
        ModelRegistry.SPOOK_EVENT.setActive(active);
    }

    @Override
    protected void showStatusMessage(EntityPlayer player) {
        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.event.spook", new Object[0]), true);
    }
}

