/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.registries.AspectRegistry;

public class TileEntityGeckoCage
extends TileEntity
implements ITickable {
    private int ticks = 0;
    private int prevTicks = 0;
    private int recoverTicks = 0;
    private IAspectType aspectType = null;
    private int geckoUsages = 0;
    private String geckoName;

    public void func_73660_a() {
        this.prevTicks = this.ticks++;
        if (!this.field_145850_b.field_72995_K) {
            if (this.recoverTicks > 0) {
                --this.recoverTicks;
                if (this.recoverTicks == 0) {
                    IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                }
            } else {
                IBlockState state;
                if (this.aspectType != null && this.geckoUsages == 0) {
                    this.geckoName = "";
                    state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                }
                if (this.aspectType != null) {
                    this.aspectType = null;
                    state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                }
            }
        }
    }

    public int getTicks() {
        return this.ticks;
    }

    public float getInterpolatedTicks(float delta) {
        return (float)this.prevTicks + (float)(this.ticks - this.prevTicks) * delta;
    }

    public IAspectType getAspectType() {
        return this.aspectType;
    }

    public void setAspectType(IAspectType type, int recoverTime) {
        --this.geckoUsages;
        this.aspectType = type;
        this.recoverTicks = recoverTime;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        if (!this.hasGecko()) {
            this.recoverTicks = 0;
        }
    }

    public boolean hasGecko() {
        return this.geckoUsages > 0;
    }

    public void setGeckoUsages(int usages) {
        this.geckoUsages = usages;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public int getGeckoUsages() {
        return this.geckoUsages;
    }

    @Nullable
    public String getGeckoName() {
        return this.geckoName;
    }

    public void addGecko(int usages, @Nullable String name) {
        this.geckoUsages = usages;
        this.geckoName = name;
        this.ticks = 0;
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("RecoverTicks", this.recoverTicks);
        nbt.func_74768_a("GeckoUsages", this.geckoUsages);
        if (this.geckoName != null) {
            nbt.func_74778_a("GeckoName", this.geckoName);
        }
        nbt.func_74778_a("AspectType", this.aspectType == null ? "" : this.aspectType.getName());
        nbt.func_74768_a("Ticks", this.ticks);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recoverTicks = nbt.func_74762_e("RecoverTicks");
        this.geckoUsages = nbt.func_74762_e("GeckoUsages");
        this.geckoName = nbt.func_150297_b("GeckoName", 8) ? nbt.func_74779_i("GeckoName") : null;
        this.aspectType = AspectRegistry.getAspectTypeFromName(nbt.func_74779_i("AspectType"));
        this.ticks = nbt.func_74762_e("Ticks");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("GeckoUsages", this.geckoUsages);
        nbt.func_74778_a("AspectType", this.aspectType == null ? "" : this.aspectType.getName());
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.geckoUsages = nbt.func_74762_e("GeckoUsages");
        this.aspectType = AspectRegistry.getAspectTypeFromName(nbt.func_74779_i("AspectType"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74768_a("GeckoUsages", this.geckoUsages);
        nbt.func_74778_a("AspectType", this.aspectType == null ? "" : this.aspectType.getName());
        return nbt;
    }
}

