/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.api.entity.IEntityScreenShake;
import thebetweenlands.client.audio.DecayPitGearsSound;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleGasCloud;
import thebetweenlands.common.entity.EntityRootGrabber;
import thebetweenlands.common.entity.EntityShockwaveBlock;
import thebetweenlands.common.entity.EntityTriggeredSludgeWallJet;
import thebetweenlands.common.entity.mobs.EntityChiromaw;
import thebetweenlands.common.entity.mobs.EntityLargeSludgeWorm;
import thebetweenlands.common.entity.mobs.EntityShambler;
import thebetweenlands.common.entity.mobs.EntitySludge;
import thebetweenlands.common.entity.mobs.EntitySludgeJet;
import thebetweenlands.common.entity.mobs.EntitySludgeMenace;
import thebetweenlands.common.entity.mobs.EntitySludgeWorm;
import thebetweenlands.common.entity.mobs.EntitySmollSludge;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityTermite;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWorm;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.gen.feature.structure.utils.SludgeWormMazeBlockHelper;

public class TileEntityDecayPitControl
extends TileEntity
implements ITickable,
IEntityScreenShake {
    public float animationTicks = 0.0f;
    public float animationTicksPrev = 0.0f;
    public float plugDropTicks = 0.0f;
    public float plugDropTicksPrev = 0.0f;
    public float floorFadeTicks = 0.0f;
    public float floorFadeTicksPrev = 0.0f;
    public int spawnType = 0;
    public boolean isPlugged = false;
    public boolean showFloor = true;
    private int prevShakeTimer;
    private int shakeTimer;
    private boolean shaking = false;
    private int shakingTimerMax = 60;
    public boolean playGearSound = true;
    public boolean spawnDrops = false;
    public int deathTicks = 0;
    public int tentacleCooldown = 300;
    public int plugJump = 0;
    public int plugJumpPrev = 0;
    public float plugRotation = 0.0f;
    private SludgeWormMazeBlockHelper blockHelper = new SludgeWormMazeBlockHelper(null);
    protected final Map<Block, Boolean> invisibleBlocks = new HashMap<Block, Boolean>();

    public TileEntityDecayPitControl() {
        this.initInvisiBlockMap();
    }

    private void initInvisiBlockMap() {
        if (this.invisibleBlocks.isEmpty()) {
            this.invisibleBlocks.put(this.blockHelper.DECAY_PIT_INVISIBLE_FLOOR_BLOCK.func_177230_c(), true);
            this.invisibleBlocks.put(this.blockHelper.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_DIAGONAL.func_177230_c(), true);
            this.invisibleBlocks.put(this.blockHelper.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_L_1.func_177230_c(), true);
            this.invisibleBlocks.put(this.blockHelper.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_L_2.func_177230_c(), true);
            this.invisibleBlocks.put(this.blockHelper.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_R_1.func_177230_c(), true);
            this.invisibleBlocks.put(this.blockHelper.DECAY_PIT_INVISIBLE_FLOOR_BLOCK_R_2.func_177230_c(), true);
        }
    }

    public boolean isInvisibleBlock(Block block) {
        return this.invisibleBlocks.get(block) != null;
    }

    public void func_73660_a() {
        if (!this.isPlugged()) {
            this.animationTicksPrev = this.animationTicks;
            this.animationTicks += 1.0f;
            if (this.animationTicks >= 360.0f) {
                this.animationTicksPrev = 0.0f;
                this.animationTicks = 0.0f;
            }
            if (!this.func_145831_w().field_72995_K) {
                Entity thing;
                if (this.animationTicks == 15.0f || this.animationTicks == 195.0f) {
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() + 5.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() - 1.5);
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() - 4.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() + 2.5);
                }
                if (this.animationTicks == 60.0f || this.animationTicks == 240.0f) {
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() + 2.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() - 4.5);
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() - 1.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() + 5.5);
                }
                if (this.animationTicks == 105.0f || this.animationTicks == 285.0f) {
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() - 1.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() - 4.5);
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() + 2.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() + 5.5);
                }
                if (this.animationTicks == 150.0f || this.animationTicks == 330.0f) {
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() - 4.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() - 1.5);
                    this.spawnSludgeJet((double)this.func_174877_v().func_177958_n() + 5.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() + 2.5);
                }
                if (this.func_145831_w().func_82737_E() % 20L == 0L) {
                    this.updateBlock();
                }
                if (this.func_145831_w().func_82737_E() % 2400L == 0L) {
                    this.checkTurretSpawn(4, 12, 11);
                    this.checkTurretSpawn(-4, 12, 11);
                    this.checkTurretSpawn(11, 12, 4);
                    this.checkTurretSpawn(11, 12, -4);
                    this.checkTurretSpawn(4, 12, -11);
                    this.checkTurretSpawn(-4, 12, -11);
                    this.checkTurretSpawn(-11, 12, -4);
                    this.checkTurretSpawn(-11, 12, 4);
                }
                if (this.func_145831_w().func_82737_E() % 80L == 0L && (thing = this.getEntitySpawned(this.getSpawnType())) != null) {
                    thing.func_70107_b((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5);
                    this.func_145831_w().func_72838_d(thing);
                }
                if (this.getSpawnType() == 5) {
                    this.setPlugged(true);
                    this.setSpawnXPAndDrops(true);
                    this.removeInvisiBlocks(this.func_145831_w(), this.func_174877_v());
                    this.updateBlock();
                    this.func_145831_w().func_184133_a(null, this.func_174877_v().func_177982_a(1, 6, 0), SoundEvents.field_187677_b, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                    this.func_145831_w().func_184133_a(null, this.func_174877_v().func_177982_a(-1, 6, 0), SoundEvents.field_187677_b, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                    this.func_145831_w().func_184133_a(null, this.func_174877_v().func_177982_a(0, 6, 1), SoundEvents.field_187677_b, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                    this.func_145831_w().func_184133_a(null, this.func_174877_v().func_177982_a(0, 6, -1), SoundEvents.field_187677_b, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                }
            } else {
                this.spawnAmbientParticles();
            }
            this.checkSurfaceCollisions();
        }
        if (this.isPlugged()) {
            this.plugDropTicksPrev = this.plugDropTicks;
            this.floorFadeTicksPrev = this.floorFadeTicks;
            if (this.func_145831_w().field_72995_K && this.plugDropTicks <= 0.8f) {
                this.chainBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(1, 6, 0));
                this.chainBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(-1, 6, 0));
                this.chainBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 6, 1));
                this.chainBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 6, -1));
            }
            if (this.plugDropTicks <= 1.6f) {
                this.plugDropTicks += 0.2f;
            }
            if (this.plugDropTicks == 0.6f) {
                this.shaking = true;
                if (!this.func_145831_w().field_72995_K) {
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.PLUG_LOCK, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
            if (this.plugDropTicks > 1.6f && this.plugDropTicks <= 2.0f) {
                this.plugDropTicks += 0.1f;
            }
            if (this.plugDropTicks >= 2.0f && this.getShowFloor()) {
                this.floorFadeTicks += 0.025f;
            }
            if (this.floorFadeTicks >= 1.0f && !this.func_145831_w().field_72995_K) {
                this.setShowFloor(false);
                this.shakeTimer = 0;
                this.updateBlock();
            }
            if (this.shaking) {
                this.shake(60);
            }
        }
        if (!this.func_145831_w().field_72995_K && this.getSpawnXPAndDrops()) {
            int dropXP;
            this.setDeathTicks(this.getDeathTicks() + 1);
            if (this.getDeathTicks() > 40 && this.getDeathTicks() % 5 == 0) {
                for (int xp = 10; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.func_145831_w().func_72838_d((Entity)new EntityXPOrb(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() + 0.5, dropXP));
                }
            }
            if (this.getDeathTicks() == 80) {
                for (int xp = 120; xp > 0; xp -= dropXP) {
                    dropXP = EntityXPOrb.func_70527_a((int)xp);
                    this.func_145831_w().func_72838_d((Entity)new EntityXPOrb(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 3.0, (double)this.func_174877_v().func_177952_p() + 0.5, dropXP));
                }
            }
            if (this.getDeathTicks() > 120) {
                this.setSpawnXPAndDrops(false);
                this.updateBlock();
            }
        }
        if (this.func_145831_w().field_72995_K && !this.isPlugged() && this.playGearSound) {
            this.playGearsSound(this.func_145831_w(), this.func_174877_v());
            this.playGearSound = false;
        }
        if (this.isPlugged() && !this.getShowFloor() && this.getTentacleSpawnCountDown() >= 0) {
            if (!this.func_145831_w().field_72995_K) {
                this.setTentacleSpawnCountDown(this.getTentacleSpawnCountDown() - 1);
                if (this.getTentacleSpawnCountDown() == 100 || this.getTentacleSpawnCountDown() == 59 || this.getTentacleSpawnCountDown() == 29 || this.getTentacleSpawnCountDown() == 1) {
                    this.updateBlock();
                }
                if (this.getTentacleSpawnCountDown() % 30 == 0 && this.getTentacleSpawnCountDown() <= 270 && this.getTentacleSpawnCountDown() > 150 || this.getTentacleSpawnCountDown() % 33 == 0 && this.getTentacleSpawnCountDown() <= 270 && this.getTentacleSpawnCountDown() > 150) {
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.PIT_FALL, SoundCategory.HOSTILE, (float)this.getTentacleSpawnCountDown() * 0.004f * 0.25f, 0.5f + (float)this.getTentacleSpawnCountDown() * 0.004f * 0.5f);
                }
                if (this.getTentacleSpawnCountDown() == 150) {
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.WORM_SPLAT, SoundCategory.HOSTILE, 0.125f, 0.3f);
                }
                if (this.getTentacleSpawnCountDown() == 60 || this.getTentacleSpawnCountDown() == 30) {
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.PLUG_LOCK, SoundCategory.HOSTILE, 0.5f, 1.0f);
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.WALL_SLAM, SoundCategory.HOSTILE, 1.0f, 0.75f);
                    this.updateBlock();
                }
                if (this.getTentacleSpawnCountDown() == 0) {
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundRegistry.WALL_SLAM, SoundCategory.HOSTILE, 1.0f, 0.75f);
                    this.func_145831_w().func_184133_a(null, this.func_174877_v(), SoundEvents.field_187929_hc, SoundCategory.HOSTILE, 0.25f, 0.5f);
                    this.func_145831_w().func_180501_a(this.func_174877_v(), BlockRegistry.GLOWING_BETWEENSTONE_TILE.func_176223_P(), 3);
                    EntitySludgeMenace menace = new EntitySludgeMenace(this.field_145850_b);
                    menace.setPositionToAnchor(this.func_174877_v(), EnumFacing.UP, EnumFacing.NORTH);
                    this.field_145850_b.func_72838_d((Entity)menace);
                }
            }
            if (this.getTentacleSpawnCountDown() <= 100) {
                this.shaking = true;
                this.shakeTimer = 0;
                if (this.field_145850_b.field_72995_K) {
                    this.spawnAmbientParticles();
                }
            }
            if (this.func_145831_w().field_72995_K) {
                this.plugJumpPrev = this.plugJump;
                if (this.plugJump > 0) {
                    --this.plugJump;
                }
            }
            if ((this.getTentacleSpawnCountDown() == 60 || this.getTentacleSpawnCountDown() == 30 || this.getTentacleSpawnCountDown() == 1) && this.func_145831_w().field_72995_K) {
                this.plugJump = 2 + this.func_145831_w().field_73012_v.nextInt(5);
                this.plugRotation = (this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 5.0f;
            }
            if (this.getTentacleSpawnCountDown() == 1 && this.func_145831_w().field_72995_K) {
                this.plugBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 1, -1));
                this.plugBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(1, 1, 0));
                this.plugBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(-1, 1, 0));
                this.plugBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 1, 1));
                this.plugBreakParticles(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 0, 0));
            }
        }
    }

    private void setTentacleSpawnCountDown(int tentacle_countdown) {
        this.tentacleCooldown = tentacle_countdown;
        this.func_70296_d();
    }

    private int getTentacleSpawnCountDown() {
        return this.tentacleCooldown;
    }

    @SideOnly(value=Side.CLIENT)
    public void playGearsSound(World world, BlockPos pos) {
        DecayPitGearsSound chain_sound = new DecayPitGearsSound(this);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)chain_sound);
    }

    @SideOnly(value=Side.CLIENT)
    public void chainBreakParticles(World world, BlockPos pos) {
        double px = (double)pos.func_177958_n() + 0.5;
        double py = (double)pos.func_177956_o() + 0.5;
        double pz = (double)pos.func_177952_p() + 0.5;
        int amount = 10;
        for (int i = 0; i < amount; ++i) {
            double ox = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f - (double)0.3f;
            double oz = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f - (double)0.3f;
            double motionX = this.func_145831_w().field_73012_v.nextDouble() * (double)0.4f - (double)0.2f;
            double motionY = this.func_145831_w().field_73012_v.nextDouble() * (double)0.3f + (double)0.075f;
            double motionZ = this.func_145831_w().field_73012_v.nextDouble() * (double)0.4f - (double)0.2f;
            world.func_190523_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)BlockRegistry.DECAY_PIT_HANGING_CHAIN.func_176223_P())});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void plugBreakParticles(World world, BlockPos pos) {
        double px = (double)pos.func_177958_n() + 0.5;
        double py = (double)pos.func_177956_o() + 0.5;
        double pz = (double)pos.func_177952_p() + 0.5;
        int amount = 40;
        for (int i = 0; i < amount; ++i) {
            double ox = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f - (double)0.3f;
            double oz = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f - (double)0.3f;
            double motionX = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f - (double)0.3f;
            double motionY = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f;
            double motionZ = this.func_145831_w().field_73012_v.nextDouble() * (double)0.6f - (double)0.3f;
            world.func_190523_a(EnumParticleTypes.ITEM_CRACK.func_179348_c(), px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Item.func_150891_b((Item)Item.func_150898_a((Block)BlockRegistry.DUNGEON_DOOR_RUNES.func_176223_P().func_177230_c()))});
            world.func_190523_a(EnumParticleTypes.BLOCK_DUST.func_179348_c(), px + ox, py, pz + oz, motionX, motionY, motionZ, new int[]{Block.func_176210_f((IBlockState)BlockRegistry.MUD_BRICK_STAIRS_DECAY_4.func_176223_P())});
        }
    }

    private void removeInvisiBlocks(World world, BlockPos pos) {
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177963_a(-4.0, 2.0, -4.0), (BlockPos)pos.func_177963_a(4.0, 2.0, 4.0));
        for (BlockPos posIteration : blocks) {
            if (!this.isInvisibleBlock(this.func_145831_w().func_180495_p(posIteration).func_177230_c())) continue;
            world.func_175698_g(posIteration);
        }
    }

    private void checkTurretSpawn(int x, int y, int z) {
        EntityTriggeredSludgeWallJet entity;
        BlockPos checkPos = this.func_174877_v().func_177982_a(x, y, z);
        AxisAlignedBB checkBox = new AxisAlignedBB(checkPos);
        List entityList = this.func_145831_w().func_72872_a(EntityTriggeredSludgeWallJet.class, checkBox);
        Iterator iterator = entityList.iterator();
        while (iterator.hasNext() && !((entity = (EntityTriggeredSludgeWallJet)iterator.next()) instanceof EntityTriggeredSludgeWallJet)) {
        }
        if (entityList.isEmpty()) {
            EntityTriggeredSludgeWallJet jet = new EntityTriggeredSludgeWallJet(this.func_145831_w());
            jet.func_70107_b((double)checkPos.func_177958_n() + 0.5, checkPos.func_177956_o(), (double)checkPos.func_177952_p() + 0.5);
            this.func_145831_w().func_72838_d((Entity)jet);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnAmbientParticles() {
        BlockPos pos = this.func_174877_v();
        double x = (double)pos.func_177958_n() + 0.5 + (double)((this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 2.0f);
        double y = (double)pos.func_177956_o() + 1.5;
        double z = (double)pos.func_177952_p() + 0.5 + (double)((this.field_145850_b.field_73012_v.nextFloat() - 0.5f) / 2.0f);
        double mx = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.08f;
        double my = this.field_145850_b.field_73012_v.nextFloat() * 0.175f;
        double mz = (this.field_145850_b.field_73012_v.nextFloat() - 0.5f) * 0.08f;
        int[] color = new int[]{100, 70, 0, 255};
        ParticleGasCloud hazeParticle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_145850_b, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(8.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE, hazeParticle);
        ParticleGasCloud particle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_145850_b, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(4.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_TEXTURED, particle);
    }

    private void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    private Entity checkSurfaceCollisions() {
        boolean reverse = false;
        for (Entity entity : this.getEntityAbove()) {
            if (entity == null || entity instanceof EntitySludgeJet || entity instanceof EntityRootGrabber || entity instanceof IEntityBL || entity instanceof EntityShockwaveBlock) continue;
            if (entity instanceof EntityArrow) {
                entity.func_70106_y();
            }
            if (this.getDistance(entity) >= 4.25f - entity.field_70130_N * 0.5f && this.getDistance(entity) <= 7.0f + entity.field_70130_N * 0.5f) {
                reverse = false;
                if (entity.field_70163_u <= (double)this.func_174877_v().func_177956_o() + 3.0) {
                    entity.field_70159_w = 0.0;
                    entity.field_70181_x = 0.1;
                    entity.field_70179_y = 0.0;
                } else if (entity.field_70181_x < 0.0) {
                    entity.field_70181_x = 0.0;
                    this.checkJumpOnTopOfAABB(entity);
                }
            }
            if (this.getDistance(entity) < 4.25f - entity.field_70130_N * 0.5f && this.getDistance(entity) >= 2.5f + entity.field_70130_N * 0.5f && entity.field_70163_u <= (double)this.func_174877_v().func_177956_o() + 2.0 + 0.0625) {
                reverse = true;
                this.checkJumpOnTopOfAABB(entity);
            }
            if (!(this.getDistance(entity) >= 2.5f + entity.field_70130_N * 0.5f)) continue;
            Vec3d center = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, 0.0, (double)this.func_174877_v().func_177952_p() + 0.5);
            Vec3d entityOffset = new Vec3d(entity.field_70165_t, 0.0, entity.field_70161_v);
            double dist = entityOffset.func_72438_d(center);
            double circumference = Math.PI * 2 * dist;
            double speed = circumference / 360.0 * (double)(reverse ? 1.0f : 0.75f);
            Vec3d push = new Vec3d(0.0, 1.0, 0.0).func_72431_c(entityOffset.func_178788_d(center).func_72432_b()).func_72432_b().func_186678_a(reverse ? -speed : speed);
            if (entity.field_70170_p.field_72995_K && !(entity instanceof EntityPlayer)) continue;
            entity.func_70091_d(MoverType.SELF, push.field_72450_a, 0.0, push.field_72449_c);
        }
        return null;
    }

    public float getDistance(Entity entityIn) {
        float f = (float)((double)this.func_174877_v().func_177958_n() + 0.5 - entityIn.field_70165_t);
        float f1 = (float)((double)this.func_174877_v().func_177956_o() + 2.0 - entityIn.field_70163_u);
        float f2 = (float)((double)this.func_174877_v().func_177952_p() + 0.5 - entityIn.field_70161_v);
        return MathHelper.func_76129_c((float)(f * f + f1 * f1 + f2 * f2));
    }

    public void checkJumpOnTopOfAABB(Entity entity) {
        boolean jump;
        if (entity.func_130014_f_().field_72995_K && entity instanceof EntityPlayer && (jump = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d())) {
            ((EntityPlayer)entity).func_70664_aZ();
        }
    }

    public List<Entity> getEntityAbove() {
        return this.func_145831_w().func_175647_a(Entity.class, this.getFloorEntityBoundingBox(), EntitySelectors.field_94557_a);
    }

    private AxisAlignedBB getFloorEntityBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b(7.0, 0.0625, 7.0).func_72317_d(0.0, 2.0, 0.0);
    }

    private AxisAlignedBB getSpawningBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_72314_b(12.0, 6.0, 12.0).func_72317_d(0.0, 6.0, 0.0);
    }

    private void spawnSludgeJet(double posX, double posY, double posZ) {
        EntitySludgeJet jet = new EntitySludgeJet(this.func_145831_w());
        jet.func_70107_b(posX, posY, posZ);
        this.func_145831_w().func_72838_d((Entity)jet);
        this.func_145831_w().func_184133_a(null, jet.func_180425_c(), (SoundEvent)SoundRegistry.POOP_JET, SoundCategory.HOSTILE, 1.0f, 0.8f + this.func_145831_w().field_73012_v.nextFloat() * 0.5f);
    }

    public void setSpawnType(int spawn_type) {
        this.spawnType = spawn_type;
        this.func_70296_d();
    }

    public int getSpawnType() {
        return this.spawnType;
    }

    protected Entity getEntitySpawned(int spawnType) {
        List list = this.func_145831_w().func_72872_a(EntityLivingBase.class, this.getSpawningBoundingBox());
        if (list.stream().filter(e -> e instanceof IMob).count() >= 5L && list.stream().filter(e -> e instanceof IEntityBL).count() >= 5L) {
            return null;
        }
        Entity spawned_entity = null;
        Random rand = this.func_145831_w().field_73012_v;
        switch (spawnType) {
            case 0: {
                return rand.nextBoolean() ? new EntityTinySludgeWorm(this.func_145831_w()) : (rand.nextBoolean() ? new EntitySmollSludge(this.func_145831_w()) : (rand.nextBoolean() ? new EntityTermite(this.func_145831_w()) : new EntityLargeSludgeWorm(this.func_145831_w())));
            }
            case 1: {
                return rand.nextBoolean() ? new EntitySludgeWorm(this.func_145831_w()) : (rand.nextBoolean() ? new EntityChiromaw(this.func_145831_w()) : new EntityLargeSludgeWorm(this.func_145831_w()));
            }
            case 2: {
                return rand.nextBoolean() ? new EntitySwampHag(this.func_145831_w()) : (rand.nextBoolean() ? new EntitySludge(this.func_145831_w()) : new EntityLargeSludgeWorm(this.func_145831_w()));
            }
            case 3: {
                return rand.nextBoolean() ? new EntityShambler(this.func_145831_w()) : (rand.nextBoolean() ? new EntityChiromaw(this.func_145831_w()) : new EntityLargeSludgeWorm(this.func_145831_w()));
            }
            case 4: {
                return new EntityLargeSludgeWorm(this.func_145831_w());
            }
        }
        return spawned_entity;
    }

    public void setPlugged(boolean plugged) {
        this.isPlugged = plugged;
        this.func_70296_d();
    }

    public boolean isPlugged() {
        return this.isPlugged;
    }

    public boolean isUnPlugged() {
        return !this.isPlugged;
    }

    public void setShowFloor(boolean show_floor) {
        this.showFloor = show_floor;
        this.func_70296_d();
    }

    public boolean getShowFloor() {
        return this.showFloor;
    }

    private void setSpawnXPAndDrops(boolean spawn_drops) {
        this.spawnDrops = spawn_drops;
        this.func_70296_d();
    }

    private boolean getSpawnXPAndDrops() {
        return this.spawnDrops;
    }

    private void setDeathTicks(int death_ticks) {
        this.deathTicks = death_ticks;
        this.func_70296_d();
    }

    private int getDeathTicks() {
        return this.deathTicks;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("animationTicks", this.animationTicks);
        nbt.func_74768_a("spawnType", this.getSpawnType());
        nbt.func_74776_a("plugDropTicks", this.plugDropTicks);
        nbt.func_74757_a("plugged", this.isPlugged());
        nbt.func_74757_a("showFloor", this.getShowFloor());
        nbt.func_74757_a("spawnDrops", this.getSpawnXPAndDrops());
        nbt.func_74768_a("deathTicks", this.getDeathTicks());
        nbt.func_74768_a("tentacleCountdown", this.getTentacleSpawnCountDown());
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.animationTicks = nbt.func_74760_g("animationTicks");
        this.setSpawnType(nbt.func_74762_e("spawnType"));
        this.plugDropTicks = nbt.func_74760_g("plugDropTicks");
        this.setPlugged(nbt.func_74767_n("plugged"));
        this.setShowFloor(nbt.func_74767_n("showFloor"));
        this.setSpawnXPAndDrops(nbt.func_74767_n("spawnDrops"));
        this.setDeathTicks(nbt.func_74762_e("deathTicks"));
        this.setTentacleSpawnCountDown(nbt.func_74762_e("tentacleCountdown"));
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_186662_g(10.0);
    }

    public void shake(int shakeTimerMax) {
        this.shakingTimerMax = shakeTimerMax;
        this.prevShakeTimer = this.shakeTimer;
        if (this.shakeTimer == 0) {
            this.shaking = true;
            this.shakeTimer = 1;
        }
        if (this.shakeTimer > 0) {
            ++this.shakeTimer;
        }
        this.shaking = this.shakeTimer < this.shakingTimerMax;
    }

    @Override
    public float getShakeIntensity(Entity viewer, float partialTicks) {
        if (this.isShaking()) {
            double dist = this.getShakeDistance(viewer);
            float shakeMult = (float)(1.0 - dist / 10.0);
            if (dist >= 10.0) {
                return 0.0f;
            }
            return (float)((Math.sin((double)this.getShakingProgress(partialTicks) * Math.PI) + (double)0.1f) * 2.0 * (double)shakeMult);
        }
        return 0.0f;
    }

    public float getShakeDistance(Entity entity) {
        float distX = this.func_174877_v().func_177958_n() - entity.func_180425_c().func_177958_n();
        float distY = this.func_174877_v().func_177956_o() - entity.func_180425_c().func_177956_o();
        float distZ = this.func_174877_v().func_177952_p() - entity.func_180425_c().func_177952_p();
        return MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
    }

    public boolean isShaking() {
        return this.shaking;
    }

    public float getShakingProgress(float delta) {
        return 1.0f / (float)this.shakingTimerMax * ((float)this.prevShakeTimer + (float)(this.shakeTimer - this.prevShakeTimer) * delta);
    }
}

