/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.registries;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.aspect.DefaultItemStackMatchers;
import thebetweenlands.common.herblore.aspect.type.AspectArmaniis;
import thebetweenlands.common.herblore.aspect.type.AspectAzuwynn;
import thebetweenlands.common.herblore.aspect.type.AspectByariis;
import thebetweenlands.common.herblore.aspect.type.AspectByrginaz;
import thebetweenlands.common.herblore.aspect.type.AspectCelawynn;
import thebetweenlands.common.herblore.aspect.type.AspectDayuniis;
import thebetweenlands.common.herblore.aspect.type.AspectFergalaz;
import thebetweenlands.common.herblore.aspect.type.AspectFirnalaz;
import thebetweenlands.common.herblore.aspect.type.AspectFreiwynn;
import thebetweenlands.common.herblore.aspect.type.AspectGeoliirgaz;
import thebetweenlands.common.herblore.aspect.type.AspectOrdaniis;
import thebetweenlands.common.herblore.aspect.type.AspectUduriis;
import thebetweenlands.common.herblore.aspect.type.AspectWodren;
import thebetweenlands.common.herblore.aspect.type.AspectYeowynn;
import thebetweenlands.common.herblore.aspect.type.AspectYihinren;
import thebetweenlands.common.herblore.aspect.type.AspectYunugaz;
import thebetweenlands.common.item.herblore.ItemCrushed;
import thebetweenlands.common.registries.ItemRegistry;

public class AspectRegistry {
    public static final List<IAspectType> ASPECT_TYPES = new ArrayList<IAspectType>();
    public static final IAspectType AZUWYNN = new AspectAzuwynn();
    public static final IAspectType ARMANIIS = new AspectArmaniis();
    public static final IAspectType BYARIIS = new AspectByariis();
    public static final IAspectType BYRGINAZ = new AspectByrginaz();
    public static final IAspectType CELAWYNN = new AspectCelawynn();
    public static final IAspectType DAYUNIIS = new AspectDayuniis();
    public static final IAspectType FERGALAZ = new AspectFergalaz();
    public static final IAspectType FIRNALAZ = new AspectFirnalaz();
    public static final IAspectType FREIWYNN = new AspectFreiwynn();
    public static final IAspectType GEOLIIRGAZ = new AspectGeoliirgaz();
    public static final IAspectType ORDANIIS = new AspectOrdaniis();
    public static final IAspectType YEOWYNN = new AspectYeowynn();
    public static final IAspectType YUNUGAZ = new AspectYunugaz();
    public static final IAspectType YIHINREN = new AspectYihinren();
    public static final IAspectType WODREN = new AspectWodren();
    public static final IAspectType UDURIIS = new AspectUduriis();

    private AspectRegistry() {
    }

    public static IAspectType getAspectTypeFromName(String name) {
        for (IAspectType type : ASPECT_TYPES) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    public static void init() {
        AspectRegistry.registerItems();
        AspectRegistry.registerAspects();
    }

    private static void registerItems() {
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_ALGAE.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_ARROW_ARUM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BLACKHAT_MUSHROOM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BOG_BEAN.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BONESET.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BOTTLE_BRUSH_GRASS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BROOM_SEDGE.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BUTTON_BUSH.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CATTAIL.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CAVE_GRASS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CAVE_MOSS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_COPPER_IRIS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_DRIED_SWAMP_REED.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_FLATHEAD_MUSHROOM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_HANGER.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_LICHEN.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MARSH_HIBISCUS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MARSH_MALLOW.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MILKWEED.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MOSS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_NETTLE.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_PHRAGMITES.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_PICKEREL_WEED.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_SHOOTS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_SLUDGECREEP.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_SOFT_RUSH.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_SWAMP_KELP.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_SWAMP_GRASS_TALL.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_ROOTS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_WEEDWOOD_BARK.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_WATER_WEEDS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_VOLARPAD.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_THORNS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_POISON_IVY.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_GENERIC_LEAF.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.15f, 0.2f, 4);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_FLOWER.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.25f, 0.5f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BLADDERWORT_STALK.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.15f, 0.5f, 4);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BLOOD_SNAIL_SHELL.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.5f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BLUE_IRIS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.5f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BLUE_EYED_GRASS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CARDINAL_FLOWER.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MIRE_CORAL.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MARSH_MARIGOLD.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_GOLDEN_CLUB.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_DEEP_WATER_CORAL.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_MIRE_SNAIL_SHELL.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_BULB_CAPPED_MUSHROOM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_ANGLER_TOOTH.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.85f, 0.45f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_SUNDEW.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 1.25f, 0.5f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_PITCHER_PLANT.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 1.25f, 0.5f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_VENUS_FLY_TRAP.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 1.25f, 0.5f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_EDGE_SHROOM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.425f, 0.35f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_EDGE_SHROOM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 1);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_EDGE_MOSS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.425f, 0.35f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_EDGE_MOSS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_EDGE_LEAF.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.425f, 0.35f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_EDGE_LEAF.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.15f, 0.2f, 3);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_ROTBULB.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.425f, 0.35f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_ROTBULB.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_PALE_GRASS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.85f, 0.45f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_PALE_GRASS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 1);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_STRING_ROOTS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.425f, 0.35f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_STRING_ROOTS.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CRYPTWEED.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 0.425f, 0.35f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CRYPTWEED.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 0.425f, 0.35f, 2);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_GREEN_MIDDLE_GEM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FERGALAZ, 1.75f, 0.25f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_CRIMSON_MIDDLE_GEM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FIRNALAZ, 1.75f, 0.25f);
        AspectManager.addStaticAspectsToItem(ItemCrushed.EnumItemCrushed.GROUND_AQUA_MIDDLE_GEM.create(1), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_BYRGINAZ, 1.75f, 0.25f);
        AspectManager.addStaticAspectsToItem(new ItemStack(ItemRegistry.SAP_SPIT), DefaultItemStackMatchers.ITEM_DAMAGE, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.SAP_SPIT, 1.0f, 0.1f, 2);
    }

    private static void registerAspects() {
        AspectManager.registerAspect(BYARIIS, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 3000);
        AspectManager.registerAspect(AZUWYNN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 1500);
        AspectManager.registerAspect(CELAWYNN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 1500);
        AspectManager.registerAspect(ORDANIIS, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 1500);
        AspectManager.registerAspect(YEOWYNN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.HERB, 1500);
        AspectManager.registerAspect(ARMANIIS, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(BYRGINAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(DAYUNIIS, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(FERGALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(FIRNALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(FREIWYNN, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(YUNUGAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.HERB, 2000);
        AspectManager.registerAspect(GEOLIIRGAZ, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 2500);
        AspectManager.registerAspect(YIHINREN, AspectManager.AspectTier.RARE, AspectManager.AspectGroup.HERB, 2500);
        AspectManager.registerAspect(BYRGINAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_BYRGINAZ, 2000);
        AspectManager.registerAspect(FERGALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FERGALAZ, 2000);
        AspectManager.registerAspect(FIRNALAZ, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.GEM_FIRNALAZ, 2000);
        AspectManager.registerAspect(YEOWYNN, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.SAP_SPIT, 3000);
        AspectManager.registerAspect(ORDANIIS, AspectManager.AspectTier.UNCOMMON, AspectManager.AspectGroup.SAP_SPIT, 3000);
        AspectManager.registerAspect(WODREN, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 2000);
        AspectManager.registerAspect(UDURIIS, AspectManager.AspectTier.COMMON, AspectManager.AspectGroup.SLUDGE_WORM_DUNGEON, 2000);
    }

    static {
        try {
            for (Field f : AspectRegistry.class.getDeclaredFields()) {
                Object obj;
                if (f.getType() != IAspectType.class || !((obj = f.get(null)) instanceof IAspectType)) continue;
                ASPECT_TYPES.add((IAspectType)obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

