/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.loot.shared;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thebetweenlands.api.loot.ISharedLootCondition;
import thebetweenlands.api.loot.ISharedLootPool;
import thebetweenlands.api.loot.LootTableView;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.loot.LootConditionFromSharedPool;
import thebetweenlands.common.loot.LootConditionSharedPool;
import thebetweenlands.common.loot.shared.SharedLootPool;

public class SharedLootTableView
extends LootTableView {
    private static final Field f_LootTable_pools = ReflectionHelper.findField(LootTable.class, (String[])new String[]{"pools", "field_186466_c", "c"});
    private static final Field f_LootPool_lootEntries = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"lootEntries", "field_186453_a", "a"});
    private static final Field f_LootPool_poolConditions = ReflectionHelper.findField(LootPool.class, (String[])new String[]{"poolConditions", "field_186454_b", "b"});
    private static final Field f_LootEntry_conditions = ReflectionHelper.findField(LootEntry.class, (String[])new String[]{"conditions", "field_186366_e", "e"});
    protected final SharedLootPool primarySharedPool;

    public SharedLootTableView(SharedLootPool primarySharedPool) {
        Preconditions.checkNotNull((Object)primarySharedPool);
        this.primarySharedPool = primarySharedPool;
    }

    public List<ItemStack> func_186462_a(Random rand, LootContext context) {
        return this.generateLootFromSharedPool(rand, context);
    }

    protected List<ItemStack> generateLootFromSharedPool(Random rand, LootContext context) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        LootTable lootTable = this.getSharedLootTableInstance(this.primarySharedPool, context.func_186497_e());
        if (lootTable != null) {
            ArrayList pools = new ArrayList();
            try {
                pools.addAll((List)f_LootTable_pools.get(lootTable));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            ArrayList<LootPool> sharedPools = new ArrayList<LootPool>();
            Iterator poolsIT = pools.iterator();
            while (poolsIT.hasNext()) {
                LootPool pool = (LootPool)poolsIT.next();
                if (!LootConditionSharedPool.isSharedPool(rand, context, this.getPoolConditions(pool, true))) continue;
                sharedPools.add(pool);
                poolsIT.remove();
            }
            Collections.shuffle(pools, rand);
            this.primarySharedPool.incrementGuaranteeCounter();
            long sharedPoolSeed = rand.nextLong();
            long setSharedPoolSeed = this.primarySharedPool.getLootTableSeed();
            Random sharedPoolRNG = setSharedPoolSeed != 0L ? new Random(setSharedPoolSeed) : new Random(sharedPoolSeed);
            HashMap<EntryKey, List<ItemStack>> sharedPoolItems = new HashMap<EntryKey, List<ItemStack>>();
            for (LootPool pool : sharedPools) {
                this.generateLootForPoolFromSharedPool(sharedPoolItems, sharedPoolRNG, context, pool, true);
            }
            HashMap<EntryKey, List<ItemStack>> poolItems = new HashMap<EntryKey, List<ItemStack>>();
            for (LootPool pool : pools) {
                this.generateLootForPoolFromSharedPool(poolItems, rand, context, pool, false);
            }
            for (EntryKey lootEntryKey : poolItems.keySet()) {
                List loot = (List)poolItems.get(lootEntryKey);
                if (lootEntryKey.isNonSharedEntry) {
                    stacks.addAll(loot);
                    continue;
                }
                block6: for (ItemStack lootStack : loot) {
                    int availableLootCount = 0;
                    block7: for (Map.Entry sharedLootEntry : sharedPoolItems.entrySet()) {
                        EntryKey sharedLootEntryKey = (EntryKey)sharedLootEntry.getKey();
                        List sharedLoot = (List)sharedLootEntry.getValue();
                        Iterator sharedLootStackIT = sharedLoot.iterator();
                        while (sharedLootStackIT.hasNext()) {
                            int additionalAvailableCount;
                            ItemStack sharedLootStack = (ItemStack)sharedLootStackIT.next();
                            if (lootStack.func_190926_b() && sharedLootStack.func_190926_b()) {
                                sharedLootStackIT.remove();
                                int removedItems = this.primarySharedPool.getRemovedItems(sharedLootEntryKey.pool, sharedLootEntryKey.poolRoll, sharedLootEntryKey.entry);
                                this.primarySharedPool.setRemovedItems(sharedLootEntryKey.pool, sharedLootEntryKey.poolRoll, sharedLootEntryKey.entry, removedItems + 1);
                                sharedLootStackIT.remove();
                                stacks.add(ItemStack.field_190927_a);
                                continue block6;
                            }
                            if (lootStack.func_190926_b() || sharedLootStack.func_190926_b() || lootStack.func_77973_b() != sharedLootStack.func_77973_b() || (additionalAvailableCount = Math.min(lootStack.func_190916_E() - availableLootCount, sharedLootStack.func_190916_E())) <= 0) continue;
                            availableLootCount += additionalAvailableCount;
                            sharedLootStack.func_190918_g(additionalAvailableCount);
                            if (sharedLootStack.func_190926_b()) {
                                sharedLootStackIT.remove();
                            }
                            int removedItems = this.primarySharedPool.getRemovedItems(sharedLootEntryKey.pool, sharedLootEntryKey.poolRoll, sharedLootEntryKey.entry);
                            this.primarySharedPool.setRemovedItems(sharedLootEntryKey.pool, sharedLootEntryKey.poolRoll, sharedLootEntryKey.entry, removedItems + additionalAvailableCount);
                            if (availableLootCount < lootStack.func_190916_E()) continue;
                            break block7;
                        }
                    }
                    if (availableLootCount <= 0) continue;
                    lootStack.func_190920_e(availableLootCount);
                    stacks.add(lootStack.func_77946_l());
                }
            }
        }
        return stacks;
    }

    protected List<LootCondition> getPoolConditions(LootPool pool, boolean sharedConditions) {
        List allConditions;
        try {
            allConditions = (List)f_LootPool_poolConditions.get(pool);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        ArrayList<LootCondition> conditions = new ArrayList<LootCondition>();
        for (LootCondition condition : allConditions) {
            if (condition instanceof LootConditionSharedPool != sharedConditions) continue;
            conditions.add(condition);
        }
        return conditions;
    }

    protected List<LootCondition> getEntryConditions(LootEntry entry, boolean sharedConditions) {
        LootCondition[] allConditions;
        try {
            allConditions = (LootCondition[])f_LootEntry_conditions.get(entry);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        ArrayList<LootCondition> conditions = new ArrayList<LootCondition>();
        for (LootCondition condition : allConditions) {
            if (condition instanceof LootConditionFromSharedPool != sharedConditions) continue;
            conditions.add(condition);
        }
        return conditions;
    }

    protected boolean testAllConditions(Iterable<LootCondition> conditions, Random rand, LootContext context) {
        if (conditions == null) {
            return true;
        }
        for (LootCondition condition : conditions) {
            if (!(this.primarySharedPool != null && condition instanceof ISharedLootCondition ? !((ISharedLootCondition)condition).testCondition(rand, context, this.primarySharedPool) : !condition.func_186618_a(rand, context))) continue;
            return false;
        }
        return true;
    }

    protected void generateLootForPoolFromSharedPool(Map<EntryKey, List<ItemStack>> stacks, Random rand, LootContext context, LootPool pool, boolean isSharedPool) {
        if (context.func_186496_a((LootTable)this)) {
            this.generateLootFromSharedPool(stacks, rand, context, pool, isSharedPool);
            context.func_186490_b((LootTable)this);
        } else {
            TheBetweenlands.logger.warn("Detected infinite loop in loot tables");
        }
    }

    protected void generateLootFromSharedPool(Map<EntryKey, List<ItemStack>> stacks, Random rand, LootContext context, LootPool pool, boolean isSharedPool) {
        List<LootCondition> poolConditions = this.getPoolConditions(pool, false);
        RandomValueRange rolls = pool.getRolls();
        RandomValueRange bonusRolls = pool.getBonusRolls();
        if (this.testAllConditions(poolConditions, rand, context)) {
            Random poolRand = rand;
            if (isSharedPool) {
                poolRand = new Random(this.primarySharedPool.getLootPoolSeed(rand, pool.getName(), -1));
            }
            int count = rolls.func_186511_a(poolRand) + MathHelper.func_76141_d((float)(bonusRolls.func_186507_b(poolRand) * context.func_186491_f()));
            for (int i = 0; i < count; ++i) {
                this.createLootRollFromSharedPool(stacks, rand, context, pool, isSharedPool, i);
            }
        }
    }

    protected boolean createLootRollFromSharedPool(Map<EntryKey, List<ItemStack>> stacks, Random rand, LootContext context, LootPool pool, boolean isSharedPool, int poolRoll) {
        List lootEntries;
        int totalWeights = 0;
        try {
            lootEntries = (List)f_LootPool_lootEntries.get(pool);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Tuple> potentialLootEntries = new ArrayList<Tuple>();
        ArrayList<Tuple> guaranteedEntries = new ArrayList<Tuple>();
        int guaranteeCounter = this.primarySharedPool.getGuaranteeCounter();
        float guaranteePercentage = this.primarySharedPool.getGuaranteePercentage();
        for (LootEntry lootEntry : lootEntries) {
            boolean isGuaranteed;
            LootConditionFromSharedPool fromSharedPoolCondition = LootConditionFromSharedPool.getCondition(rand, context, this.getEntryConditions(lootEntry, true));
            boolean bl = isGuaranteed = !isSharedPool && fromSharedPoolCondition != null && fromSharedPoolCondition.isGuaranteed(guaranteePercentage, guaranteeCounter);
            if (!isGuaranteed && !this.testAllConditions(this.getEntryConditions(lootEntry, false), rand, context)) continue;
            int weight = lootEntry.func_186361_a(context.func_186491_f());
            if (!isGuaranteed && weight <= 0) continue;
            ArrayList generatedStacks = new ArrayList();
            Random entryRand = rand;
            if (isSharedPool) {
                entryRand = new Random(this.primarySharedPool.getLootEntrySeed(rand, pool.getName(), poolRoll, lootEntry.getEntryName()));
            }
            lootEntry.func_186363_a(generatedStacks, entryRand, context);
            if (isGuaranteed) {
                guaranteedEntries.add(new Tuple((Object)lootEntry, generatedStacks));
                continue;
            }
            potentialLootEntries.add(new Tuple((Object)lootEntry, generatedStacks));
            totalWeights += weight;
        }
        ArrayList<Tuple> validEntries = new ArrayList<Tuple>();
        if (!guaranteedEntries.isEmpty()) {
            validEntries.addAll(guaranteedEntries);
        } else if (totalWeights != 0 && !potentialLootEntries.isEmpty()) {
            Random poolRand = rand;
            if (isSharedPool) {
                poolRand = new Random(this.primarySharedPool.getLootPoolSeed(rand, pool.getName(), poolRoll));
            }
            int randomWeight = poolRand.nextInt(totalWeights);
            for (Tuple potentialEntry : potentialLootEntries) {
                if ((randomWeight -= ((LootEntry)potentialEntry.func_76341_a()).func_186361_a(context.func_186491_f())) >= 0) continue;
                validEntries.add(potentialEntry);
                break;
            }
        }
        if (!validEntries.isEmpty()) {
            for (Tuple validEntry : validEntries) {
                LootEntry lootEntry = (LootEntry)validEntry.func_76341_a();
                List loot = (List)validEntry.func_76340_b();
                boolean isLootEntryStillAvailable = true;
                if (isSharedPool) {
                    int removedItems = this.primarySharedPool.getRemovedItems(pool.getName(), poolRoll, lootEntry.getEntryName());
                    if (!loot.isEmpty()) {
                        this.removeRandomItems(rand, loot, removedItems);
                        if (!loot.isEmpty()) {
                            int count = 0;
                            for (ItemStack stack : loot) {
                                count += stack.func_190916_E();
                            }
                            isLootEntryStillAvailable = count > 0;
                        } else {
                            isLootEntryStillAvailable = false;
                        }
                    } else {
                        isLootEntryStillAvailable = removedItems <= 0;
                    }
                }
                if (!isLootEntryStillAvailable) continue;
                EntryKey key = isSharedPool ? new EntryKey(pool.getName(), poolRoll, lootEntry.getEntryName(), false) : new EntryKey(pool.getName(), poolRoll, lootEntry.getEntryName(), !LootConditionFromSharedPool.isFromSharedPool(rand, context, this.getEntryConditions(lootEntry, true)));
                List<ItemStack> entryStacks = stacks.get(key);
                if (entryStacks == null) {
                    entryStacks = new ArrayList<ItemStack>();
                    stacks.put(key, entryStacks);
                }
                entryStacks.addAll(loot);
                return true;
            }
        }
        return false;
    }

    protected int removeRandomItems(Random rand, List<ItemStack> loot, int count) {
        if (loot.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < count; ++i) {
            int randStack = rand.nextInt(loot.size());
            ItemStack stack = loot.get(randStack);
            stack.func_190918_g(1);
            if (stack.func_190926_b()) {
                loot.remove(randStack);
            }
            if (!loot.isEmpty()) continue;
            return i;
        }
        return count;
    }

    @Nullable
    protected LootTable getSharedLootTableInstance(ISharedLootPool pool, LootTableManager manager) {
        if (pool.getLootTable() != null) {
            return manager.func_186521_a(pool.getLootTable());
        }
        return null;
    }

    protected static class EntryKey {
        protected final String pool;
        protected final String entry;
        protected final int poolRoll;
        protected final boolean isNonSharedEntry;
        private final int hashCode;

        protected EntryKey(String pool, int poolRoll, String entry, boolean isNonSharedEntry) {
            this.pool = pool;
            this.poolRoll = poolRoll;
            this.entry = entry;
            this.isNonSharedEntry = isNonSharedEntry;
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + this.entry.hashCode();
            this.hashCode = hashCode = 31 * hashCode + this.pool.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntryKey other = (EntryKey)obj;
            return other.entry.equals(this.entry) && other.pool.equals(this.pool);
        }
    }
}

