/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.entity.mobs.EntityEmberling;
import thebetweenlands.common.entity.mobs.EntityEmberlingWild;
import thebetweenlands.common.item.IGenericItem;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemMisc
extends Item
implements ItemRegistry.IMultipleItemModelDefinition {
    public ItemMisc() {
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            Stream.of(EnumItemMisc.values()).forEach(t -> list.add((Object)t.create(1)));
        }
    }

    public String func_77667_c(ItemStack stack) {
        try {
            return "item.thebetweenlands." + IGenericItem.getFromStack(EnumItemMisc.class, stack).getTranslationKey();
        }
        catch (Exception e) {
            return "item.thebetweenlands.unknown_generic";
        }
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        for (EnumItemMisc type : EnumItemMisc.values()) {
            models.put(type.getID(), new ResourceLocation("thebetweenlands", type.getModelName()));
        }
        return models;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (EnumItemMisc.SCROLL.isItemOf(stack) || EnumItemMisc.TAR_BEAST_HEART.isItemOf(stack) || EnumItemMisc.TAR_BEAST_HEART_ANIMATED.isItemOf(stack) || EnumItemMisc.INANIMATE_TARMINION.isItemOf(stack)) {
            return EnumRarity.UNCOMMON;
        }
        if (EnumItemMisc.AMULET_SOCKET.isItemOf(stack) || EnumItemMisc.LOOT_SCRAPS.isItemOf(stack) || EnumItemMisc.FABRICATED_SCROLL.isItemOf(stack)) {
            return EnumRarity.RARE;
        }
        return super.func_77613_e(stack);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityEmberlingWild && EnumItemMisc.UNDYING_EMBER.isItemOf(stack)) {
            EntityEmberlingWild oldEmberling = (EntityEmberlingWild)target;
            EntityEmberling newEmberling = new EntityEmberling(player.func_130014_f_());
            if (!player.func_130014_f_().field_72995_K) {
                newEmberling.func_82149_j((Entity)oldEmberling);
                newEmberling.func_193101_c(player);
                player.func_130014_f_().func_72900_e((Entity)oldEmberling);
                player.func_130014_f_().func_72838_d((Entity)newEmberling);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                }
                return true;
            }
            oldEmberling.playTameEffect(true);
            return true;
        }
        return false;
    }

    public static enum EnumItemMisc implements IGenericItem
    {
        BLOOD_SNAIL_SHELL(0),
        MIRE_SNAIL_SHELL(1),
        COMPOST(2),
        DRAGONFLY_WING(3),
        LURKER_SKIN(4),
        DRIED_SWAMP_REED(6),
        SWAMP_REED_ROPE(7),
        MUD_BRICK(10),
        SYRMORITE_INGOT(11),
        DRY_BARK(13),
        SLIMY_BONE(14),
        SNAPPER_ROOT(16),
        STALKER_EYE(17),
        SULFUR(18),
        VALONITE_SHARD(19),
        WEEDWOOD_STICK(20),
        ANGLER_TOOTH(21),
        WEEDWOOD_BOWL(22),
        RUBBER_BALL(23),
        TAR_BEAST_HEART(24),
        TAR_BEAST_HEART_ANIMATED(25),
        TAR_DRIP(26),
        LIMESTONE_FLUX(27),
        INANIMATE_TARMINION(29),
        POISON_GLAND(30),
        PARCHMENT(32),
        SHOCKWAVE_SWORD_1(33),
        SHOCKWAVE_SWORD_2(34),
        SHOCKWAVE_SWORD_3(35),
        SHOCKWAVE_SWORD_4(36),
        AMULET_SOCKET(38),
        SCABYST(39),
        SCROLL(40),
        SYRMORITE_NUGGET(41),
        OCTINE_NUGGET(42),
        VALONITE_SPLINTER(43),
        CREMAINS(44),
        UNDYING_EMBER(45),
        INANIMATE_ANGRY_PEBBLE(46),
        ANCIENT_REMNANT(47),
        LOOT_SCRAPS(48),
        FABRICATED_SCROLL(49);

        private final int id;
        private final String unlocalizedName;
        private final String modelName;

        private EnumItemMisc(int id) {
            this.id = id;
            this.unlocalizedName = this.modelName = this.name().toLowerCase(Locale.ENGLISH);
        }

        @Override
        public String getTranslationKey() {
            return this.unlocalizedName;
        }

        @Override
        public String getModelName() {
            return this.modelName;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public Item getItem() {
            return ItemRegistry.ITEMS_MISC;
        }
    }
}

