/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemLoreScrap
extends Item
implements ItemRegistry.IMultipleItemModelDefinition {
    public static final String[] PAGE_NAMES = new String[]{"them", "mutants", "shadows", "ruins", "heads", "tar", "dungeon", "pitstone", "tower", "fort"};

    public ItemLoreScrap() {
        this.field_77777_bU = 1;
        this.func_77637_a(BLCreativeTabs.SPECIALS);
        this.func_185043_a(new ResourceLocation("page"), (stack, worldIn, entityIn) -> ItemLoreScrap.getPage(stack));
    }

    public static ItemStack createStack(int page) {
        ItemStack stack = new ItemStack(ItemRegistry.LORE_SCRAP);
        ItemLoreScrap.setPage(stack, page);
        return stack;
    }

    public static ItemStack createRandomStack(Random random) {
        ItemStack stack = new ItemStack(ItemRegistry.LORE_SCRAP);
        stack = ItemLoreScrap.setRandomPage(stack, random);
        return stack;
    }

    public static ItemStack setRandomPage(ItemStack stack, Random random) {
        ItemLoreScrap.setPage(stack, random.nextInt(PAGE_NAMES.length));
        return stack;
    }

    public static ItemStack setPage(ItemStack stack, int page) {
        if (page >= 0 && page < PAGE_NAMES.length) {
            stack.func_77964_b(page);
        }
        return stack;
    }

    public static int getPage(ItemStack stack) {
        int dmg = stack.func_77952_i();
        if (dmg >= 0 && dmg < PAGE_NAMES.length) {
            return dmg;
        }
        return -1;
    }

    @Nullable
    public static String getPageName(ItemStack stack) {
        int page = ItemLoreScrap.getPage(stack);
        if (page != -1) {
            return PAGE_NAMES[page];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < PAGE_NAMES.length; ++i) {
                ItemStack stack = new ItemStack((Item)this);
                ItemLoreScrap.setPage(stack, i);
                subItems.add((Object)stack);
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        String pageName = ItemLoreScrap.getPageName(stack);
        if (pageName != null) {
            return super.func_77658_a() + "." + pageName;
        }
        return super.func_77658_a();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (ItemLoreScrap.getPage(itemStackIn) != -1) {
            playerIn.openGui((Object)TheBetweenlands.instance, 10, worldIn, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> map = new HashMap<Integer, ResourceLocation>();
        for (int i = 0; i < PAGE_NAMES.length; ++i) {
            map.put(i, this.getRegistryName());
        }
        return map;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

