/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.farming;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import thebetweenlands.api.block.IFarmablePlant;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.farming.BlockGenericDugSoil;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityDugSoil;

public class ItemPlantTonic
extends Item
implements ItemRegistry.IMultipleItemModelDefinition {
    public ItemPlantTonic() {
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            items.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getUsages(stack) / 3.0f;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getUsages(stack) > 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return super.initCapabilities(stack, nbt);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IPlantable || state.func_177230_c() instanceof IFarmablePlant) {
            while (world.func_180495_p(pos).func_177230_c() instanceof IPlantable || world.func_180495_p(pos).func_177230_c() instanceof IFarmablePlant) {
                pos = pos.func_177977_b();
            }
        }
        if ((state = world.func_180495_p(pos)).func_177230_c() instanceof BlockGenericDugSoil && BlockGenericDugSoil.getTile(world, pos) != null) {
            boolean cured = false;
            for (int xo = -2; xo <= 2; ++xo) {
                for (int yo = -2; yo <= 2; ++yo) {
                    for (int zo = -2; zo <= 2; ++zo) {
                        BlockPos offsetPos = pos.func_177982_a(xo, yo, zo);
                        TileEntityDugSoil te = BlockGenericDugSoil.getTile(world, offsetPos);
                        if (te == null || te.getDecay() <= 0) continue;
                        cured = true;
                        if (!world.field_72995_K) {
                            te.setDecay(0);
                            continue;
                        }
                        ItemDye.func_180617_a((World)world, (BlockPos)offsetPos.func_177984_a(), (int)6);
                    }
                }
            }
            if (cured) {
                if (!world.field_72995_K && !player.func_184812_l_()) {
                    this.setUsages(stack, this.getUsages(stack) + 1);
                    if (this.getUsages(stack) >= 3) {
                        player.func_184611_a(hand, new ItemStack((Item)ItemRegistry.BL_BUCKET, 1, this.getMetadata(stack)));
                    }
                }
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187624_K, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private NBTTagCompound getNBT(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            compound.func_74768_a("usages", 0);
            stack.func_77982_d(compound);
        }
        return compound;
    }

    private void setUsages(ItemStack stack, int usage) {
        this.getNBT(stack).func_74768_a("usages", Math.max(usage, 0));
    }

    private int getUsages(ItemStack stack) {
        return this.getNBT(stack).func_74762_e("usages");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= 2) {
            return this.func_77658_a() + ".unknown";
        }
        return this.func_77658_a() + (stack.func_77960_j() == 0 ? "_weedwood" : "_syrmorite");
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        models.put(0, new ResourceLocation(this.getRegistryName().toString() + "_weedwood"));
        models.put(1, new ResourceLocation(this.getRegistryName().toString() + "_syrmorite"));
        return models;
    }
}

