/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.elixir;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;

public class PotionRootBound
extends Potion {
    public PotionRootBound() {
        super(true, 5926017);
        this.setRegistryName(new ResourceLocation("thebetweenlands", "root_bound"));
        this.func_76390_b("bl.potion.rootBound");
        this.func_76399_b(1, 0);
        this.func_111184_a(SharedMonsterAttributes.field_111263_d, "be8859c1-024b-4f31-b606-5991011ddd98", -1.0, 2);
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70660_b(ElixirEffectRegistry.ROOT_BOUND) != null) {
            entity.field_70159_w = 0.0;
            entity.field_70179_y = 0.0;
            if (entity.field_70181_x > -0.1) {
                entity.field_70181_x = -0.1;
                entity.field_70133_I = true;
            }
        }
    }

    public boolean shouldRender(PotionEffect effect) {
        return false;
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return false;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }

    @SubscribeEvent
    public static void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70660_b(ElixirEffectRegistry.ROOT_BOUND) != null) {
            entity.func_70110_aj();
            entity.field_70179_y = 0.0;
            entity.field_70159_w = 0.0;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayer player;
        if (event.phase == TickEvent.Phase.END && (player = TheBetweenlands.proxy.getClientPlayer()) != null) {
            PotionRootBound.updatePlayerRootboundTicks((EntityLivingBase)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void updatePlayerRootboundTicks(EntityLivingBase entity) {
        NBTTagCompound nbt = entity.getEntityData();
        if (entity.func_70660_b(ElixirEffectRegistry.ROOT_BOUND) != null) {
            nbt.func_74768_a("thebetweenlands.rootBoundTicks", 5);
        } else {
            int rootBoundTicks = nbt.func_74762_e("thebetweenlands.rootBoundTicks");
            if (rootBoundTicks > 1) {
                nbt.func_74768_a("thebetweenlands.rootBoundTicks", rootBoundTicks - 1);
            } else {
                nbt.func_82580_o("thebetweenlands.rootBoundTicks");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onFovUpdate(FOVUpdateEvent event) {
        EntityPlayer entity = event.getEntity();
        NBTTagCompound nbt = entity.getEntityData();
        if (entity.func_70660_b(ElixirEffectRegistry.ROOT_BOUND) != null || nbt.func_74764_b("thebetweenlands.rootBoundTicks")) {
            event.setNewfov(1.0f);
        }
    }
}

