/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.network.clientbound.MessageDamageReductionParticle;
import thebetweenlands.common.network.clientbound.MessagePowerRingParticles;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class AttackDamageHandler {
    public static final float DAMAGE_REDUCTION = 0.3f;

    @SubscribeEvent
    public static void onEntityKnockback(LivingKnockBackEvent event) {
        EntityLivingBase entityLiving;
        ItemStack heldItem;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        Entity attacker = event.getAttacker();
        if (attackedEntity instanceof IEntityBL && attacker instanceof EntityLivingBase && ((EntityLivingBase)attacker).func_184600_cs() != null && !(heldItem = (entityLiving = (EntityLivingBase)attacker).func_184586_b(entityLiving.func_184600_cs())).func_190926_b() && OverworldItemHandler.isToolWeakened(heldItem)) {
            event.setStrength(event.getStrength() * 0.3f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityAttack(LivingAttackEvent event) {
        DamageSource source;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        if (AttackDamageHandler.canBlockDamageSource(attackedEntity, source = event.getSource())) {
            CircleGemHelper.handleAttack(source, attackedEntity, event.getAmount());
        }
    }

    private static boolean canBlockDamageSource(EntityLivingBase entity, DamageSource source) {
        Vec3d location;
        if (!source.func_76363_c() && entity.func_184585_cz() && (location = source.func_188404_v()) != null) {
            Vec3d look = entity.func_70676_i(1.0f);
            Vec3d diff = location.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            diff = new Vec3d(diff.field_72450_a, 0.0, diff.field_72449_c);
            if (diff.func_72430_b(look) < 0.0) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        IEquipmentCapability cap;
        EntityLivingBase attackedEntity = event.getEntityLiving();
        DamageSource source = event.getSource();
        float damage = event.getAmount();
        Entity entity = source.func_76346_g();
        if (attackedEntity instanceof IEntityBL && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184600_cs() != null) {
            EntityLivingBase attacker = (EntityLivingBase)entity;
            ItemStack heldItem = attacker.func_184586_b(attacker.func_184600_cs());
            if (heldItem.func_190926_b() || OverworldItemHandler.isToolWeakened(heldItem)) {
                damage = Math.min(damage, 40.0f);
            }
            if (!heldItem.func_190926_b() && OverworldItemHandler.isToolWeakened(heldItem)) {
                damage *= 0.3f;
                if (!attackedEntity.field_70170_p.field_72995_K) {
                    RayTraceResult result;
                    Vec3d center = attackedEntity.func_174791_d().func_72441_c(0.0, (double)(attackedEntity.field_70131_O / 2.0f), 0.0);
                    Vec3d hitOffset = null;
                    Entity immediateAttacker = source.func_76364_f();
                    if ((immediateAttacker == null || attacker == immediateAttacker) && (result = attackedEntity.func_174813_aQ().func_72327_a(attacker.func_174824_e(1.0f), attacker.func_174824_e(1.0f).func_178787_e(attacker.func_70040_Z().func_186678_a(10.0)))) != null) {
                        hitOffset = result.field_72307_f.func_178788_d(center);
                    }
                    if (immediateAttacker != null && hitOffset == null) {
                        hitOffset = immediateAttacker.func_174791_d().func_72441_c(0.0, (double)(immediateAttacker.field_70131_O / 2.0f), 0.0).func_178788_d(center);
                    }
                    if (hitOffset != null) {
                        Vec3d offsetDirXZ = new Vec3d(hitOffset.field_72450_a, 0.0, hitOffset.field_72449_c).func_72432_b();
                        Vec3d offset = offsetDirXZ.func_186678_a((double)attackedEntity.field_70130_N).func_72441_c(0.0, hitOffset.field_72448_b + (double)(attackedEntity.field_70131_O / 2.0f), 0.0);
                        attackedEntity.field_70170_p.func_184148_a(null, attackedEntity.field_70165_t, attackedEntity.field_70163_u + 0.5, attackedEntity.field_70161_v, (SoundEvent)SoundRegistry.DAMAGE_REDUCTION, SoundCategory.PLAYERS, 0.7f, 0.75f + attackedEntity.field_70170_p.field_73012_v.nextFloat() * 0.3f);
                        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageDamageReductionParticle((Entity)attackedEntity, offset, offsetDirXZ.func_186678_a((double)(attackedEntity.field_70130_N + 0.2f)).func_72432_b()), new NetworkRegistry.TargetPoint(attackedEntity.field_71093_bK, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 32.0));
                    }
                }
            }
        }
        damage = CircleGemHelper.handleAttack(source, attackedEntity, damage);
        if (entity instanceof EntityLivingBase && (cap = (IEquipmentCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null)) != null) {
            IInventory inv = cap.getInventory(EnumEquipmentInventory.RING);
            int rings = 0;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.RING_OF_POWER || stack.func_77952_i() >= stack.func_77958_k()) continue;
                ++rings;
            }
            if (rings > 0) {
                TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessagePowerRingParticles((Entity)attackedEntity), new NetworkRegistry.TargetPoint(attackedEntity.field_71093_bK, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 32.0));
            }
            damage *= 1.0f + 0.5f * (float)rings;
        }
        event.setAmount(damage);
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnDamageReductionParticle(Entity entity, Vec3d offset, Vec3d dir) {
        BLParticles.DAMAGE_REDUCTION.spawn(entity.field_70170_p, 0.0, 0.0, 0.0, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(2.0f)).withData(entity, offset, dir));
    }

    @SideOnly(value=Side.CLIENT)
    public static void spawnPowerRingParticles(Entity entityHit) {
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t + (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.08, 0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v + (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.05, 0.08));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t - (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(-0.08, 0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v - (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, 0.05, -0.08));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t + (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.08, -0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v + (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, -0.05, 0.08));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t - (double)entityHit.field_70130_N / 2.0, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(-0.08, -0.05, 0.0));
        BLParticles.GREEN_FLAME.spawn(entityHit.field_70170_p, entityHit.field_70165_t, entityHit.field_70163_u + (double)entityHit.field_70131_O / 2.0 + 0.5, entityHit.field_70161_v - (double)entityHit.field_70130_N / 2.0, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(0.0, -0.05, -0.08));
    }
}

